/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.ecm.EcmCommonCommands;
import org.osivia.portal.api.ecm.EcmViews;
import org.osivia.portal.api.html.AccessibilityRoles;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSExtendedDocumentInfos;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemTypeComparator;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;

public class MenuBarFormater {
    private static final Log LOGGER = LogFactory.getLog(MenuBarFormater.class);
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final CMSService cmsService;
    private final IPortalUrlFactory urlFactory;
    private final DefaultCMSCustomizer customizer;
    private final IContributionService contributionService;
    private final IBundleFactory bundleFactory;

    public MenuBarFormater(PortletContext portletCtx, DefaultCMSCustomizer customizer, CMSService cmsService) {
        this.cmsService = cmsService;
        this.urlFactory = (IPortalUrlFactory)portletCtx.getAttribute("UrlService");
        this.customizer = customizer;
        this.contributionService = (IContributionService)Locator.findMBean(IContributionService.class, (String)"osivia:service=ContributionService");
        IInternationalizationService internationalizationService = (IInternationalizationService)portletCtx.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void formatDefaultContentMenuBar(CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, CMSExtendedDocumentInfos extendedInfos) throws CMSException, PortalException {
        block9: {
            if (cmsContext.getDoc() == null && cmsContext.getCreationPath() == null) {
                return;
            }
            PortletRequest request = cmsContext.getRequest();
            PortalControllerContext portalControllerContext = new PortalControllerContext(cmsContext.getPortletCtx(), request, (PortletResponse)cmsContext.getResponse());
            Bundle bundle = this.bundleFactory.getBundle(cmsContext.getRequest().getLocale());
            List menubar = (List)request.getAttribute("osivia.menuBar");
            Portal portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext());
            boolean webPageFragment = false;
            if (PortalObjectUtils.isSpaceSite((PortalObject)portal) && cmsContext.getDoc() != null) {
                String webPagePath = (String)request.getAttribute("osivia.cms.webPagePath");
                String docLivePath = ContextualizationHelper.getLivePath((String)((Document)cmsContext.getDoc()).getPath());
                if (StringUtils.equals((String)docLivePath, (String)webPagePath)) {
                    webPageFragment = true;
                }
            }
            boolean userWorkspace = false;
            if (cmsContext.getDoc() != null) {
                Document document = (Document)cmsContext.getDoc();
                String path = document.getPath() + "/";
                List userWorkspaces = this.cmsService.getWorkspaces(cmsContext, true, false);
                for (CMSItem cmsItem : userWorkspaces) {
                    if (!StringUtils.startsWith((String)path, (String)(cmsItem.getPath() + "/"))) continue;
                    userWorkspace = true;
                    break;
                }
            }
            try {
                this.getCreateLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                if (cmsContext.getDoc() != null && !webPageFragment) {
                    this.getPermaLinkLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getContextualizationLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getChangeModeLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                    this.getEditLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getDriveEditUrl(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                    this.getMoveLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getReorderLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getDeleteLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getLiveContentBrowserLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getSynchronizeLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                    this.getAdministrationLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getEditWksLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    if (!userWorkspace) {
                        this.getSubscribeLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                        this.getLockLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                        this.getValidationWfLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                        this.getRemotePublishingLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                    }
                }
            }
            catch (CMSException e) {
                if (e.getErrorCode() == 1 || e.getErrorCode() == 3) break block9;
                throw e;
            }
        }
    }

    public void formatContentMenuBar(CMSServiceCtx cmsCtx, CMSPublicationInfos publicationInfos, CMSExtendedDocumentInfos extendedDocumentInfos) throws Exception {
        this.formatDefaultContentMenuBar(cmsCtx, publicationInfos, extendedDocumentInfos);
    }

    public boolean hasWebId(CMSServiceCtx cmsCtx) {
        boolean has = false;
        Document document = (Document)cmsCtx.getDoc();
        if (document != null) {
            String webid = document.getString("ttc:webid");
            has = StringUtils.isNotBlank((String)webid);
        }
        return has;
    }

    protected MenubarDropdown getCMSEditionDropdown(PortalControllerContext portalControllerContext, DocumentType type, Bundle bundle) {
        MenubarDropdown dropdown = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
        if (dropdown == null) {
            dropdown = new MenubarDropdown("CMS_EDITION", bundle.getString("CMS_EDITION"), "halflings halflings-pencil", MenubarGroup.CMS, 3, false, false);
            dropdown.setBreadcrumb(type != null && type.isFolderish() && BooleanUtils.isNotTrue((Boolean)type.getEditorialContent()));
            this.menubarService.addDropdown(portalControllerContext, dropdown);
        }
        return dropdown;
    }

    protected MenubarDropdown getShareDropdown(PortalControllerContext portalControllerContext, Bundle bundle) {
        MenubarDropdown dropdown = this.menubarService.getDropdown(portalControllerContext, "SHARE");
        if (dropdown == null) {
            dropdown = new MenubarDropdown("SHARE", bundle.getString("SHARE"), "glyphicons glyphicons-share-alt", MenubarGroup.GENERIC, 8);
            this.menubarService.addDropdown(portalControllerContext, dropdown);
        }
        return dropdown;
    }

    protected MenubarDropdown getOtherOptionsDropdown(PortalControllerContext portalControllerContext, Bundle bundle) {
        MenubarDropdown dropdown = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
        if (dropdown == null) {
            dropdown = new MenubarDropdown("OTHER_OPTIONS", bundle.getString("OTHER_OPTIONS"), "glyphicons glyphicons-option-vertical", MenubarGroup.GENERIC, 40, false, false);
            this.menubarService.addDropdown(portalControllerContext, dropdown);
        }
        return dropdown;
    }

    protected void getAdministrationLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        if (pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            String url = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + pubInfos.getLiveId() + "/view_documents";
            MenubarDropdown parent = this.getOtherOptionsDropdown(portalControllerContext, bundle);
            MenubarItem item = new MenubarItem("MANAGE", bundle.getString("MANAGE_IN_NUXEO"), null, (MenubarContainer)parent, 21, url, "nuxeo", null, null);
            item.setAjaxDisabled(true);
            item.setDivider(true);
            menubar.add(item);
        }
    }

    protected void getChangeModeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, CMSExtendedDocumentInfos extendedInfos) throws CMSException, PortalException {
        if (cmsContext.getRequest().getRemoteUser() == null || StringUtils.isBlank((String)pubInfos.getPublishSpacePath())) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        Map managedTypes = this.customizer.getCMSItemTypes();
        DocumentType documentType = (DocumentType)managedTypes.get(document.getType());
        if (documentType != null && documentType.isSupportsPortalForms() && pubInfos.isEditableByUser() && !pubInfos.isLiveSpace() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            IContributionService.EditionState editionState;
            MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, documentType, bundle);
            if (!DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos) && pubInfos.isBeingModified()) {
                MenubarItem modificationIndicator = new MenubarItem("MODIFICATION_MESSAGE", null, (MenubarContainer)MenubarGroup.CMS, -12, "label label-default");
                modificationIndicator.setGlyphicon("halflings halflings-asterisk");
                modificationIndicator.setTooltip(bundle.getString("MODIFICATION_MESSAGE"));
                modificationIndicator.setState(true);
                menubar.add(modificationIndicator);
            }
            if (DocumentHelper.isInLiveMode((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                editionState = new IContributionService.EditionState(IContributionService.EditionState.CONTRIBUTION_MODE_ONLINE, path);
                MenubarItem liveIndicator = new MenubarItem("LIVE_VERSION", bundle.getString("LIVE_VERSION"), (MenubarContainer)MenubarGroup.CMS, -12, "label label-info");
                liveIndicator.setGlyphicon("halflings halflings-pencil visible-xs-inline-block");
                liveIndicator.setState(true);
                menubar.add(liveIndicator);
                if (extendedInfos != null && extendedInfos.isOnlineTaskPending().booleanValue()) {
                    MenubarItem pendingIndicator = new MenubarItem("ON_LINE_WF_PENDING", bundle.getString("ON_LINE_WF_PENDING"), (MenubarContainer)MenubarGroup.CMS, -11, "label label-warning");
                    pendingIndicator.setGlyphicon("glyphicons glyphicons-history");
                    pendingIndicator.setState(true);
                    menubar.add(pendingIndicator);
                }
            } else {
                editionState = new IContributionService.EditionState(IContributionService.EditionState.CONTRIBUTION_MODE_EDITION, path);
                this.contributionService.removeWindowEditionState(portalControllerContext);
            }
            if (DocumentHelper.isInLiveMode((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                if (extendedInfos.isOnlineTaskPending().booleanValue()) {
                    if (extendedInfos.canUserValidateOnlineTask().booleanValue()) {
                        if ("validate-online".equals(extendedInfos.getTaskName())) {
                            this.addValidatePublishingItems(portalControllerContext, cmsContext, pubInfos, menubar, (MenubarContainer)parent, bundle);
                        } else {
                            HashMap requestParameters = new HashMap();
                            String validateURL = this.cmsService.getEcmUrl(cmsContext, EcmViews.validateRemotePublishing, pubInfos.getDocumentPath(), requestParameters);
                            MenubarItem validateItem = new MenubarItem("REMOTE_ONLINE_WF_VALIDATE", bundle.getString("REMOTE_ONLINE_WF_VALIDATE"), null, (MenubarContainer)parent, 14, validateURL, null, null, null);
                            validateItem.setAjaxDisabled(true);
                            menubar.add(validateItem);
                        }
                    } else if (extendedInfos.isUserOnlineTaskInitiator().booleanValue()) {
                        String cancelAskPublishURL = this.getContributionService().getCancelPublishingAskContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        MenubarItem cancelAskPublishItem = new MenubarItem("CANCEL_ASK_PUBLISH", bundle.getString("CANCEL_ASK_PUBLISH"), null, (MenubarContainer)MenubarGroup.CMS, 12, cancelAskPublishURL, null, null, null);
                        cancelAskPublishItem.setAjaxDisabled(true);
                        menubar.add(cancelAskPublishItem);
                    }
                } else if (!DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos) && pubInfos.isBeingModified()) {
                    if (pubInfos.isPublished()) {
                        String cmsEraseModificationURL = this.urlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.eraseModifications);
                        MenubarItem eraseItem = new MenubarItem("ERASE", bundle.getString("ERASE"), "halflings halflings-erase", (MenubarContainer)parent, 11, "#erase_cms_page", null, null, "fancybox_inline");
                        eraseItem.setAssociatedHTML(this.generateEraseFancyBox(bundle, cmsEraseModificationURL));
                        menubar.add(eraseItem);
                    }
                    if (pubInfos.isUserCanValidate()) {
                        String publishURL = this.contributionService.getPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        MenubarItem publishItem = new MenubarItem("PUBLISH", bundle.getString("PUBLISH"), "glyphicons glyphicons-ok-2", (MenubarContainer)parent, 12, publishURL, null, null, null);
                        publishItem.setAjaxDisabled(true);
                        publishItem.setDivider(true);
                        menubar.add(publishItem);
                    } else {
                        String askPublishURL = this.getContributionService().getAskPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        MenubarItem askPublishItem = new MenubarItem("ASK_PUBLISH", bundle.getString("ASK_PUBLISH"), null, (MenubarContainer)parent, 12, askPublishURL, null, null, null);
                        askPublishItem.setAjaxDisabled(true);
                        menubar.add(askPublishItem);
                    }
                }
                if (pubInfos.isPublished()) {
                    String proxyURL = this.getContributionService().getChangeEditionStateUrl(portalControllerContext, editionState);
                    MenubarItem proxyItem = new MenubarItem("PROXY_RETURN", bundle.getString("PROXY_RETURN"), "halflings halflings-eye-close", (MenubarContainer)parent, 1, proxyURL, null, null, null);
                    proxyItem.setAjaxDisabled(true);
                    menubar.add(proxyItem);
                }
            } else {
                if (pubInfos.isUserCanValidate()) {
                    MenubarItem unpublishItem = new MenubarItem("UNPUBLISH", bundle.getString("UNPUBLISH"), (MenubarContainer)parent, 12, null);
                    unpublishItem.setAjaxDisabled(true);
                    unpublishItem.setDivider(true);
                    if (documentType == null || !documentType.isRootType()) {
                        String unpublishURL = this.contributionService.getUnpublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        unpublishItem.setUrl(unpublishURL);
                    } else {
                        unpublishItem.setUrl("#");
                        unpublishItem.setDisabled(true);
                        unpublishItem.setTooltip(bundle.getString("CANNOT_UNPUBLISH_ROOT"));
                    }
                    menubar.add(unpublishItem);
                }
                if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                    String liveURL = this.urlFactory.getCMSUrl(portalControllerContext, null, pubInfos.getLiveId(), null, "1", "preview", null, null, null, null);
                    MenubarItem liveItem = new MenubarItem("GO_TO_LIVE", bundle.getString("GO_TO_LIVE"), "halflings halflings-eye-open", (MenubarContainer)parent, 1, liveURL, null, null, null);
                    liveItem.setAjaxDisabled(true);
                    menubar.add(liveItem);
                } else {
                    String previewURL = this.contributionService.getChangeEditionStateUrl(portalControllerContext, editionState);
                    MenubarItem previewItem = new MenubarItem("LIVE_PREVIEW", bundle.getString("LIVE_PREVIEW"), "halflings halflings-eye-open", (MenubarContainer)parent, 1, previewURL, null, null, null);
                    previewItem.setAjaxDisabled(true);
                    menubar.add(previewItem);
                }
            }
        }
    }

    protected void addValidatePublishingItems(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, MenubarContainer parent, Bundle bundle) throws CMSException {
        String validateURL = this.getContributionService().getValidatePublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
        MenubarItem validateItem = new MenubarItem("ONLINE_WF_VALIDATE", bundle.getString("VALIDATE_PUBLISH"), "glyphicons glyphicons-ok-2", parent, 13, validateURL, null, null, null);
        validateItem.setAjaxDisabled(true);
        menubar.add(validateItem);
        String rejectURL = this.getContributionService().getRejectPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
        MenubarItem rejectItem = new MenubarItem("ONLINE_WF_REJECT", bundle.getString("REJECT_PUBLISH"), "glyphicons glyphicons-remove-2", parent, 14, rejectURL, null, null, null);
        rejectItem.setAjaxDisabled(true);
        menubar.add(rejectItem);
    }

    protected void getLiveContentBrowserLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        boolean folderish;
        DocumentType cmsItemType;
        String navigationPath;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            return;
        }
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = (Document)cmsContext.getDoc();
        if (document == null) {
            navigationPath = cmsContext.getCreationPath();
            cmsItemType = null;
            folderish = navigationPath != null;
        } else {
            navigationPath = nuxeoController.getContentPath();
            cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
            boolean bl = folderish = cmsItemType != null && cmsItemType.isFolderish();
        }
        if (!pubInfos.isLiveSpace() && !pubInfos.getSubTypes().isEmpty() && folderish) {
            String browserURL;
            Portal portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext());
            boolean spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)portal);
            try {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("osivia.browser.basePath", nuxeoController.getBasePath());
                properties.put("osivia.browser.navigationPath", navigationPath);
                properties.put("osivia.browser.space", String.valueOf(spaceSite));
                browserURL = this.urlFactory.getStartPortletUrl(portalControllerContext, "osivia-portal-browser-portlet-instance", properties, true);
            }
            catch (PortalException e) {
                browserURL = "#";
            }
            MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, cmsItemType, bundle);
            MenubarItem browserItem = new MenubarItem("BROWSE_LIVE_CONTENT", bundle.getString("BROWSE_LIVE_CONTENT"), "glyphicons glyphicons-book-open", (MenubarContainer)parent, 50, browserURL, null, null, "fancyframe_refresh");
            browserItem.setAjaxDisabled(true);
            browserItem.setDivider(true);
            browserItem.setBreadcrumb(true);
            menubar.add(browserItem);
        }
    }

    protected void getDriveEditUrl(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, CMSExtendedDocumentInfos extendedInfos) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        DocumentType cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
        if (extendedInfos.getDriveEditURL() != null && cmsItemType != null && cmsItemType.isLiveEditable()) {
            MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, cmsItemType, bundle);
            MenubarItem driveEditItem = new MenubarItem("DRIVE_EDIT", bundle.getString("DRIVE_EDIT"), "glyphicons glyphicons-play", (MenubarContainer)parent, 2, extendedInfos.getDriveEditURL(), null, null, null);
            driveEditItem.setAjaxDisabled(true);
            menubar.add(driveEditItem);
        }
    }

    protected void getSynchronizeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, CMSExtendedDocumentInfos extendedInfos) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        String command = null;
        String icon = null;
        EcmCommonCommands ecmAction = null;
        if (extendedInfos.isCanSynchronize()) {
            command = "SYNCHRONIZE_ACTION";
            icon = "glyphicons glyphicons-refresh";
            ecmAction = EcmCommonCommands.synchronizeFolder;
        } else if (extendedInfos.isCanUnsynchronize()) {
            command = "UNSYNCHRONIZE_ACTION";
            icon = "glyphicons glyphicons-ban";
            ecmAction = EcmCommonCommands.unsynchronizeFolder;
            MenubarItem synchronizedIndicator = new MenubarItem("SYNCHRONIZED", null, (MenubarContainer)MenubarGroup.CMS, -2, "label label-success");
            synchronizedIndicator.setGlyphicon("halflings halflings-refresh");
            synchronizedIndicator.setTooltip(bundle.getString("SYNCHRONIZED"));
            synchronizedIndicator.setState(true);
            menubar.add(synchronizedIndicator);
        }
        MenubarDropdown parent = this.getOtherOptionsDropdown(portalControllerContext, bundle);
        if (command != null) {
            try {
                String synchronizeURL = this.urlFactory.getEcmCommandUrl(portalControllerContext, path, ecmAction);
                MenubarItem synchronizeItem = new MenubarItem(command, bundle.getString(command), icon, (MenubarContainer)parent, 12, synchronizeURL, null, null, null);
                synchronizeItem.setAjaxDisabled(true);
                synchronizeItem.setDivider(true);
                menubar.add(synchronizeItem);
            }
            catch (PortalException e) {
                LOGGER.warn((Object)e.getMessage());
            }
        } else if (extendedInfos.getSynchronizationRootPath() != null) {
            String rootURL = this.urlFactory.getCMSUrl(portalControllerContext, null, extendedInfos.getSynchronizationRootPath(), null, null, null, null, null, null, null);
            MenubarItem rootURLItem = new MenubarItem("SYNCHRO_ROOT_URL", bundle.getString("SYNCHRO_ROOT_URL"), null, (MenubarContainer)parent, 12, rootURL, null, null, null);
            rootURLItem.setAjaxDisabled(true);
            rootURLItem.setDivider(true);
            menubar.add(rootURLItem);
        }
    }

    protected void getSubscribeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, CMSExtendedDocumentInfos extendedInfos) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        CMSExtendedDocumentInfos.SubscriptionStatus subscriptionStatus = extendedInfos.getSubscriptionStatus();
        if (subscriptionStatus != null && subscriptionStatus != CMSExtendedDocumentInfos.SubscriptionStatus.no_subscriptions) {
            String url = "";
            try {
                MenubarDropdown parent = this.getOtherOptionsDropdown(portalControllerContext, bundle);
                MenubarItem subscribeItem = new MenubarItem("SUBSCRIBE_URL", null, null, (MenubarContainer)parent, 11, url, null, null, null);
                subscribeItem.setAjaxDisabled(true);
                subscribeItem.setDivider(true);
                if (subscriptionStatus == CMSExtendedDocumentInfos.SubscriptionStatus.can_subscribe) {
                    url = this.urlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.subscribe);
                    subscribeItem.setUrl(url);
                    subscribeItem.setGlyphicon("glyphicons glyphicons-flag");
                    subscribeItem.setTitle(bundle.getString("SUBSCRIBE_ACTION"));
                } else if (subscriptionStatus == CMSExtendedDocumentInfos.SubscriptionStatus.can_unsubscribe) {
                    url = this.urlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.unsubscribe);
                    subscribeItem.setUrl(url);
                    subscribeItem.setGlyphicon("glyphicons glyphicons-ban");
                    subscribeItem.setTitle(bundle.getString("UNSUBSCRIBE_ACTION"));
                    MenubarItem subscribedIndicator = new MenubarItem("SUBSCRIBED", null, (MenubarContainer)MenubarGroup.CMS, -3, "label label-success");
                    subscribedIndicator.setGlyphicon("halflings halflings-flag");
                    subscribedIndicator.setTooltip(bundle.getString("SUBSCRIBED"));
                    subscribedIndicator.setState(true);
                    menubar.add(subscribedIndicator);
                } else if (subscriptionStatus == CMSExtendedDocumentInfos.SubscriptionStatus.has_inherited_subscriptions) {
                    subscribeItem.setUrl("#");
                    subscribeItem.setGlyphicon("glyphicons glyphicons-flag");
                    subscribeItem.setTitle(bundle.getString("INHERITED_SUBSCRIPTION"));
                    subscribeItem.setDisabled(true);
                }
                menubar.add(subscribeItem);
            }
            catch (PortalException ex) {
                LOGGER.warn((Object)ex.getMessage());
            }
        }
    }

    private void getLockLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, CMSExtendedDocumentInfos extendedInfos) {
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        CMSExtendedDocumentInfos.LockStatus lockStatus = extendedInfos.getLockStatus();
        if (lockStatus != null && lockStatus != CMSExtendedDocumentInfos.LockStatus.no_lock) {
            String url = "";
            try {
                MenubarDropdown parent = this.getOtherOptionsDropdown(portalControllerContext, bundle);
                MenubarItem lockItem = new MenubarItem("LOCK_URL", null, null, (MenubarContainer)parent, 14, url, null, null, null);
                lockItem.setAjaxDisabled(true);
                if (lockStatus == CMSExtendedDocumentInfos.LockStatus.can_lock) {
                    url = this.urlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.lock);
                    lockItem.setUrl(url);
                    lockItem.setGlyphicon("glyphicons glyphicons-lock");
                    lockItem.setTitle(bundle.getString("LOCK_ACTION"));
                } else if (lockStatus == CMSExtendedDocumentInfos.LockStatus.can_unlock) {
                    url = this.urlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.unlock);
                    lockItem.setUrl(url);
                    lockItem.setGlyphicon("glyphicons glyphicons-unlock");
                    lockItem.setTitle(bundle.getString("UNLOCK_ACTION"));
                    MenubarItem lockedIndicator = new MenubarItem("LOCKED", null, (MenubarContainer)MenubarGroup.CMS, -1, "label label-warning");
                    lockedIndicator.setGlyphicon("halflings halflings-glyph-lock");
                    lockedIndicator.setTooltip(bundle.getString("LOCKED"));
                    lockedIndicator.setState(true);
                    menubar.add(lockedIndicator);
                } else if (lockStatus == CMSExtendedDocumentInfos.LockStatus.locked) {
                    lockItem.setUrl("#");
                    lockItem.setGlyphicon("glyphicons glyphicons-lock");
                    lockItem.setTitle(bundle.getString("INHERITED_LOCK"));
                    lockItem.setDisabled(true);
                }
                menubar.add(lockItem);
            }
            catch (PortalException ex) {
                LOGGER.warn((Object)ex.getMessage());
            }
        }
    }

    private void getEditWksLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        DocumentType documentType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
        if (document.getType().equals("Workspace") && pubInfos.isManageableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            String callbackURL = this.urlFactory.getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
            String ecmBaseURL = this.cmsService.getEcmDomain(cmsContext);
            HashMap requestParameters = new HashMap();
            String url = this.cmsService.getEcmUrl(cmsContext, EcmViews.editDocument, pubInfos.getDocumentPath(), requestParameters);
            StringBuilder onClick = new StringBuilder();
            onClick.append("javascript:setCallbackFromEcmParams('");
            onClick.append(callbackURL);
            onClick.append("', '");
            onClick.append(ecmBaseURL);
            onClick.append("');");
            String editLabel = bundle.getString("EDIT");
            MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, documentType, bundle);
            MenubarItem item = new MenubarItem("EDIT", editLabel, "glyphicons glyphicons-pencil", (MenubarContainer)parent, 1, url, null, onClick.toString(), "fancyframe_refresh");
            item.setAjaxDisabled(true);
            menubar.add(item);
        }
    }

    protected void getValidationWfLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, CMSExtendedDocumentInfos extendedInfos) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        DocumentType documentType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
        if (!DocumentHelper.isFolder((Document)document) && pubInfos.isLiveSpace() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            Boolean isValidationWfRunning = extendedInfos.getIsValidationWorkflowRunning();
            String url = "";
            MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, documentType, bundle);
            MenubarItem validationWfItem = new MenubarItem("VALIDATION_WF_URL", null, null, (MenubarContainer)parent, 13, "", null, null, "fancyframe_refresh");
            String onClick = this.generateCallbackParams(portalControllerContext, cmsContext);
            validationWfItem.setOnclick(onClick);
            if (BooleanUtils.isTrue((Boolean)isValidationWfRunning)) {
                HashMap requestParameters = new HashMap();
                String followWfURL = this.cmsService.getEcmUrl(cmsContext, EcmViews.followWfValidation, pubInfos.getDocumentPath(), requestParameters);
                validationWfItem.setUrl(followWfURL);
                validationWfItem.setTitle(bundle.getString("FOLLOW_VALIDATION_WF"));
                menubar.add(validationWfItem);
            } else if (!"approved".equals(document.getState()) && pubInfos.isEditableByUser()) {
                HashMap requestParameters = new HashMap();
                String startWfURL = this.cmsService.getEcmUrl(cmsContext, EcmViews.startValidationWf, pubInfos.getDocumentPath(), requestParameters);
                validationWfItem.setUrl(startWfURL);
                validationWfItem.setTitle(bundle.getString("START_VALIDATION_WF"));
                menubar.add(validationWfItem);
            }
        }
    }

    private String generateCallbackParams(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext) {
        String callbackURL = this.urlFactory.getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
        String ecmBaseURL = this.cmsService.getEcmDomain(cmsContext);
        StringBuilder onClick = new StringBuilder();
        onClick.append("javascript:setCallbackFromEcmParams('");
        onClick.append(callbackURL);
        onClick.append("', '");
        onClick.append(ecmBaseURL);
        onClick.append("');");
        return onClick.toString();
    }

    protected void getRemotePublishingLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, CMSExtendedDocumentInfos extendedInfos) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        DocumentType documentType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
        if (!DocumentHelper.isFolder((Document)document) && pubInfos.isRemotePublishable() && pubInfos.isLiveSpace() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            String url = "#";
            MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, documentType, bundle);
            MenubarItem remotePubItem = new MenubarItem("REMOTE_PUBLISHING_URL", bundle.getString("REMOTE_PUBLISHING"), null, (MenubarContainer)parent, 14, "#", null, null, null);
            Boolean isValidationWfRunning = extendedInfos.getIsValidationWorkflowRunning();
            if (BooleanUtils.isFalse((Boolean)isValidationWfRunning)) {
                HashMap requestParameters = new HashMap();
                String remotePublishingURL = this.cmsService.getEcmUrl(cmsContext, EcmViews.remotePublishing, pubInfos.getDocumentPath(), requestParameters);
                remotePubItem.setUrl(remotePublishingURL);
                remotePubItem.setHtmlClasses("fancyframe_refresh");
                menubar.add(remotePubItem);
            } else {
                remotePubItem.setDisabled(true);
                menubar.add(remotePubItem);
            }
        }
    }

    protected void getEditLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        DocumentType cmsItemType;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        if (pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && (cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType())) != null && cmsItemType.isSupportsPortalForms()) {
            String callbackURL = this.urlFactory.getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
            String ecmBaseURL = this.cmsService.getEcmDomain(cmsContext);
            HashMap requestParameters = new HashMap();
            String url = this.cmsService.getEcmUrl(cmsContext, EcmViews.editDocument, pubInfos.getDocumentPath(), requestParameters);
            StringBuilder onClick = new StringBuilder();
            onClick.append("javascript:setCallbackFromEcmParams('");
            onClick.append(callbackURL);
            onClick.append("', '");
            onClick.append(ecmBaseURL);
            onClick.append("');");
            String editLabel = null;
            editLabel = StringUtils.isNotBlank((String)pubInfos.getPublishSpacePath()) ? (!pubInfos.isLiveSpace() && !DocumentHelper.isInLiveMode((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos) && pubInfos.isBeingModified() ? bundle.getString("EDIT_LIVE_VERSION") : bundle.getString("EDIT")) : bundle.getString("EDIT");
            MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, cmsItemType, bundle);
            MenubarItem item = new MenubarItem("EDIT", editLabel, "glyphicons glyphicons-pencil", (MenubarContainer)parent, 1, url, null, onClick.toString(), "fancyframe_refresh");
            item.setAjaxDisabled(true);
            menubar.add(item);
        }
    }

    protected void getMoveLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        boolean authorizedSpace = true;
        if (!NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_62)) {
            if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                return;
            }
            authorizedSpace = pubInfos.isLiveSpace();
        }
        if (authorizedSpace && pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
            DocumentType cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
            boolean isMovable = cmsItemType.isMovable();
            if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                isMovable = false;
            }
            if (cmsItemType != null && cmsItemType.isSupportsPortalForms() && isMovable) {
                String moveDocumentURL;
                try {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("osivia.move.documentPath", document.getPath());
                    properties.put("osivia.move.cmsBasePath", nuxeoController.getBasePath());
                    properties.put("osivia.move.acceptedTypes", cmsItemType.getName());
                    moveDocumentURL = this.urlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-move-portlet-instance", properties, true);
                }
                catch (PortalException e) {
                    moveDocumentURL = null;
                }
                if (moveDocumentURL != null) {
                    MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, cmsItemType, bundle);
                    MenubarItem item = new MenubarItem("MOVE", bundle.getString("MOVE"), "glyphicons glyphicons-move", (MenubarContainer)parent, 2, moveDocumentURL, null, null, "fancyframe_refresh");
                    item.setAjaxDisabled(true);
                    menubar.add(item);
                }
            }
        }
    }

    protected void getReorderLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        DocumentType cmsItemType;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        boolean authorizedSpace = true;
        if (!NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_62)) {
            if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                return;
            }
            authorizedSpace = pubInfos.isLiveSpace();
        }
        if (authorizedSpace && pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && (cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType())) != null && cmsItemType.isOrdered()) {
            String reorderDocumentsURL;
            try {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("osivia.reorder.path", document.getPath());
                reorderDocumentsURL = this.urlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-reorder-portlet-instance", properties, true);
            }
            catch (PortalException e) {
                reorderDocumentsURL = null;
            }
            if (reorderDocumentsURL != null) {
                MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, cmsItemType, bundle);
                MenubarItem item = new MenubarItem("REORDER", bundle.getString("REORDER"), "glyphicons glyphicons-sorting", (MenubarContainer)parent, 3, reorderDocumentsURL, null, null, "fancyframe_refresh");
                item.setAjaxDisabled(true);
                item.setBreadcrumb(true);
                menubar.add(item);
            }
        }
    }

    protected void getCreateLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        String creationType = cmsContext.getCreationType();
        String creationPath = cmsContext.getCreationPath();
        Document parentDoc = (Document)cmsContext.getDoc();
        if (creationPath != null) {
            parentDoc = (Document)this.cmsService.getContent(cmsContext, creationPath).getNativeItem();
        }
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        if (creationPath != null || ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            int size;
            String url;
            String callbackURL = this.urlFactory.getRefreshPageUrl(portalControllerContext, true);
            String ecmBaseURL = this.cmsService.getEcmDomain(cmsContext);
            StringBuilder builder = new StringBuilder();
            builder.append("javascript:setCallbackFromEcmParams('");
            builder.append(callbackURL);
            builder.append("', '");
            builder.append(ecmBaseURL);
            builder.append("');");
            String onclick = builder.toString();
            Map subTypes = pubInfos.getSubTypes();
            CMSItemTypeComparator comparator = new CMSItemTypeComparator(bundle);
            TreeMap<DocumentType, String> folderishTypes = new TreeMap<DocumentType, String>((Comparator<DocumentType>)comparator);
            TreeMap<DocumentType, String> notFolderishTypes = new TreeMap<DocumentType, String>((Comparator<DocumentType>)comparator);
            Map managedTypes = this.customizer.getCMSItemTypes();
            DocumentType containerDocType = (DocumentType)managedTypes.get(parentDoc.getType());
            if (containerDocType != null) {
                Portal portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext());
                boolean spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)portal);
                for (String docType : subTypes.keySet()) {
                    DocumentType cmsItemType;
                    DocumentType docTypeDef;
                    if (!containerDocType.getPortalFormSubTypes().contains(docType) || creationType != null && !creationType.equals(docType) || (docTypeDef = (DocumentType)managedTypes.get(docType)) == null || !docTypeDef.isSupportsPortalForms() || (cmsItemType = (DocumentType)managedTypes.get(docType)) == null || spaceSite && "PortalPage".equals(cmsItemType.getName())) continue;
                    HashMap<String, String> requestParameters = new HashMap<String, String>();
                    requestParameters.put("type", docType);
                    url = this.cmsService.getEcmUrl(cmsContext, EcmViews.createDocument, pubInfos.getDocumentPath(), requestParameters);
                    if (cmsItemType.isFolderish()) {
                        folderishTypes.put(cmsItemType, url);
                        continue;
                    }
                    notFolderishTypes.put(cmsItemType, url);
                }
            }
            if ((size = folderishTypes.size() + notFolderishTypes.size()) == 1) {
                Map.Entry entry = folderishTypes.size() == 1 ? folderishTypes.entrySet().iterator().next() : notFolderishTypes.entrySet().iterator().next();
                String url2 = (String)entry.getValue();
                MenubarItem item = new MenubarItem("ADD", bundle.getString("ADD"), "halflings halflings-plus", (MenubarContainer)MenubarGroup.CMS, 2, url2, null, onclick, "fancyframe_refresh");
                item.setAjaxDisabled(true);
                menubar.add(item);
            } else if (size > 0) {
                MenubarItem item;
                String name;
                String typeName;
                DocumentType cmsItemType;
                MenubarDropdown dropdown = new MenubarDropdown("ADD", bundle.getString("ADD"), "halflings halflings-plus", MenubarGroup.CMS, 2);
                this.menubarService.addDropdown(portalControllerContext, dropdown);
                int order = 1;
                boolean divider = false;
                for (Map.Entry entry : folderishTypes.entrySet()) {
                    cmsItemType = (DocumentType)entry.getKey();
                    url = (String)entry.getValue();
                    typeName = StringUtils.upperCase((String)cmsItemType.getName());
                    name = bundle.getString(typeName);
                    item = new MenubarItem("ADD_" + typeName, name, cmsItemType.getGlyph(), (MenubarContainer)dropdown, order, url, null, onclick, "fancyframe_refresh");
                    item.setAjaxDisabled(true);
                    menubar.add(item);
                    ++order;
                    divider = true;
                }
                for (Map.Entry entry : notFolderishTypes.entrySet()) {
                    cmsItemType = (DocumentType)entry.getKey();
                    url = (String)entry.getValue();
                    typeName = StringUtils.upperCase((String)cmsItemType.getName());
                    name = bundle.getString(typeName);
                    item = new MenubarItem("ADD_" + typeName, name, cmsItemType.getGlyph(), (MenubarContainer)dropdown, order, url, null, onclick, "fancyframe_refresh");
                    item.setAjaxDisabled(true);
                    item.setDivider(divider);
                    menubar.add(item);
                    ++order;
                    divider = false;
                }
            }
        }
    }

    protected void getDeleteLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        DocumentType docTypeDef;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        if (pubInfos.isDeletableByUser() && (pubInfos.isLiveSpace() || DocumentHelper.isInLiveMode((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && (docTypeDef = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType())) != null && docTypeDef.isSupportsPortalForms()) {
            MenubarDropdown parent = this.getCMSEditionDropdown(portalControllerContext, docTypeDef, bundle);
            MenubarItem item = new MenubarItem("DELETE", bundle.getString("DELETE"), "glyphicons glyphicons-bin", (MenubarContainer)parent, 20, null, null, null, null);
            item.setAjaxDisabled(true);
            item.setDivider(true);
            if (docTypeDef.isRootType()) {
                item.setUrl("#");
                item.setDisabled(true);
                item.setTooltip(bundle.getString("CANNOT_DELETE_ROOT"));
            } else {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("docId", document.getId());
                properties.put("docPath", document.getPath());
                String fancyboxId = cmsContext.getResponse().getNamespace() + "_PORTAL_DELETE";
                String putInTrashUrl = this.urlFactory.getPutDocumentInTrashUrl(portalControllerContext, pubInfos.getLiveId(), pubInfos.getDocumentPath());
                String fancybox = this.generateDeleteConfirmationFancybox(properties, bundle, fancyboxId, putInTrashUrl);
                item.setAssociatedHTML(fancybox);
                String url = "#" + fancyboxId;
                item.setUrl(url);
                item.setHtmlClasses("fancybox_inline");
            }
            menubar.add(item);
        }
    }

    private String generateEraseFancyBox(Bundle bundle, String urlErase) {
        Element root = DOM4JUtils.generateDivElement((String)"hidden");
        Element container = DOM4JUtils.generateDivElement((String)"container-fluid text-center");
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)"erase_cms_page");
        root.add(container);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("ERASE_CONFIRM_MESSAGE"));
        container.add(message);
        Element okButton = DOM4JUtils.generateLinkElement((String)urlErase, null, null, (String)"btn btn-default btn-warning", (String)bundle.getString("YES"), (String)"halflings halflings-alert");
        container.add(okButton);
        Element cancelButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("NO"));
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"onclick", (String)"closeFancybox()");
        container.add(cancelButton);
        return DOM4JUtils.write((Element)root);
    }

    private String generateDeleteConfirmationFancybox(Map<String, String> properties, Bundle bundle, String fancyboxId, String actionURL) {
        Element fancyboxContainer = DOM4JUtils.generateDivElement((String)"hidden");
        Element container = DOM4JUtils.generateDivElement(null);
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)fancyboxId);
        fancyboxContainer.add(container);
        Element form = DOM4JUtils.generateElement((String)"form", (String)"text-center", null, null, (AccessibilityRoles)AccessibilityRoles.FORM);
        DOM4JUtils.addAttribute((Element)form, (String)"action", (String)actionURL);
        DOM4JUtils.addAttribute((Element)form, (String)"method", (String)"post");
        container.add(form);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("CMS_DELETE_CONFIRM_MESSAGE"));
        form.add(message);
        for (Map.Entry<String, String> property : properties.entrySet()) {
            Element hidden = DOM4JUtils.generateElement((String)"input", null, null);
            DOM4JUtils.addAttribute((Element)hidden, (String)"type", (String)"hidden");
            DOM4JUtils.addAttribute((Element)hidden, (String)"name", (String)property.getKey());
            DOM4JUtils.addAttribute((Element)hidden, (String)"value", (String)property.getValue());
            form.add(hidden);
        }
        Element okButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-warning", (String)bundle.getString("YES"), (String)"halflings halflings-alert", null);
        DOM4JUtils.addAttribute((Element)okButton, (String)"type", (String)"submit");
        form.add(okButton);
        Element cancelButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("NO"));
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"onclick", (String)"closeFancybox()");
        form.add(cancelButton);
        return DOM4JUtils.write((Element)fancyboxContainer);
    }

    protected void addContextualizationLinkItem(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, String displayName, String url) throws CMSException {
        MenubarItem item = new MenubarItem("CONTEXTUALIZE", bundle.getString("CONTEXTUALIZE_SPACE", new Object[]{displayName}), "halflings halflings-level-up", (MenubarContainer)MenubarGroup.SPECIFIC, 1, url, null, null, null);
        item.setAjaxDisabled(true);
        menubar.add(item);
    }

    protected void getContextualizationLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        Page page;
        PortletRequest request = cmsContext.getRequest();
        if (!WindowState.MAXIMIZED.equals((Object)request.getWindowState())) {
            return;
        }
        Page currentPage = null;
        Window window = (Window)request.getAttribute("osivia.window");
        if (window != null) {
            currentPage = window.getPage();
        }
        Document document = (Document)cmsContext.getDoc();
        try {
            page = this.urlFactory.getPortalCMSContextualizedPage(portalControllerContext, document.getPath());
        }
        catch (PortalException e) {
            page = null;
        }
        if (page == null || !page.getId().equals((Object)currentPage.getId())) {
            CMSItem pubConfig;
            String spaceDisplayName = null;
            if (page != null) {
                spaceDisplayName = PortalObjectUtils.getDisplayName((PortalObject)page, (Locale)request.getLocale());
            } else if (pubInfos.getPublishSpacePath() != null && "1".equals((pubConfig = this.cmsService.getSpaceConfig(cmsContext, pubInfos.getPublishSpacePath())).getProperties().get("contextualizeInternalContents"))) {
                spaceDisplayName = pubInfos.getPublishSpaceDisplayName();
            }
            if (spaceDisplayName != null) {
                String url = this.urlFactory.getCMSUrl(portalControllerContext, currentPage.getId().toString(PortalObjectPath.CANONICAL_FORMAT), document.getPath(), null, "portal", null, null, null, null, null);
                this.addContextualizationLinkItem(portalControllerContext, cmsContext, menubar, bundle, spaceDisplayName, url);
            }
        }
    }

    protected void addPermaLinkItem(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, String url) throws CMSException {
        String id = cmsContext.getResponse().getNamespace() + "_PERMALINK_DISPLAY";
        String htmlContent = this.generatePermalinkFancybox(bundle, id, url);
        MenubarDropdown parent = this.getShareDropdown(portalControllerContext, bundle);
        MenubarItem item = new MenubarItem("PERMALINK", bundle.getString("PERMALINK"), "glyphicons glyphicons-link", (MenubarContainer)parent, 1, "#" + id, null, null, "fancybox_inline");
        item.setAjaxDisabled(true);
        item.setAssociatedHTML(htmlContent);
        menubar.add(item);
    }

    private void addEmailLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (pubInfos.isLiveSpace() || !pubInfos.isLiveSpace() && pubInfos.isPublished()) {
            HashMap requestParameters = new HashMap();
            String url = this.getCmsService().getEcmUrl(cmsContext, EcmViews.shareDocument, pubInfos.getDocumentPath(), requestParameters);
            String callbackURL = this.getUrlFactory().getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
            String ecmBaseURL = this.getCmsService().getEcmDomain(cmsContext);
            StringBuilder onClick = new StringBuilder();
            onClick.append("javascript:setCallbackFromEcmParams('");
            onClick.append(callbackURL);
            onClick.append("', '");
            onClick.append(ecmBaseURL);
            onClick.append("');");
            MenubarDropdown parent = this.getShareDropdown(portalControllerContext, bundle);
            MenubarItem item = new MenubarItem("SHARE_BY_EMAIL", bundle.getString("SHARE_EMAIL"), "social social-e-mail", (MenubarContainer)parent, 2, url, null, onClick.toString(), "fancyframe_refresh");
            item.setAjaxDisabled(true);
            menubar.add(item);
        }
    }

    protected String computePermaLinkUrl(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        String url;
        PortletRequest request = cmsContext.getRequest();
        HashMap<String, String> parameters = null;
        String selectors = request.getParameter("selectors");
        if (selectors != null) {
            parameters = new HashMap<String, String>();
            Map decodedSelectors = PageSelectors.decodeProperties((String)selectors);
            parameters.put("selectors", PageSelectors.encodeProperties((Map)decodedSelectors));
        }
        String path = this.customizer.getContentWebIdPath(cmsContext, pubInfos);
        String permaLinkType = "cms";
        if (this.hasWebId(cmsContext) && !DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos) && (pubInfos.isLiveSpace() || !pubInfos.isLiveSpace() && StringUtils.isNotBlank((String)pubInfos.getPublishSpacePath()))) {
            permaLinkType = "share";
        }
        try {
            url = this.getUrlFactory().getPermaLink(portalControllerContext, null, parameters, path, permaLinkType);
        }
        catch (PortalException e) {
            url = null;
        }
        return ContextualizationHelper.getLivePath(url);
    }

    protected boolean mustDisplayPermalink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        boolean displayPermalink = false;
        if (WindowState.MAXIMIZED.equals((Object)cmsContext.getRequest().getWindowState()) && cmsContext.getDoc() != null) {
            displayPermalink = !DocumentHelper.isLocalPublishLive((Document)((Document)cmsContext.getDoc()));
        } else {
            Portal portal;
            boolean spaceSite;
            if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
                displayPermalink = true;
            }
            if (spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)(portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext())))) {
                displayPermalink = false;
            }
        }
        return displayPermalink;
    }

    protected void getPermaLinkLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (!this.mustDisplayPermalink(portalControllerContext, cmsContext, menubar, bundle)) {
            return;
        }
        String url = this.computePermaLinkUrl(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
        if (url != null) {
            this.addPermaLinkItem(portalControllerContext, cmsContext, menubar, bundle, url);
            this.addEmailLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
        }
    }

    private String generatePermalinkFancybox(Bundle bundle, String id, String url) {
        String copiableId = id + "_COPIABLE";
        String bindedId = copiableId + "_BINDED";
        String msgBindedId = id + "_MSG";
        Element fancyboxContainer = DOM4JUtils.generateDivElement((String)"hidden");
        Element container = DOM4JUtils.generateDivElement(null);
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)id);
        fancyboxContainer.add(container);
        Element label = DOM4JUtils.generateElement((String)"label", (String)"control-label", (String)bundle.getString("SHARE_PERMALINK"));
        container.add(label);
        Element divLink = DOM4JUtils.generateDivElement((String)"form-control", null);
        DOM4JUtils.addAttribute((Element)divLink, (String)"id", (String)copiableId);
        DOM4JUtils.addText((Element)divLink, (String)url);
        container.add(divLink);
        Element group2 = DOM4JUtils.generateDivElement((String)"media");
        container.add(group2);
        Element msgDiv = DOM4JUtils.generateDivElement((String)"media-body visibilty-hidden");
        DOM4JUtils.addAttribute((Element)msgDiv, (String)"id", (String)msgBindedId);
        group2.add(msgDiv);
        Element msgHead = DOM4JUtils.generateDivElement((String)"media-heading");
        msgDiv.add(msgHead);
        Element msgContent = DOM4JUtils.generateDivElement((String)"alert-info form-control");
        DOM4JUtils.addText((Element)msgContent, (String)bundle.getString("COPIED_PERMALINK_INFO"));
        msgHead.add(msgContent);
        Element btnGroup = DOM4JUtils.generateDivElement((String)"media-right");
        group2.add(btnGroup);
        Element copyButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("COPY_PERMALINK"), (String)"halflings halflings-copy", null);
        DOM4JUtils.addAttribute((Element)copyButton, (String)"id", (String)bindedId);
        DOM4JUtils.addDataAttribute((Element)copyButton, (String)"clipboard-target", (String)("#" + copiableId));
        DOM4JUtils.addDataAttribute((Element)copyButton, (String)"clipboard-message", (String)("#" + msgBindedId));
        btnGroup.add(copyButton);
        Element button = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("CLOSE"));
        DOM4JUtils.addAttribute((Element)button, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)button, (String)"onclick", (String)"closeFancybox()");
        btnGroup.add(button);
        return DOM4JUtils.write((Element)fancyboxContainer);
    }

    public IMenubarService getMenubarService() {
        return this.menubarService;
    }

    public CMSService getCmsService() {
        return this.cmsService;
    }

    public IPortalUrlFactory getUrlFactory() {
        return this.urlFactory;
    }

    public DefaultCMSCustomizer getCustomizer() {
        return this.customizer;
    }

    public IContributionService getContributionService() {
        return this.contributionService;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }
}

