/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.UserPagesPreloadCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetUserProfileCommand;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class UserPagesLoader {
    private CMSService cmsService;

    public UserPagesLoader(PortletContext portletCtx, DefaultCMSCustomizer customizer, CMSService cmsService) {
        this.cmsService = cmsService;
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws Exception {
        ArrayList<CMSPage> pages = new ArrayList<CMSPage>();
        if (cmsCtx.getServerInvocation().getServerContext().getClientRequest().getUserPrincipal() != null) {
            String userName = cmsCtx.getServerInvocation().getServerContext().getClientRequest().getUserPrincipal().getName();
            this.cmsService.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new GetUserProfileCommand(userName));
            Documents children = (Documents)this.cmsService.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new UserPagesPreloadCommand());
            for (Document child : children) {
                String spacePath = DocumentHelper.computeNavPath((String)child.getPath());
                CMSItem publishSpace = this.cmsService.createNavigationItem(cmsCtx, spacePath, child.getTitle(), child, spacePath);
                CMSPage userPage = new CMSPage();
                userPage.setPublishSpace(publishSpace);
                pages.add(userPage);
            }
        }
        return pages;
    }
}

