/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentAttachmentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.RemotePublishedDocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.CommentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.RemotePublishedDocumentDAO;
import fr.toutatice.portail.cms.nuxeo.api.services.tag.INuxeoTagService;
import fr.toutatice.portail.cms.nuxeo.portlets.avatar.AvatarServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.binaries.BinaryServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.GetCommentsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.document.GetPublishedDocumentsInfosCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.site.SitePictureServlet;
import fr.toutatice.portail.cms.nuxeo.portlets.thumbnail.ThumbnailServlet;
import fr.toutatice.portail.cms.nuxeo.service.tag.NuxeoTagService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.IEcmCommandervice;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class ViewDocumentPortlet
extends CMSPortlet {
    public static final String PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    public static final String ONLY_DESCRIPTION_WINDOW_PROPERTY = "osivia.document.onlyDescription";
    public static final String ONLY_REMOTE_SECTIONS_WINDOW_PROPERTY = "osivia.document.onlyRemoteSections";
    public static final String REMOTE_SECTIONS_PAGE_WINDOW_PROPERTY = "osivia.document.remoteSectionsPage";
    public static final String HIDE_METADATA_WINDOW_PROPERTY = "osivia.cms.hideMetaDatas";
    public static final String HIDE_ATTACHMENTS_WINDOW_PROPERTY = "osivia.document.hideAttachments";
    public static final String DISPATCH_JSP = "osivia.document.dispatch.jsp";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/document/admin.jsp";
    private static final String PATH_VIEW = "/WEB-INF/jsp/document/view.jsp";
    private INuxeoService nuxeoService;
    private DocumentDAO documentDAO;
    private CommentDAO commentDAO;
    private RemotePublishedDocumentDAO publishedDocumentsDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        try {
            this.nuxeoService = (INuxeoService)this.getPortletContext().getAttribute("NuxeoService");
            if (this.nuxeoService == null) {
                throw new PortletException("Cannot start ViewDocumentPortlet portlet due to service unavailability");
            }
            CMSCustomizer customizer = new CMSCustomizer(this.getPortletContext());
            this.nuxeoService.registerCMSCustomizer((INuxeoCustomizer)customizer);
            NuxeoTagService tagService = new NuxeoTagService();
            this.nuxeoService.registerTagService((INuxeoTagService)tagService);
            this.documentDAO = DocumentDAO.getInstance();
            this.commentDAO = CommentDAO.getInstance();
            this.publishedDocumentsDAO = RemotePublishedDocumentDAO.getInstance();
            CMSService cmsService = new CMSService(this.getPortletContext());
            ICMSServiceLocator cmsLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
            cmsLocator.register((ICMSService)cmsService);
            cmsService.setCustomizer((DefaultCMSCustomizer)customizer);
            customizer.setCmsService(cmsService);
            IDirectoryServiceLocator directoryServiceLocator = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");
            customizer.setDirectoryService(directoryServiceLocator.getDirectoryService());
            IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
            customizer.setInternationalizationService(internationalizationService);
            INotificationsService notificationsService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
            customizer.setNotificationsService(notificationsService);
            IEcmCommandervice ecmCmdService = (IEcmCommandervice)Locator.findMBean(IEcmCommandervice.class, (String)"osivia:service=EcmCommandService");
            for (EcmCommand command : customizer.getEcmCommands().values()) {
                ecmCmdService.registerCommand(command.getCommandName(), command);
            }
            ThumbnailServlet.setPortletContext((PortletContext)this.getPortletContext());
            SitePictureServlet.setPortletContext((PortletContext)this.getPortletContext());
            AvatarServlet.setPortletContext((PortletContext)this.getPortletContext());
            BinaryServlet.setPortletContext((PortletContext)this.getPortletContext());
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                String path = request.getParameter("path");
                window.setProperty(PATH_WINDOW_PROPERTY, path);
                String onlyDescription = request.getParameter("onlyDescription");
                window.setProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY, onlyDescription);
                boolean displayMetadata = BooleanUtils.toBoolean((String)request.getParameter("metadata"));
                window.setProperty(HIDE_METADATA_WINDOW_PROPERTY, BooleanUtils.toString((boolean)displayMetadata, null, (String)"1"));
                boolean displayAttachments = BooleanUtils.toBoolean((String)request.getParameter("attachments"));
                window.setProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY, BooleanUtils.toString((boolean)displayAttachments, null, (String)"1"));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        } else if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            this.processCommentAction(request, response);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        request.setAttribute("path", (Object)path);
        boolean onlyDescription = BooleanUtils.toBoolean((String)window.getProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY));
        request.setAttribute("onlyDescription", (Object)onlyDescription);
        boolean metadata = BooleanUtils.toBoolean((String)window.getProperty(HIDE_METADATA_WINDOW_PROPERTY), null, (String)"1");
        request.setAttribute("metadata", (Object)metadata);
        boolean attachments = BooleanUtils.toBoolean((String)window.getProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY), null, (String)"1");
        request.setAttribute("attachments", (Object)attachments);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            INuxeoCustomizer customizer = nuxeoController.getNuxeoCMSService().getCMSCustomizer();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String theme = window.getPageProperty("theme.id");
            request.setAttribute("theme", (Object)theme);
            String path = window.getProperty(PATH_WINDOW_PROPERTY);
            path = nuxeoController.getComputedPath(path);
            if (StringUtils.isNotBlank((String)path)) {
                NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)path);
                boolean maximized = WindowState.MAXIMIZED.equals((Object)request.getWindowState());
                boolean onlyRemoteSections = BooleanUtils.toBoolean((String)window.getProperty(ONLY_REMOTE_SECTIONS_WINDOW_PROPERTY));
                request.setAttribute("onlyRemoteSections", (Object)onlyRemoteSections);
                boolean remoteSectionsPage = BooleanUtils.toBoolean((String)window.getProperty(REMOTE_SECTIONS_PAGE_WINDOW_PROPERTY));
                request.setAttribute("remoteSectionsPage", (Object)remoteSectionsPage);
                boolean onlyDescription = BooleanUtils.toBoolean((String)window.getProperty(ONLY_DESCRIPTION_WINDOW_PROPERTY));
                if (!maximized) {
                    request.setAttribute("onlyDescription", (Object)onlyDescription);
                }
                boolean metadata = BooleanUtils.toBoolean((String)window.getProperty(HIDE_METADATA_WINDOW_PROPERTY), null, (String)"1");
                request.setAttribute("metadata", (Object)metadata);
                boolean attachments = BooleanUtils.toBoolean((String)window.getProperty(HIDE_ATTACHMENTS_WINDOW_PROPERTY), null, (String)"1");
                request.setAttribute("attachments", (Object)attachments);
                Document document = documentContext.getDoc();
                nuxeoController.setCurrentDoc(document);
                if (window.getProperty(DISPATCH_JSP) != null) {
                    request.setAttribute("dispatchJsp", (Object)window.getProperty(DISPATCH_JSP));
                } else {
                    String docType = StringUtils.lowerCase((String)document.getType());
                    String jspName = customizer.getJSPName("/WEB-INF/jsp/document/view-" + docType + ".jsp", this.getPortletContext(), (PortletRequest)request);
                    String realPath = this.getPortletContext().getRealPath(jspName);
                    File file = new File(realPath);
                    if (file.exists()) {
                        request.setAttribute("dispatchJsp", (Object)docType);
                    } else {
                        request.setAttribute("dispatchJsp", (Object)"default");
                    }
                }
                DocumentDTO documentDTO = this.documentDAO.toDTO(document);
                request.setAttribute("document", (Object)documentDTO);
                String title = document.getTitle();
                if (StringUtils.isNotBlank((String)title)) {
                    response.setTitle(title);
                }
                if (onlyRemoteSections && maximized) {
                    this.generatePublishedDocumentsInfos(nuxeoController, document, documentDTO, Boolean.valueOf(onlyRemoteSections));
                } else if (!onlyDescription || maximized) {
                    CMSPublicationInfos publicationInfos;
                    ICMSService cmsService;
                    boolean commentsEnabled;
                    nuxeoController.insertContentMenuBarItems();
                    this.generateAttachments(nuxeoController, document, documentDTO);
                    this.generatePublishedDocumentsInfos(nuxeoController, document, documentDTO, Boolean.FALSE);
                    if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && (commentsEnabled = this.areCommentsEnabled(cmsService = NuxeoController.getCMSService(), publicationInfos = cmsService.getPublicationInfos(cmsContext, path), cmsContext)) && publicationInfos.isCommentableByUser()) {
                        documentDTO.setCommentable(true);
                        this.generateComments(nuxeoController, document, documentDTO);
                    }
                }
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(PATH_VIEW).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void generateAttachments(NuxeoController nuxeoController, Document document, DocumentDTO documentDTO) {
        List attachments = documentDTO.getAttachments();
        PropertyList files = document.getProperties().getList("files:files");
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                PropertyMap map = files.getMap(i);
                DocumentAttachmentDTO attachment = new DocumentAttachmentDTO();
                String name = map.getString("filename");
                attachment.setName(name);
                String url = nuxeoController.createAttachedFileLink(document.getPath(), String.valueOf(i));
                attachment.setUrl(url);
                attachments.add(attachment);
            }
        }
    }

    private void generateComments(NuxeoController nuxeoController, Document document, DocumentDTO documentDTO) {
        GetCommentsCommand getCommentsCommand = new GetCommentsCommand(document);
        JSONArray jsonComments = (JSONArray)nuxeoController.executeNuxeoCommand((INuxeoCommand)getCommentsCommand);
        for (int i = 0; i < jsonComments.size(); ++i) {
            JSONObject jsonComment = jsonComments.getJSONObject(i);
            CommentDTO commentDTO = this.commentDAO.toDTO(jsonComment);
            documentDTO.getComments().add(commentDTO);
        }
    }

    protected boolean areCommentsEnabled(ICMSService cmsService, CMSPublicationInfos publicationInfos, CMSServiceCtx cmsContext) throws CMSException {
        boolean enable = true;
        String publishSpacePath = publicationInfos.getPublishSpacePath();
        if (StringUtils.isBlank((String)publishSpacePath)) {
            publishSpacePath = publicationInfos.getDocumentPath();
        }
        if (StringUtils.isNotBlank((String)publishSpacePath)) {
            boolean isPublishSpace;
            CMSItem spaceConfig = cmsService.getSpaceConfig(cmsContext, publishSpacePath);
            Document space = (Document)spaceConfig.getNativeItem();
            boolean bl = isPublishSpace = space.getFacets() != null && space.getFacets().list().contains("TTCPublishSpace");
            if (isPublishSpace) {
                enable = BooleanUtils.toBoolean((String)((String)spaceConfig.getProperties().get("spaceCommentable")));
            }
        }
        return enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generatePublishedDocumentsInfos(NuxeoController nuxeoController, Document document, DocumentDTO documentDTO, Boolean readFilter) {
        if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_61)) {
            int cacheType = nuxeoController.getCacheType();
            int authType = nuxeoController.getAuthType();
            try {
                nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
                GetPublishedDocumentsInfosCommand getPublishedCommand = new GetPublishedDocumentsInfosCommand(document, readFilter);
                JSONArray jsonPublishedDocumentsInfos = (JSONArray)nuxeoController.executeNuxeoCommand((INuxeoCommand)getPublishedCommand);
                for (int index = 0; index < jsonPublishedDocumentsInfos.size(); ++index) {
                    JSONObject publishedDocumentInfos = jsonPublishedDocumentsInfos.getJSONObject(index);
                    RemotePublishedDocumentDTO publishedDocumentDTO = this.publishedDocumentsDAO.toDTO(publishedDocumentInfos);
                    documentDTO.getPublishedDocuments().add(publishedDocumentDTO);
                }
            }
            finally {
                nuxeoController.setCacheType(cacheType);
                nuxeoController.setAuthType(authType);
            }
        }
    }
}

