/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.files;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.FileBrowserView;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserItem;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserSortCriteria;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserStatus;
import fr.toutatice.portail.cms.nuxeo.portlets.files.GetFolderFilesCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.files.MoveDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.files.SortDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.files.UploadFilesCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.ecm.EcmViews;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.Notifications;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.panels.IPanelsService;
import org.osivia.portal.api.panels.Panel;
import org.osivia.portal.api.portlet.IPortletStatusService;
import org.osivia.portal.api.portlet.PortletStatus;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.context.ControllerContextAdapter;

public class FileBrowserPortlet
extends CMSPortlet {
    private static final int FILE_UPLOAD_NOTIFICATIONS_DURATION = 1000;
    public static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.nuxeoPath";
    private static final String VIEW_REQUEST_PARAMETER = "view";
    private static final String SORT_CRITERIA_REQUEST_PARAMETER = "sort";
    private static final String ALTERNATIVE_SORT_REQUEST_PARAMETER = "alt";
    private static final String SORT_CRITERIA_PRINCIPAL_ATTRIBUTE = "osivia.fileBrowser.sortCriteria";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/files/admin.jsp";
    private static final String PATH_VIEW = "/WEB-INF/jsp/files/view.jsp";
    private static final String PATH_ERROR = "/WEB-INF/jsp/files/error.jsp";
    private IBundleFactory bundleFactory;
    private INotificationsService notificationsService;
    private IPortletStatusService portletStatusService;
    private IPanelsService panelsService;
    private ITaskbarService taskbarService;
    private DocumentDAO documentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext portletContext = this.getPortletContext();
        IInternationalizationService internationalizationService = (IInternationalizationService)portletContext.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationsService = (INotificationsService)portletContext.getAttribute("NotificationsService");
        this.portletStatusService = (IPortletStatusService)Locator.findMBean(IPortletStatusService.class, (String)"osivia:service=PortletStatusService");
        this.panelsService = (IPanelsService)Locator.findMBean(IPanelsService.class, (String)"osivia:service=PanelsService");
        this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
        this.documentDAO = DocumentDAO.getInstance();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("javax.portlet.action");
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            if ("changeView".equals(action)) {
                String taskId;
                FileBrowserView view = FileBrowserView.fromName((String)request.getParameter(VIEW_REQUEST_PARAMETER));
                String path = this.getPath(window);
                NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)path);
                Document document = documentContext.getDoc();
                String type = document.getType();
                try {
                    taskId = this.taskbarService.getActiveId(portalControllerContext);
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
                FileBrowserStatus status = (FileBrowserStatus)this.portletStatusService.getStatus(portalControllerContext, this.getPortletName(), FileBrowserStatus.class);
                if (status == null) {
                    status = new FileBrowserStatus(taskId);
                }
                status.getViews().put(type, view);
                this.portletStatusService.setStatus(portalControllerContext, this.getPortletName(), (PortletStatus)status);
            } else if ("delete".equals(action)) {
                Object[] identifiers = StringUtils.split((String)request.getParameter("identifiers"), (String)",");
                if (ArrayUtils.isNotEmpty((Object[])identifiers)) {
                    try {
                        for (Object id : identifiers) {
                            cmsService.putDocumentInTrash(cmsContext, (String)id);
                        }
                        String message = bundle.getString("SUCCESS_MESSAGE_DELETE");
                        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
                    }
                    catch (CMSException e) {
                        String message = bundle.getString("ERROR_MESSAGE_ERROR_HAS_OCCURED");
                        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
                    }
                }
            } else if ("drop".equals(action)) {
                List<String> sourceIds = Arrays.asList(StringUtils.split((String)request.getParameter("sourceIds"), (String)","));
                String targetId = request.getParameter("targetId");
                MoveDocumentCommand command = new MoveDocumentCommand(sourceIds, targetId);
                try {
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    request.setAttribute("osivia.updateContents", (Object)"true");
                    response.setRenderParameter("dnd-update", String.valueOf(System.currentTimeMillis()));
                    String message = sourceIds.size() == 1 ? bundle.getString("DOCUMENT_MOVE_SUCCESS_MESSAGE") : bundle.getString("DOCUMENTS_MOVE_SUCCESS_MESSAGE", new Object[]{sourceIds.size()});
                    this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
                }
                catch (NuxeoException e) {
                    String message = sourceIds.size() == 1 ? bundle.getString("DOCUMENT_MOVE_WARNING_MESSAGE") : bundle.getString("DOCUMENTS_MOVE_WARNING_MESSAGE", new Object[]{sourceIds.size()});
                    this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.WARNING);
                }
            } else if (SORT_CRITERIA_REQUEST_PARAMETER.equals(action)) {
                String sourceId = request.getParameter("sourceId");
                String targetId = request.getParameter("targetId");
                SortDocumentCommand command = new SortDocumentCommand(sourceId, targetId);
                nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                request.setAttribute("osivia.updateContents", (Object)"true");
            } else if ("fileUpload".equals(action)) {
                Notifications notifications;
                String parentId = request.getParameter("parentId");
                try {
                    DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
                    PortletFileUpload fileUpload = new PortletFileUpload((FileItemFactory)fileItemFactory);
                    List fileItems = fileUpload.parseRequest(request);
                    UploadFilesCommand command = new UploadFilesCommand(parentId, fileItems);
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    request.setAttribute("osivia.updateContents", (Object)"true");
                    notifications = new Notifications(NotificationsType.SUCCESS, 1000);
                    notifications.addMessage(bundle.getString("MESSAGE_FILE_UPLOAD_SUCCESS"));
                }
                catch (FileUploadException e) {
                    notifications = new Notifications(NotificationsType.ERROR, 1000);
                    notifications.addMessage(bundle.getString("MESSAGE_FILE_UPLOAD_ERROR"));
                }
                this.notificationsService.addNotifications(portalControllerContext, notifications);
            }
        } else if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                String path = request.getParameter("path");
                window.setProperty(NUXEO_PATH_WINDOW_PROPERTY, path);
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        request.setAttribute("path", (Object)path);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRequestDispatcher dispatcher;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = this.getPath(window);
        if (StringUtils.isNotEmpty((String)path)) {
            try {
                PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
                NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
                path = nuxeoController.getComputedPath(path);
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                Document currentDocument = documentContext.getDoc();
                nuxeoController.setCurrentDoc(currentDocument);
                request.setAttribute("document", (Object)this.documentDAO.toDTO(currentDocument));
                CMSPublicationInfos publicationInfos = this.getCMSService().getPublicationInfos(cmsContext, path);
                boolean editable = publicationInfos.isEditableByUser();
                request.setAttribute("editable", (Object)editable);
                GetFolderFilesCommand command = new GetFolderFilesCommand(publicationInfos.getLiveId());
                Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                int index = 1;
                ArrayList<FileBrowserItem> fileBrowserItems = new ArrayList<FileBrowserItem>(documents.size());
                for (Document document : documents) {
                    DocumentDTO documentDTO = this.documentDAO.toDTO(document);
                    FileBrowserItem fileBrowserItem = new FileBrowserItem(documentDTO);
                    fileBrowserItem.setIndex(index++);
                    if ("File".equals(document.getType())) {
                        this.addMimeType(document, (DocumentDTO)fileBrowserItem);
                    }
                    fileBrowserItems.add(fileBrowserItem);
                }
                DocumentType cmsItemType = (DocumentType)nuxeoController.getCMSItemTypes().get(currentDocument.getType());
                boolean ordered = cmsItemType != null && cmsItemType.isOrdered();
                request.setAttribute("ordered", (Object)ordered);
                FileBrowserView currentView = this.getCurrentView(portalControllerContext, window, currentDocument.getType());
                request.setAttribute(VIEW_REQUEST_PARAMETER, (Object)currentView.getName());
                FileBrowserSortCriteria criteria = this.getSortCriteria(portalControllerContext, ordered, currentView);
                request.setAttribute("criteria", (Object)criteria);
                FileBrowserComparator comparator = new FileBrowserComparator(criteria);
                Collections.sort(fileBrowserItems, comparator);
                request.setAttribute("documents", fileBrowserItems);
                this.addMenubarItems(portalControllerContext, currentView);
                this.addToolbarAttributes(portalControllerContext, nuxeoController, currentDocument);
                response.setTitle(currentDocument.getTitle());
                if (WindowState.MAXIMIZED.equals((Object)request.getWindowState())) {
                    nuxeoController.insertContentMenuBarItems();
                }
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
            dispatcher = this.getPortletContext().getRequestDispatcher(PATH_VIEW);
        } else {
            dispatcher = this.getPortletContext().getRequestDispatcher(PATH_ERROR);
        }
        response.setContentType("text/html");
        dispatcher.include(request, response);
    }

    private String getPath(PortalWindow window) {
        String path = window.getProperty("osivia.cms.uri");
        if (path == null) {
            path = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        }
        return path;
    }

    private void addMimeType(Document document, DocumentDTO documentDTO) {
        String icon = "file";
        PropertyMap fileContent = document.getProperties().getMap("file:content");
        if (fileContent != null) {
            try {
                MimeType mimeType = new MimeType(fileContent.getString("mime-type"));
                String primaryType = mimeType.getPrimaryType();
                String subType = mimeType.getSubType();
                if ("application".equals(primaryType)) {
                    if ("pdf".equals(subType)) {
                        icon = "pdf";
                    } else if ("msword".equals(subType) || "vnd.openxmlformats-officedocument.wordprocessingml.document".equals(subType)) {
                        icon = "word";
                    } else if ("vnd.ms-excel".equals(subType) || "vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(subType)) {
                        icon = "excel";
                    } else if ("vnd.ms-powerpoint".equals(subType) || "vnd.openxmlformats-officedocument.presentationml.presentation".equals(subType)) {
                        icon = "powerpoint";
                    } else if ("vnd.oasis.opendocument.text".equals(subType)) {
                        icon = "odt";
                    } else if ("vnd.oasis.opendocument.spreadsheet".equals(subType)) {
                        icon = "ods";
                    } else if ("vnd.oasis.opendocument.presentation".equals(subType)) {
                        icon = "odp";
                    } else if ("zip".equals(subType) || "gzip".equals(subType)) {
                        icon = "archive";
                    }
                } else if ("text".equals(primaryType)) {
                    icon = "html".equals(subType) || "xml".equals(subType) ? "xml" : "text";
                } else if ("image".equals(primaryType)) {
                    icon = "image";
                } else if ("video".equals(primaryType)) {
                    icon = "video";
                } else if ("audio".equals(primaryType)) {
                    icon = "audio";
                }
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                // empty catch block
            }
        }
        documentDTO.getProperties().put("mimeTypeIcon", icon);
    }

    private FileBrowserView getCurrentView(PortalControllerContext portalControllerContext, PortalWindow window, String type) throws PortletException {
        String taskId;
        FileBrowserStatus status = (FileBrowserStatus)this.portletStatusService.getStatus(portalControllerContext, this.getPortletName(), FileBrowserStatus.class);
        try {
            taskId = this.taskbarService.getActiveId(portalControllerContext);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        FileBrowserView currentView = null;
        if (status != null) {
            if (StringUtils.equals((String)taskId, (String)status.getTaskId())) {
                currentView = (FileBrowserView)status.getViews().get(type);
            } else {
                this.portletStatusService.setStatus(portalControllerContext, this.getPortletName(), null);
            }
        }
        if (currentView == null) {
            currentView = FileBrowserView.fromName((String)window.getProperty("osivia.defaultView"));
        }
        try {
            if (currentView.isClosedNavigation()) {
                this.panelsService.hidePanel(portalControllerContext, Panel.NAVIGATION_PANEL);
            } else {
                this.panelsService.showPanel(portalControllerContext, Panel.NAVIGATION_PANEL);
            }
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return currentView;
    }

    private FileBrowserSortCriteria getSortCriteria(PortalControllerContext portalControllerContext, boolean ordered, FileBrowserView currentView) {
        ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
        PortletRequest request = portalControllerContext.getRequest();
        FileBrowserSortCriteria criteria = null;
        if (currentView.isOrderable()) {
            String sort = request.getParameter(SORT_CRITERIA_REQUEST_PARAMETER);
            if (StringUtils.isEmpty((String)sort)) {
                Object attribute = controllerContext.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_PRINCIPAL_ATTRIBUTE);
                if (attribute != null && attribute instanceof FileBrowserSortCriteria) {
                    criteria = (FileBrowserSortCriteria)controllerContext.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_PRINCIPAL_ATTRIBUTE);
                    if (!ordered && "index".equals(criteria.getSort())) {
                        criteria.setSort("name");
                    }
                }
            } else {
                boolean alternative = BooleanUtils.toBoolean((String)request.getParameter(ALTERNATIVE_SORT_REQUEST_PARAMETER));
                criteria = new FileBrowserSortCriteria();
                criteria.setSort(sort);
                criteria.setAlternative(alternative);
                controllerContext.setAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_PRINCIPAL_ATTRIBUTE, (Object)criteria);
            }
        }
        if (criteria == null) {
            criteria = new FileBrowserSortCriteria();
            if (ordered) {
                criteria.setSort("index");
            } else {
                criteria.setSort("name");
            }
        }
        return criteria;
    }

    private void addMenubarItems(PortalControllerContext portalControllerContext, FileBrowserView currentView) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        List menubar = (List)request.getAttribute("osivia.menuBar");
        if (response instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)response;
            int order = 0;
            for (FileBrowserView view : FileBrowserView.values()) {
                if (view == currentView) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("FILE_BROWSER_SHOW_");
                builder.append(StringUtils.upperCase((String)view.getName()));
                String id = builder.toString();
                PortletURL actionURL = mimeResponse.createActionURL();
                actionURL.setParameter("javax.portlet.action", "changeView");
                actionURL.setParameter(VIEW_REQUEST_PARAMETER, view.getName());
                MenubarItem menubarItem = new MenubarItem(id, bundle.getString(id), view.getIcon(), (MenubarContainer)MenubarGroup.SPECIFIC, order, actionURL.toString(), null, null, null);
                menubar.add(menubarItem);
                ++order;
            }
        }
    }

    private void addToolbarAttributes(PortalControllerContext portalControllerContext, NuxeoController nuxeoController, Document currentDocument) throws CMSException, PortalException {
        PortletRequest request = portalControllerContext.getRequest();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        String callbackURL = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, currentDocument.getPath(), null, null, "_LIVE_", null, null, null, null);
        request.setAttribute("callbackURL", (Object)callbackURL);
        String ecmBaseURL = this.getCMSService().getEcmDomain(cmsContext);
        request.setAttribute("ecmBaseURL", (Object)ecmBaseURL);
        String editURL = this.getCMSService().getEcmUrl(cmsContext, EcmViews.editDocument, "_PATH_", new HashMap(0));
        request.setAttribute("editURL", (Object)editURL);
        HashMap<String, String> moveProperties = new HashMap<String, String>();
        moveProperties.put("osivia.move.documentPath", currentDocument.getPath());
        moveProperties.put("osivia.move.documentsIdentifiers", "_IDS_");
        moveProperties.put("osivia.move.ignoredPaths", "_PATHS_");
        moveProperties.put("osivia.move.cmsBasePath", nuxeoController.getBasePath());
        moveProperties.put("osivia.move.acceptedTypes", "_TYPES_");
        String moveURL = this.getPortalUrlFactory().getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-move-portlet-instance", moveProperties, true);
        request.setAttribute("moveURL", (Object)moveURL);
    }
}

