/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class LinkFragmentModule
extends FragmentModule {
    public static final String ID = "doc_link";
    public static final String NAME_WINDOW_PROPERTY = "osivia.linkName";
    public static final String TARGET_PATH_WINDOW_PROPERTY = "osivia.docPathForLink";
    public static final String NUXEO_LINK_WINDOW_PROPERTY = "osivia.isNuxeoLink";
    public static final String CSS_CLASSES_WINDOW_PROPERTY = "osivia.cssLinkClass";
    private static final String JSP_NAME = "link";

    public LinkFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(request, response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String name = window.getProperty(NAME_WINDOW_PROPERTY);
        String targetPath = window.getProperty(TARGET_PATH_WINDOW_PROPERTY);
        boolean nuxeoLink = BooleanUtils.toBoolean((String)window.getProperty(NUXEO_LINK_WINDOW_PROPERTY));
        String cssClasses = window.getProperty(CSS_CLASSES_WINDOW_PROPERTY);
        if (StringUtils.isNotEmpty((String)targetPath)) {
            Document document;
            String property;
            targetPath = nuxeoController.getComputedPath(targetPath);
            if (nuxeoLink) {
                nuxeoController.setDisplayLiveVersion("1");
            }
            if (StringUtils.isNotEmpty((String)(property = (document = nuxeoController.fetchDocument(targetPath)).getProperties().getString(name)))) {
                name = property;
            }
            request.setAttribute("name", (Object)name);
            Link link = nuxeoLink ? nuxeoController.getLink(document, "nuxeo-link") : nuxeoController.getLink(document);
            request.setAttribute(JSP_NAME, (Object)link);
            request.setAttribute("cssClasses", (Object)cssClasses);
        } else {
            request.setAttribute("messageKey", (Object)"MESSAGE_PATH_UNDEFINED");
        }
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String name = window.getProperty(NAME_WINDOW_PROPERTY);
        request.setAttribute("name", (Object)name);
        String targetPath = window.getProperty(TARGET_PATH_WINDOW_PROPERTY);
        request.setAttribute("targetPath", (Object)targetPath);
        boolean nuxeoLink = BooleanUtils.toBoolean((String)window.getProperty(NUXEO_LINK_WINDOW_PROPERTY));
        request.setAttribute("nuxeoLink", (Object)nuxeoLink);
        String cssClasses = window.getProperty(CSS_CLASSES_WINDOW_PROPERTY);
        request.setAttribute("cssClasses", (Object)cssClasses);
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            window.setProperty(NAME_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("name")));
            window.setProperty(TARGET_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("targetPath")));
            window.setProperty(NUXEO_LINK_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("nuxeoLink")));
            window.setProperty(CSS_CLASSES_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("cssClasses")));
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return JSP_NAME;
    }

    public String getAdminJSPName() {
        return JSP_NAME;
    }
}

