/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.context.ControllerContextAdapter;

public class NavigationPictureFragmentModule
extends FragmentModule {
    public static final String ID = "navigation_picture";
    public static final String PROPERTY_NAME_WINDOW_PROPERTY = "osivia.propertyName";
    private static final String ADMIN_JSP_NAME = "navigation-picture";
    private static final String VIEW_JSP_NAME = "picture";

    public NavigationPictureFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(request, response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        CMSServiceCtx cmsReadNavContext = new CMSServiceCtx();
        cmsReadNavContext.setControllerContext(ControllerContextAdapter.getControllerContext((PortalControllerContext)nuxeoController.getPortalCtx()));
        cmsReadNavContext.setScope(nuxeoController.getNavigationScope());
        String propertyName = window.getProperty(PROPERTY_NAME_WINDOW_PROPERTY);
        if (StringUtils.isNotEmpty((String)nuxeoController.getNavigationPath())) {
            if (StringUtils.isNotEmpty((String)propertyName)) {
                Document navigationPictureContainer = this.computePicture(nuxeoController, cmsReadNavContext, propertyName);
                if (navigationPictureContainer != null) {
                    String imageSource = nuxeoController.createFileLink(navigationPictureContainer, propertyName);
                    request.setAttribute("imageSource", (Object)imageSource);
                } else {
                    request.setAttribute("osivia.emptyResponse", (Object)"1");
                }
            } else {
                request.setAttribute("messageKey", (Object)"FRAGMENT_MESSAGE_PROPERTY_UNDEFINED");
            }
        } else {
            request.setAttribute("messageKey", (Object)"MESSAGE_PATH_UNDEFINED");
        }
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String propertyName = window.getProperty(PROPERTY_NAME_WINDOW_PROPERTY);
        request.setAttribute("propertyName", (Object)propertyName);
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            window.setProperty(PROPERTY_NAME_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("propertyName")));
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return VIEW_JSP_NAME;
    }

    public String getAdminJSPName() {
        return ADMIN_JSP_NAME;
    }

    private Document computePicture(NuxeoController ctx, CMSServiceCtx navCtx, String propertyName) throws PortletException {
        try {
            Document pictureContainer = null;
            boolean hasPicture = false;
            String pathToCheck = ctx.getNavigationPath();
            Document currentDoc = ctx.fetchDocument(ctx.getContentPath());
            if (this.docHasPicture(currentDoc, propertyName)) {
                return currentDoc;
            }
            do {
                CMSItem cmsItemNav;
                if ((cmsItemNav = NuxeoController.getCMSService().getPortalNavigationItem(navCtx, ctx.getSpacePath(), pathToCheck)) != null && cmsItemNav.getNativeItem() != null) {
                    pictureContainer = (Document)cmsItemNav.getNativeItem();
                    hasPicture = this.docHasPicture(pictureContainer, propertyName);
                }
                CMSObjectPath parentPath = CMSObjectPath.parse((String)pathToCheck).getParent();
                pathToCheck = parentPath.toString();
            } while (!hasPicture && pathToCheck.contains(ctx.getSpacePath()));
            if (hasPicture) {
                return pictureContainer;
            }
            return null;
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private boolean docHasPicture(Document currentDoc, String propertyName) {
        PropertyMap picture = (PropertyMap)currentDoc.getProperties().get(propertyName);
        boolean hasPicture = picture != null && picture.get("data") != null;
        return hasPicture;
    }
}

