/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class PropertyFragmentModule
extends FragmentModule {
    public static final String TEXT_ID = "text_property";
    public static final String HTML_ID = "html_property";
    public static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    public static final String PROPERTY_NAME_WINDOW_PROPERTY = "osivia.propertyName";
    public static final String SCOPE_WINDOW_PROPERTY = "osivia.cms.forcePublicationScope";
    public static final String CMS_MENU_DISPLAY_WINDOW_PROPERTY = "osivia.cms.menu";
    public static final String REF_URI_WINDOW_PROPERTY = "osivia.refURI";
    private static final String JSP_NAME = "property";
    private static final String REF_URI = "refURI";
    private final boolean html;

    public PropertyFragmentModule(PortletContext portletContext, boolean html) {
        super(portletContext);
        this.html = html;
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        RenderResponse response = (RenderResponse)portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(request, (PortletResponse)response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        String propertyName = window.getProperty(PROPERTY_NAME_WINDOW_PROPERTY);
        boolean cmsMenuDisplay = BooleanUtils.toBoolean((String)window.getProperty(CMS_MENU_DISPLAY_WINDOW_PROPERTY));
        String refURI = window.getProperty(REF_URI_WINDOW_PROPERTY);
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            nuxeoPath = nuxeoController.getComputedPath(nuxeoPath);
            Document document = nuxeoController.fetchDocument(nuxeoPath);
            nuxeoController.setCurrentDoc(document);
            if (StringUtils.isNotBlank((String)document.getTitle())) {
                response.setTitle(document.getTitle());
            }
            if (StringUtils.isNotEmpty((String)propertyName)) {
                String propertyValue;
                if (this.html && StringUtils.isNotEmpty((String)refURI)) {
                    propertyValue = "";
                    Object object = document.getProperties().get(propertyName);
                    if (object instanceof PropertyList) {
                        PropertyList propertyList = (PropertyList)object;
                        if (propertyList != null && !propertyList.isEmpty()) {
                            for (int i = 0; i < propertyList.size(); ++i) {
                                PropertyMap propertyMap = propertyList.getMap(i);
                                String refURIValue = propertyMap.getString(REF_URI);
                                if (!refURI.equalsIgnoreCase(refURIValue)) continue;
                                propertyValue = propertyMap.getString("data");
                                break;
                            }
                        }
                    } else {
                        request.setAttribute("messageKey", (Object)"FRAGMENT_MESSAGE_INVALID_COMPLEX_PROPERTY");
                    }
                } else {
                    propertyValue = document.getProperties().getString(propertyName);
                }
                if (StringUtils.isNotBlank((String)propertyValue)) {
                    if (this.html) {
                        propertyValue = nuxeoController.transformHTMLContent(propertyValue);
                    }
                    request.setAttribute("content", (Object)propertyValue);
                    if (cmsMenuDisplay) {
                        nuxeoController.insertContentMenuBarItems();
                    }
                } else {
                    request.setAttribute("osivia.emptyResponse", (Object)"1");
                }
            } else {
                request.setAttribute("messageKey", (Object)"FRAGMENT_MESSAGE_PROPERTY_UNDEFINED");
            }
        } else {
            request.setAttribute("messageKey", (Object)"MESSAGE_PATH_UNDEFINED");
        }
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(request, response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        request.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String propertyName = window.getProperty(PROPERTY_NAME_WINDOW_PROPERTY);
        request.setAttribute("propertyName", (Object)propertyName);
        String scope = window.getProperty(SCOPE_WINDOW_PROPERTY);
        String scopes = nuxeoController.formatScopeList(scope);
        request.setAttribute("scopes", (Object)scopes);
        boolean cmsMenuDisplay = BooleanUtils.toBoolean((String)window.getProperty(CMS_MENU_DISPLAY_WINDOW_PROPERTY));
        request.setAttribute("cmsMenu", (Object)cmsMenuDisplay);
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            window.setProperty(NUXEO_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("nuxeoPath")));
            window.setProperty(PROPERTY_NAME_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("propertyName")));
            window.setProperty(SCOPE_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("scope")));
            window.setProperty(CMS_MENU_DISPLAY_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("cmsMenu")));
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return JSP_NAME;
    }

    public String getAdminJSPName() {
        return JSP_NAME;
    }
}

