/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.move;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.files.MoveDocumentCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentState;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class MoveDocumentPortlet
extends CMSPortlet {
    public static final String DOCUMENT_PATH_WINDOW_PROPERTY = "osivia.move.documentPath";
    public static final String DOCUMENTS_IDENTIFIERS_WINDOW_PROPERTY = "osivia.move.documentsIdentifiers";
    public static final String IGNORED_PATHS_WINDOW_PROPERTY = "osivia.move.ignoredPaths";
    public static final String CMS_BASE_PATH_WINDOW_PROPERTY = "osivia.move.cmsBasePath";
    public static final String ACCEPTED_TYPES_WINDOW_PROPERTY = "osivia.move.acceptedTypes";
    private static final String SPACE_PATH_REQUEST_PARAMETER = "osivia.move.spacePath";
    private static final String MODE_REQUEST_PARAMETER = "osivia.move.mode";
    private static final String VIEW_PATH = "/WEB-INF/jsp/move/view.jsp";
    private static final String CHANGE_SPACE_PATH = "/WEB-INF/jsp/move/change-space.jsp";
    private DocumentDAO documentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.documentDAO = DocumentDAO.getInstance();
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String ignoredPaths = window.getProperty(IGNORED_PATHS_WINDOW_PROPERTY);
        if (ignoredPaths == null) {
            String documentPath = window.getProperty(DOCUMENT_PATH_WINDOW_PROPERTY);
            request.setAttribute("ignoredPaths", (Object)documentPath);
        } else {
            request.setAttribute("ignoredPaths", (Object)ignoredPaths);
        }
        String cmsBasePath = request.getParameter(SPACE_PATH_REQUEST_PARAMETER);
        if (cmsBasePath == null) {
            cmsBasePath = window.getProperty(CMS_BASE_PATH_WINDOW_PROPERTY);
        }
        if (cmsBasePath != null) {
            cmsBasePath = nuxeoController.getComputedPath(cmsBasePath);
            request.setAttribute("cmsBasePath", (Object)cmsBasePath);
            NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)cmsBasePath);
            Document nuxeoDocument = documentContext.getDoc();
            DocumentDTO documentDto = this.documentDAO.toDTO(nuxeoDocument);
            request.setAttribute("spaceDocument", (Object)documentDto);
        }
        String acceptedTypes = window.getProperty(ACCEPTED_TYPES_WINDOW_PROPERTY);
        request.setAttribute("acceptedTypes", (Object)acceptedTypes);
        String dispatcherPath = "space".equals(request.getParameter(MODE_REQUEST_PARAMETER)) ? CHANGE_SPACE_PATH : VIEW_PATH;
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(dispatcherPath).include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Bundle bundle = this.getBundleFactory().getBundle(request.getLocale());
        String action = request.getParameter("javax.portlet.action");
        if ("move".equals(action)) {
            CMSPublicationInfos publicationInfos;
            String path = window.getProperty(DOCUMENT_PATH_WINDOW_PROPERTY);
            CMSServiceCtx cmsCtx = nuxeoController.getCMSCtx();
            try {
                publicationInfos = NuxeoController.getCMSService().getPublicationInfos(cmsCtx, path);
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
            cmsCtx.setDisplayLiveVersion(DocumentState.LIVE.toString());
            path = NuxeoController.getLivePath((String)path);
            NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((CMSServiceCtx)cmsCtx, (String)path);
            Document document = documentContext.getDoc();
            try {
                cmsCtx.setDisplayLiveVersion(DocumentState.PUBLISHED.toString());
                NuxeoDocumentContext remotedocumentContext = NuxeoController.getDocumentContext((CMSServiceCtx)cmsCtx, (String)path);
                Document publishedDocument = remotedocumentContext.getDoc();
                cmsCtx.setDoc((Object)publishedDocument);
                if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsCtx, (CMSPublicationInfos)publicationInfos)) {
                    document = publishedDocument;
                }
            }
            catch (Exception remotedocumentContext) {
                // empty catch block
            }
            String[] identifiersProperty = StringUtils.split((String)window.getProperty(DOCUMENTS_IDENTIFIERS_WINDOW_PROPERTY), (String)",");
            String targetPath = request.getParameter("targetPath");
            if (StringUtils.isNotBlank((String)targetPath)) {
                String redirectionPath;
                CMSPublicationInfos targetPubInfos;
                List<String> sourceIds;
                if (identifiersProperty == null) {
                    sourceIds = new ArrayList<String>(1);
                    sourceIds.add(document.getId());
                } else {
                    sourceIds = Arrays.asList(identifiersProperty);
                }
                try {
                    targetPubInfos = NuxeoController.getCMSService().getPublicationInfos(cmsCtx, targetPath);
                }
                catch (CMSException e) {
                    throw new PortletException((Throwable)e);
                }
                String targetId = targetPubInfos.getLiveId();
                if (identifiersProperty == null) {
                    CMSObjectPath parentPath = CMSObjectPath.parse((String)document.getPath()).getParent();
                    redirectionPath = parentPath.toString();
                } else {
                    redirectionPath = document.getPath();
                }
                MoveDocumentCommand command = new MoveDocumentCommand(sourceIds, targetId);
                nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                String redirectionURL = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, redirectionPath, null, null, "refreshPageAndNavigation", null, null, null, null);
                redirectionURL = this.getPortalUrlFactory().adaptPortalUrlToPopup(portalControllerContext, redirectionURL, 1);
                request.setAttribute("osivia.redirection.url", (Object)redirectionURL);
                String message = sourceIds.size() == 1 ? bundle.getString("DOCUMENT_MOVE_SUCCESS_MESSAGE") : bundle.getString("DOCUMENTS_MOVE_SUCCESS_MESSAGE", new Object[]{sourceIds.size()});
                this.getNotificationsService().addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
            } else {
                String redirectionURL = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, path, null, null, null, null, null, null, null);
                redirectionURL = this.getPortalUrlFactory().adaptPortalUrlToPopup(portalControllerContext, redirectionURL, 1);
                request.setAttribute("osivia.redirection.url", (Object)redirectionURL);
                int size = 1;
                if (identifiersProperty != null) {
                    size = identifiersProperty.length;
                }
                String message = size == 1 ? bundle.getString("DOCUMENT_MOVE_WARNING_MESSAGE") : bundle.getString("DOCUMENTS_MOVE_WARNING_MESSAGE", new Object[]{size});
                this.getNotificationsService().addSimpleNotification(portalControllerContext, message, NotificationsType.WARNING);
            }
        } else if ("changeSpace".equals(action)) {
            String spacePath = request.getParameter("spacePath");
            response.setRenderParameter(SPACE_PATH_REQUEST_PARAMETER, spacePath);
        }
    }
}

