/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.site;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.ResourceUtil;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class SitePictureServlet
extends HttpServlet {
    private static final long serialVersionUID = -8877737456357488020L;
    private static PortletContext portletCtx;
    private static long PICTURE_TIMEOUT;

    public static void setPortletContext(PortletContext documentPortletCtx) {
        portletCtx = documentPortletCtx;
    }

    public String formatResourceLastModified() {
        SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return inputFormater.format(new Date(System.currentTimeMillis()));
    }

    public boolean isResourceExpired(String sOriginalDate) {
        boolean isExpired = true;
        if (sOriginalDate != null) {
            SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                Date originalDate = inputFormater.parse(sOriginalDate);
                if (System.currentTimeMillis() < originalDate.getTime() + PICTURE_TIMEOUT * 1000L) {
                    isExpired = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isExpired;
    }

    public boolean serveResourceByCache(HttpServletRequest resourceRequest, HttpServletResponse resourceResponse) throws PortletException, IOException {
        String sOriginalDate = resourceRequest.getHeader("if-modified-since");
        if (sOriginalDate == null) {
            sOriginalDate = resourceRequest.getHeader("If-Modified-Since");
        }
        if (!this.isResourceExpired(sOriginalDate)) {
            resourceResponse.sendError(304);
            resourceResponse.setHeader("Last-Modified", sOriginalDate);
            return true;
        }
        return false;
    }

    public void doGet(HttpServletRequest theRequest, HttpServletResponse theResponse) throws IOException, ServletException {
        ServletOutputStream output = theResponse.getOutputStream();
        try {
            if (this.serveResourceByCache(theRequest, theResponse)) {
                return;
            }
            String docPath = theRequest.getParameter("path");
            docPath = URLDecoder.decode(docPath, "UTF-8");
            NuxeoController ctx = new NuxeoController(portletCtx);
            ctx.setServletRequest(theRequest);
            ctx.setScope("anonymous");
            String pictureContent = theRequest.getParameter("content");
            ctx.setAuthType(NuxeoCommandContext.AUTH_TYPE_ANONYMOUS);
            ctx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            CMSBinaryContent content = ctx.fetchPicture(docPath, pictureContent);
            theResponse.setContentType(content.getMimeType());
            theResponse.setHeader("Cache-Control", "max-age=" + PICTURE_TIMEOUT);
            theResponse.setHeader("Last-Modified", this.formatResourceLastModified());
            ResourceUtil.copy((InputStream)new FileInputStream(content.getFile()), (OutputStream)theResponse.getOutputStream(), (int)4096);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            output.close();
        }
    }

    static {
        PICTURE_TIMEOUT = 600L;
    }
}

