/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindowHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class ListEditableWindow
extends EditableWindow {
    private static final String LIST_SCHEMA = "listfgt:listFragment";

    public ListEditableWindow(String instancePortlet, String prefixWindow) {
        super(instancePortlet, prefixWindow);
    }

    public Map<String, String> fillProps(Document doc, PropertyMap fragment, Boolean modeEditionPage) {
        Map properties = super.fillGenericProps(doc, fragment, modeEditionPage);
        PropertyMap mapListe = EditableWindowHelper.findSchemaByRefURI((Document)doc, (String)LIST_SCHEMA, (String)fragment.getString("uri"));
        properties.put("osivia.nuxeoRequest", mapListe.getString("request"));
        properties.put("osivia.beanShell", String.valueOf(true));
        properties.put("osivia.cms.scope", null);
        properties.put("osivia.cms.hideMetaDatas", "1");
        properties.put("osivia.displayNuxeoRequest", String.valueOf(false));
        if (mapListe.getBoolean("allContents").booleanValue()) {
            properties.put("osivia.cms.requestFilteringPolicy", "global");
            properties.put("osivia.cms.displayLiveVersion", "1");
        } else {
            properties.put("osivia.cms.requestFilteringPolicy", null);
            properties.put("osivia.cms.displayLiveVersion", null);
        }
        properties.put("osivia.cms.style", mapListe.getString("view"));
        properties.put("osivia.cms.pageSize", mapListe.getString("pageSize"));
        properties.put("osivia.cms.pageSizeMax", mapListe.getString("pageSizeMax"));
        properties.put("osivia.cms.maxItems", mapListe.getString("maxItems"));
        properties.put("osivia.permaLinkRef", null);
        properties.put("osivia.rssLinkRef", null);
        properties.put("osivia.rssTitle", null);
        properties.put("osivia.useES", String.valueOf(NuxeoCompatibility.canUseES()));
        return properties;
    }

    public List<String> prepareDelete(Document doc, String refURI) {
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        this.prepareDeleteGeneric(propertiesToRemove, doc, refURI);
        Integer indexToRemove = EditableWindowHelper.findIndexByRefURI((Document)doc, (String)LIST_SCHEMA, (String)refURI);
        propertiesToRemove.add(LIST_SCHEMA.concat("/").concat(indexToRemove.toString()));
        return propertiesToRemove;
    }
}

