/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.tag;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.tag.INuxeoTagService;
import fr.toutatice.portail.cms.nuxeo.portlets.bridge.Formater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;
import org.osivia.portal.core.web.IWebIdService;

public class NuxeoTagService
implements INuxeoTagService {
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IWebIdService webIdService = (IWebIdService)Locator.findMBean(IWebIdService.class, (String)"osivia:service=webIdService");
    private final IDirectoryServiceLocator directoryServiceLocator = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");

    public Link getDocumentLink(NuxeoController nuxeoController, DocumentDTO document, String property, String displayContext, boolean picture, boolean permalink) {
        Object link;
        Object nuxeoDocument = document != null ? document.getDocument() : (nuxeoController != null ? nuxeoController.getCurrentDoc() : null);
        if (nuxeoDocument != null) {
            if (picture) {
                String url = StringUtils.isEmpty((String)property) ? nuxeoController.createPictureLink(nuxeoDocument.getPath(), StringUtils.defaultIfEmpty((String)displayContext, (String)"Original")) : (nuxeoDocument.getProperties().getMap(property) != null ? nuxeoController.createFileLink(nuxeoDocument, property) : null);
                link = url != null ? new Link(url, false) : null;
            } else if (permalink) {
                Page page = null;
                Window window = (Window)nuxeoController.getRequest().getAttribute("osivia.window");
                if (window != null) {
                    page = window.getPage();
                }
                try {
                    CMSServiceCtx cmsContext;
                    CMSService cmsService;
                    CMSItem cmsItem;
                    String path = document.getPath();
                    if (PortalObjectUtils.isSpaceSite((PortalObject)page) && StringUtils.isNotEmpty((String)(cmsItem = (cmsService = (CMSService)NuxeoController.getCMSService()).createItem(cmsContext = nuxeoController.getCMSCtx(), document.getPath(), null, nuxeoDocument)).getWebId())) {
                        path = this.webIdService.webIdToCmsPath(cmsItem.getWebId());
                    }
                    String url = nuxeoController.getPortalUrlFactory().getPermaLink(nuxeoController.getPortalCtx(), null, null, path, "cms");
                    link = new Link(url, false);
                }
                catch (Exception e) {
                    link = new Link("#", false);
                }
            } else if (StringUtils.isEmpty((String)property)) {
                link = nuxeoController.getLink(nuxeoDocument, StringUtils.trimToNull((String)displayContext));
            } else {
                String value = String.valueOf(document.getProperties().get(property));
                link = nuxeoController.getLinkFromNuxeoURL(value);
            }
        } else {
            link = null;
        }
        return link;
    }

    public DirectoryPerson getDirectoryPerson(NuxeoController nuxeoController, String name) {
        DirectoryPerson person = null;
        IDirectoryService directoryService = this.directoryServiceLocator.getDirectoryService();
        if (directoryService != null) {
            person = directoryService.getPerson(name);
        }
        return person;
    }

    public Link getUserProfileLink(NuxeoController nuxeoController, String name, String displayName) {
        Link link;
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.hideTitle", "1");
        properties.put("osivia.ajaxLink", "1");
        properties.put("theme.dyna.partial_refresh_enabled", "true");
        properties.put("uidFichePersonne", name);
        HashMap parameters = new HashMap(0);
        try {
            String url = this.portalUrlFactory.getStartPortletInNewPage(portalControllerContext, "myprofile", displayName, "directory-person-card-instance", properties, parameters);
            link = new Link(url, false);
        }
        catch (PortalException e) {
            link = null;
        }
        return link;
    }

    public Link getNuxeoIconLink(NuxeoController nuxeoController, String contextPath, DocumentDTO document) {
        String url = contextPath + Formater.formatNuxeoIcon((Document)document.getDocument());
        return new Link(url, false);
    }

    public CustomizedJsp getCustomizedJsp(NuxeoController nuxeoController, String name) throws IOException {
        DefaultCMSCustomizer cmsCustomizer = (DefaultCMSCustomizer)nuxeoController.getNuxeoCMSService().getCMSCustomizer();
        CustomizationPluginMgr pluginManager = cmsCustomizer.getPluginMgr();
        return pluginManager.customizeJSP(name, nuxeoController.getPortletCtx(), nuxeoController.getRequest());
    }
}

