/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.bridge.Formater;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.w3c.dom.Element;

public class RssGenerator {
    private static Log log = LogFactory.getLog(RssGenerator.class);

    public static org.w3c.dom.Document createDocument(NuxeoController ctx, PortalControllerContext portalCtx, String rssTitle, PaginableDocuments docs, String permLinkRef) throws Exception {
        HttpServletRequest request = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalCtx).getServerInvocation().getServerContext().getClientRequest();
        SimpleDateFormat nuxeoFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
        nuxeoFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        SimpleDateFormat rssDateFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        rssDateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        DocumentBuilderFactory fabrique = DocumentBuilderFactory.newInstance();
        DocumentBuilder constructeur = fabrique.newDocumentBuilder();
        org.w3c.dom.Document document = constructeur.newDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        Element root = document.createElement("rss");
        root.setAttribute("version", "2.0");
        Element channel = document.createElement("channel");
        if (rssTitle != null) {
            Element title = document.createElement("title");
            title.setTextContent(rssTitle);
            channel.appendChild(title);
        }
        Element pubDate = document.createElement("pubDate");
        pubDate.setTextContent(rssDateFormater.format(new Date(System.currentTimeMillis())));
        channel.appendChild(pubDate);
        Element lastBuildDate = document.createElement("lastBuildDate");
        lastBuildDate.setTextContent(rssDateFormater.format(new Date(System.currentTimeMillis())));
        channel.appendChild(lastBuildDate);
        for (Document doc : docs) {
            PropertyMap map;
            String sDescription;
            Element item = document.createElement("item");
            Element title = document.createElement("title");
            title.setTextContent(doc.getTitle());
            item.appendChild(title);
            Element link = document.createElement("link");
            String permaLinkURL = ctx.getPortalUrlFactory().getPermaLink(portalCtx, null, null, doc.getPath(), "cms");
            link.setTextContent(permaLinkURL);
            item.appendChild(link);
            String sDate = doc.getProperties().getString("dc:modified");
            if (sDate == null) {
                sDate = doc.getProperties().getString("dc:created");
            }
            if (sDate != null) {
                Element date = document.createElement("pubDate");
                Date docDate = nuxeoFormater.parse(sDate);
                date.setTextContent(rssDateFormater.format(docDate));
                item.appendChild(date);
            }
            if ((sDescription = doc.getProperties().getString("dc:description")) != null) {
                Element description = document.createElement("description");
                description.setTextContent(Formater.formatDescription(doc, false));
                item.appendChild(description);
            }
            if ((map = doc.getProperties().getMap("ttc:vignette")) != null && map.getString("data") != null) {
                String length;
                Element enclosure = document.createElement("enclosure");
                String baseUrl = "http://" + request.getServerName() + ":" + request.getServerPort();
                enclosure.setAttribute("url", baseUrl + ctx.createFileLink(doc, "ttc:vignette"));
                String mimeType = map.getString("mime-type");
                if (mimeType != null) {
                    enclosure.setAttribute("type", mimeType);
                }
                if ((length = map.getString("length")) != null) {
                    enclosure.setAttribute("length", length);
                }
                item.appendChild(enclosure);
            }
            channel.appendChild(item);
        }
        root.appendChild(channel);
        document.appendChild(root);
        return document;
    }
}

