/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.customizer.internationalization;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;

public class InternationalizationCustomizer
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "cms-nuxeo-web.customizer.internationalization";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private static final String RESOURCE_BUNDLE_NAME = "Resource";
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();
    private ICustomizationModulesRepository repository;

    private final CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.internationalization.id"));
        metadatas.setOrder(1000);
        return metadatas;
    }

    public void init() throws PortletException {
        super.init();
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        Map attributes = context.getAttributes();
        String key = (String)attributes.get("osivia.customizer.internationalization.key");
        Locale locale = (Locale)attributes.get("osivia.customizer.internationalization.locale");
        if (StringUtils.isNotBlank((String)key) && locale != null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale);
                String result = resourceBundle.getString(key);
                attributes.put("osivia.customizer.internationalization.result", result);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }
}

