/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class InternalPictureCommand
implements INuxeoCommand {
    Document containerDoc;
    String pictureIndex;

    public InternalPictureCommand(Document containerDoc, String pictureIndex) {
        this.containerDoc = containerDoc;
        this.pictureIndex = pictureIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws Exception {
        Blob blob = null;
        try {
            blob = (Blob)session.newRequest("Blob.Get").setInput((OperationInput)this.containerDoc).set("xpath", (Object)("ttc:images/item[" + this.pictureIndex + "]/file")).execute();
        }
        catch (Exception e) {
            throw new NuxeoException(NuxeoException.ERROR_NOTFOUND);
        }
        InputStream in = blob.getStream();
        File tempFile = File.createTempFile("tempFile4", ".tmp");
        CountingOutputStream cout = new CountingOutputStream((OutputStream)new FileOutputStream(tempFile));
        try {
            byte[] b = new byte[4096];
            int i = -1;
            while ((i = in.read(b)) != -1) {
                cout.write(b, 0, i);
            }
            cout.flush();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)cout);
        }
        CMSBinaryContent content = new CMSBinaryContent();
        content.setName(blob.getFileName());
        content.setFile(tempFile);
        content.setMimeType(blob.getMimeType());
        content.setFileSize(Long.valueOf(cout.getByteCount()));
        content.setFileSize(Long.valueOf(cout.getByteCount()));
        return content;
    }

    public String getId() {
        return "InternalPictureCommand" + this.containerDoc + "/" + this.pictureIndex;
    }
}

