/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.selectors;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.portlets.selectors.VocabularySelect2Portlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class VocabularySelect2Portlet
extends CMSPortlet {
    private static final String LABEL_WINDOW_PROPERTY = "osivia.selector.label";
    private static final String ID_WINDOW_PROPERTY = "osivia.selector.id";
    private static final String VOCABULARY_WINDOW_PROPERTY = "osivia.selector.vocabulary";
    private static final String MONO_VALUED_WINDOW_PROPERTY = "osivia.selector.monoValued";
    private static final String VIEW_PATH = "/WEB-INF/jsp/selectors/select2/view.jsp";
    private static final String ADMIN_PATH = "/WEB-INF/jsp/selectors/select2/admin.jsp";

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Map selectors;
        List selector;
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Configuration configuration = this.getConfiguration(window);
        request.setAttribute("configuration", (Object)configuration);
        if (configuration.getId() != null && configuration.getVocabulary() != null && (selector = (List)(selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"))).get(configuration.getId())) != null) {
            LinkedHashMap<String, String> selectedItems = new LinkedHashMap<String, String>(selector.size());
            request.setAttribute("selectedItems", selectedItems);
            for (String key : selector) {
                String vocabularyKey = key.contains("/") ? StringUtils.substringAfterLast((String)key, (String)"/") : key;
                String value = VocabularyHelper.getVocabularyLabel((NuxeoController)nuxeoController, (String)configuration.getVocabulary(), (String)vocabularyKey);
                selectedItems.put(key, value);
            }
        }
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/select2/view.jsp");
        dispatcher.include(request, response);
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Configuration configuration = this.getConfiguration(window);
        request.setAttribute("configuration", (Object)configuration);
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/select2/admin.jsp");
        dispatcher.include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        Configuration configuration = this.getConfiguration(window);
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            if ("save".equals(action) && configuration.getId() != null && configuration.getVocabulary() != null) {
                String[] values;
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                ArrayList<String> selector = (ArrayList<String>)selectors.get(configuration.getId());
                if (selector == null) {
                    selector = new ArrayList<String>();
                    selectors.put(configuration.getId(), selector);
                } else {
                    selector.clear();
                }
                if (request.getParameter("clear") == null && (values = request.getParameterValues("vocabulary")) != null) {
                    for (String value : values) {
                        selector.add(value);
                    }
                }
                response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                request.setAttribute("osivia.unsetMaxMode", (Object)String.valueOf(true));
            }
        } else if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                window.setProperty("osivia.selector.label", StringUtils.trimToNull((String)request.getParameter("label")));
                window.setProperty("osivia.selector.id", StringUtils.trimToNull((String)request.getParameter("id")));
                window.setProperty("osivia.selector.vocabulary", StringUtils.trimToNull((String)request.getParameter("vocabulary")));
                window.setProperty("osivia.selector.monoValued", String.valueOf(BooleanUtils.toBoolean((String)request.getParameter("monoValued"))));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        if ("load".equals(request.getResourceID())) {
            LoadVocabularyCommand command;
            Object object;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            nuxeoController.setCacheTimeOut(TimeUnit.HOURS.toMillis(1L));
            nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
            nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            Configuration configuration = this.getConfiguration(window);
            String filter = request.getParameter("filter");
            JSONArray results = null;
            if (configuration.getVocabulary() != null && (object = nuxeoController.executeNuxeoCommand((INuxeoCommand)(command = new LoadVocabularyCommand(this, configuration.getVocabulary())))) instanceof Blob) {
                Blob blob = (Blob)object;
                String content = IOUtils.toString((InputStream)blob.getStream(), (String)"UTF-8");
                JSONArray array = JSONArray.fromObject((Object)content);
                results = this.parse(array, filter);
            }
            if (results == null) {
                results = new JSONArray();
            }
            response.setContentType("application/json");
            PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
            printWriter.write(results.toString());
            printWriter.close();
        } else {
            super.serveResource(request, response);
        }
    }

    private Configuration getConfiguration(PortalWindow window) {
        Configuration configuration = new Configuration(this);
        configuration.setLabel(window.getProperty("osivia.selector.label"));
        configuration.setId(window.getProperty("osivia.selector.id"));
        configuration.setVocabulary(window.getProperty("osivia.selector.vocabulary"));
        configuration.setMonoValued(BooleanUtils.isNotFalse((Boolean)BooleanUtils.toBooleanObject((String)window.getProperty("osivia.selector.monoValued"))));
        return configuration;
    }

    private JSONArray parse(JSONArray array, String filter) throws IOException {
        HashMap<String, Item> items = new HashMap<String, Item>(array.size());
        LinkedHashSet<String> rootItems = new LinkedHashSet<String>();
        boolean multilevel = false;
        for (JSONObject object : array) {
            String key = object.getString("key");
            String value = object.getString("value");
            String parent = null;
            if (object.containsKey((Object)"parent")) {
                parent = object.getString("parent");
            }
            boolean matches = this.matches(value, filter);
            Item item = (Item)items.get(key);
            if (item == null) {
                item = new Item(this, key);
                items.put(key, item);
            }
            Item.access$002((Item)item, (String)value);
            Item.access$102((Item)item, (String)parent);
            if (matches) {
                Item.access$202((Item)item, (boolean)true);
                Item.access$302((Item)item, (boolean)true);
            }
            if (StringUtils.isEmpty((String)parent)) {
                rootItems.add(key);
                continue;
            }
            multilevel = true;
            Item parentItem = (Item)items.get(parent);
            if (parentItem == null) {
                parentItem = new Item(this, parent);
                items.put(parent, parentItem);
            }
            Item.access$400((Item)parentItem).add(key);
            if (!Item.access$300((Item)item)) continue;
            while (parentItem != null) {
                Item.access$302((Item)parentItem, (boolean)true);
                if (StringUtils.isEmpty((String)Item.access$100((Item)parentItem))) {
                    parentItem = null;
                    continue;
                }
                parentItem = (Item)items.get(Item.access$100((Item)parentItem));
            }
        }
        JSONArray results = new JSONArray();
        this.generateChildren(items, results, rootItems, multilevel, 1, null);
        return results;
    }

    private boolean matches(String value, String filter) throws UnsupportedEncodingException {
        boolean matches = true;
        if (filter != null) {
            String[] splittedFilters;
            String decodedValue = URLDecoder.decode(value, "UTF-8");
            String diacriticalValue = Normalizer.normalize(decodedValue, Normalizer.Form.NFD).replaceAll("\\p{IsM}+", "");
            for (String splittedFilter : splittedFilters = StringUtils.split((String)filter, (String)"*")) {
                String diacriticalFilter = Normalizer.normalize(splittedFilter, Normalizer.Form.NFD).replaceAll("\\p{IsM}+", "");
                if (StringUtils.containsIgnoreCase((String)diacriticalValue, (String)diacriticalFilter)) continue;
                matches = false;
                break;
            }
        }
        return matches;
    }

    private void generateChildren(Map<String, Item> items, JSONArray array, Set<String> children, boolean optgroup, int level, String parentId) throws UnsupportedEncodingException {
        for (String child : children) {
            Item item = items.get(child);
            if (item == null || !Item.access$300((Item)item)) continue;
            String id = parentId == null ? Item.access$500((Item)item) : parentId + "/" + Item.access$500((Item)item);
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)id);
            object.put((Object)"text", (Object)URLDecoder.decode(Item.access$000((Item)item), "UTF-8"));
            object.put((Object)"optgroup", (Object)optgroup);
            object.put((Object)"level", (Object)level);
            if (!Item.access$200((Item)item)) {
                object.put((Object)"disabled", (Object)true);
            }
            array.add((Object)object);
            if (Item.access$400((Item)item).isEmpty()) continue;
            this.generateChildren(items, array, Item.access$400((Item)item), false, level + 1, id);
        }
    }
}

