/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.comments;

import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import java.text.DateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;

public class CommentsFormatter {
    private final List<CommentDTO> comments;

    public CommentsFormatter(List<CommentDTO> comments) {
        this.comments = comments;
    }

    public String generateHTMLContent(Locale locale) {
        Element root = this.generateRootNode();
        for (CommentDTO comment : this.comments) {
            Element commentNode = this.generateCommentNode(comment, locale);
            root.add(commentNode);
        }
        return root.asXML();
    }

    protected Element generateRootNode() {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), "comments");
        return node;
    }

    protected Element generateCommentNode(CommentDTO comment, Locale locale) {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), "comment");
        if (comment.getPerson() != null) {
            DOMElement avatarImg = new DOMElement(QName.get((String)"img"));
            avatarImg.addAttribute(QName.get((String)"src"), comment.getPerson().getAvatar().getUrl());
            avatarImg.addAttribute(QName.get((String)"alt"), "avatar");
            avatarImg.addAttribute(QName.get((String)"class"), "avatar");
            node.add((Element)avatarImg);
            Element author = this.generateCommentAttribute("author", comment.getPerson().getDisplayName());
            node.add(author);
        } else {
            Element author = this.generateCommentAttribute("author", comment.getAuthor());
            node.add(author);
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3, locale);
        Element creationDate = this.generateCommentAttribute("creation-date", dateFormat.format(comment.getCreationDate()));
        node.add(creationDate);
        Element content = this.generateCommentAttribute("content", comment.getContent());
        node.add(content);
        Element actions = this.generateCommentActions(comment);
        node.add(actions);
        if (CollectionUtils.isNotEmpty((Collection)comment.getChildren())) {
            Element children = this.generateChildrenNode(comment, locale);
            node.add(children);
        }
        return node;
    }

    protected Element generateCommentAttribute(String name, String value) {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), name);
        node.setText(value);
        return node;
    }

    protected Element generateCommentActions(CommentDTO comment) {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), "actions");
        return node;
    }

    protected Element generateChildrenNode(CommentDTO comment, Locale locale) {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), "children");
        for (CommentDTO child : comment.getChildren()) {
            Element childNode = this.generateCommentNode(child, locale);
            node.add(childNode);
        }
        return node;
    }
}

