/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.files;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class BulkFilesCommand
implements INuxeoCommand {
    private static final Pattern DEDUPED_BASENAME_PATTERN = Pattern.compile("^(.*__)(\\d{1,3})(\\.?.*)$");
    private static final String FILE_FIELD_NAME = "file:content";
    private static final String SIZE_FIELD = "common:size";
    private static final String DEFAULT_FILENAME = "export.zip";
    private static final String ZIP_MIMETYPE = "application/zip";
    private static final long MAX_SIZE = 100000000L;
    private String[] paths;
    private NuxeoController nuxeoController;

    public BulkFilesCommand(NuxeoController nuxeoController, String[] paths) {
        this.nuxeoController = nuxeoController;
        this.paths = paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session nuxeoSession) throws Exception {
        long sizeSum = 0L;
        for (String path : this.paths) {
            NuxeoDocumentContext documentContext = this.nuxeoController.getDocumentContext(path);
            Long fileSize = documentContext.getDocument().getLong(SIZE_FIELD);
            if (fileSize == null) {
                throw new NuxeoException(2);
            }
            if ((sizeSum += fileSize.longValue()) <= 100000000L) continue;
            throw new NuxeoException(1);
        }
        this.nuxeoController.setStreamingSupport(true);
        ArrayList<CMSBinaryContent> contents = new ArrayList<CMSBinaryContent>(this.paths.length);
        for (String path : this.paths) {
            CMSBinaryContent content = this.nuxeoController.fetchFileContent(path, FILE_FIELD_NAME);
            contents.add(content);
        }
        File tempFile = File.createTempFile("tempFile", ".tmp");
        tempFile.deleteOnExit();
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(tempFile));
        zout.setMethod(0);
        zout.setLevel(0);
        CountingOutputStream cout = new CountingOutputStream((OutputStream)zout);
        HashSet fileNames = new HashSet();
        try {
            for (CMSBinaryContent cmsBinaryContent : contents) {
                CheckedInputStream ckin;
                if (cmsBinaryContent.getFile() == null && cmsBinaryContent.getStream() == null) continue;
                String filename = this.deduplicateFileName(fileNames, cmsBinaryContent.getName());
                ZipEntry zipEntry = new ZipEntry(filename);
                zipEntry.setSize(cmsBinaryContent.getFileSize());
                zipEntry.setCompressedSize(-1L);
                byte[] b = new byte[1000000];
                if (cmsBinaryContent.getFile() != null) {
                    ckin = new CheckedInputStream(new FileInputStream(cmsBinaryContent.getFile()), new CRC32());
                    zipEntry.setTime(cmsBinaryContent.getFile().lastModified());
                    try {
                        while (ckin.read(b) >= 0) {
                        }
                        zipEntry.setCrc(ckin.getChecksum().getValue());
                        zout.putNextEntry(zipEntry);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)ckin);
                    }
                    FileInputStream in = new FileInputStream(cmsBinaryContent.getFile());
                    try {
                        int i = -1;
                        while ((i = ((InputStream)in).read(b)) != -1) {
                            cout.write(b, 0, i);
                        }
                        cout.flush();
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                        continue;
                    }
                }
                ckin = new CheckedInputStream(cmsBinaryContent.getStream(), new CRC32());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    int i = -1;
                    while ((i = ckin.read(b)) != -1) {
                        baos.write(b, 0, i);
                    }
                    zipEntry.setCrc(ckin.getChecksum().getValue());
                    zout.putNextEntry(zipEntry);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)ckin);
                }
                try {
                    baos.writeTo((OutputStream)cout);
                    cout.flush();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)baos);
                }
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)cout);
        }
        CMSBinaryContent content = new CMSBinaryContent();
        content.setName(DEFAULT_FILENAME);
        content.setFile(tempFile);
        content.setMimeType(ZIP_MIMETYPE);
        content.setFileSize(Long.valueOf(cout.getByteCount()));
        return content;
    }

    private String deduplicateFileName(HashSet<String> fileNames, String fileName) {
        if (fileNames.contains(fileName)) {
            while (fileNames.contains(fileName)) {
                Matcher dedupeMatcher = DEDUPED_BASENAME_PATTERN.matcher(fileName);
                StringBuilder fileNameBuilder = new StringBuilder();
                if (dedupeMatcher.matches()) {
                    fileNameBuilder.append(dedupeMatcher.group(1));
                    Integer increment = Integer.valueOf(dedupeMatcher.group(2)) + 1;
                    fileNameBuilder.append(increment);
                    fileNameBuilder.append(dedupeMatcher.group(3));
                } else {
                    String[] splitedFileName = StringUtils.split((String)fileName, (char)'.');
                    for (int i = 0; i < splitedFileName.length; ++i) {
                        if (i == splitedFileName.length - 1) {
                            fileNameBuilder.append("__");
                            fileNameBuilder.append("1");
                            fileNameBuilder.append(".");
                        }
                        fileNameBuilder.append(splitedFileName[i]);
                    }
                }
                fileName = fileNameBuilder.toString();
            }
        }
        fileNames.add(fileName);
        return fileName;
    }

    public String getId() {
        return "BulkFilesCommand/" + StringUtils.join((Object[])this.paths, (char)',');
    }
}

