/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.MapUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.osivia.portal.api.portlet.model.UploadedFile;

public class BlobsProcedureCommand
implements INuxeoCommand {
    private static final String FILES_PROPERTY = "files:files";
    private final Map<String, UploadedFile> uploadedFiles;
    private final DocRef docRef;

    public BlobsProcedureCommand(Map<String, UploadedFile> uploadedFiles, DocRef docRef) {
        this.uploadedFiles = uploadedFiles;
        this.docRef = docRef;
    }

    public String getId() {
        return null;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        if (MapUtils.isNotEmpty((Map)this.uploadedFiles)) {
            DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
            ArrayList<FileBlob> blobs = new ArrayList<FileBlob>(this.uploadedFiles.size());
            TreeSet removedIndexes = new TreeSet(Collections.reverseOrder());
            for (UploadedFile uploadedFile : this.uploadedFiles.values()) {
                File temporaryFile = uploadedFile.getTemporaryFile();
                if (uploadedFile.getIndex() != null && (uploadedFile.isDeleted() || temporaryFile != null)) {
                    removedIndexes.add(uploadedFile.getIndex());
                }
                if (temporaryFile == null) continue;
                String fileName = uploadedFile.getTemporaryMetadata().getFileName();
                String mimeType = uploadedFile.getTemporaryMetadata().getMimeType() == null ? null : uploadedFile.getTemporaryMetadata().getMimeType().getBaseType();
                FileBlob blob = new FileBlob(temporaryFile, fileName, mimeType);
                blobs.add(blob);
            }
            for (Integer index : removedIndexes) {
                StringBuilder xpath = new StringBuilder();
                xpath.append(FILES_PROPERTY);
                xpath.append("/item[");
                xpath.append(index);
                xpath.append("]");
                documentService.removeBlob(this.docRef, xpath.toString());
            }
            if (!blobs.isEmpty()) {
                documentService.setBlobs(this.docRef, new Blobs(blobs), FILES_PROPERTY);
            }
            for (UploadedFile uploadedFile : this.uploadedFiles.values()) {
                if (uploadedFile.getTemporaryFile() == null) continue;
                uploadedFile.getTemporaryFile().delete();
            }
        }
        return null;
    }
}

