/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class ViewFragmentPortlet
extends CMSPortlet {
    public static final String FRAGMENT_TYPE_ID_WINDOW_PROPERTY = "osivia.fragmentTypeId";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/fragment/admin.jsp";
    private static final String PATH_VIEW = "/WEB-INF/jsp/fragment/view.jsp";
    private INuxeoCustomizer customizer;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
        this.customizer = nuxeoService.getCMSCustomizer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        IFragmentModule module;
        FragmentType fragmentType;
        String fragmentTypeId;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("select".equals(action)) {
                fragmentTypeId = request.getParameter("fragmentTypeId");
                response.setRenderParameter("fragmentTypeId", fragmentTypeId);
            } else if ("save".equals(action)) {
                fragmentTypeId = StringUtils.trimToNull((String)request.getParameter("fragmentTypeId"));
                window.setProperty(FRAGMENT_TYPE_ID_WINDOW_PROPERTY, fragmentTypeId);
                response.setPortletMode(PortletMode.VIEW);
                response.setWindowState(WindowState.NORMAL);
            }
        }
        if ((fragmentTypeId = window.getProperty(FRAGMENT_TYPE_ID_WINDOW_PROPERTY)) != null && (fragmentType = (FragmentType)this.customizer.getFragmentTypes(Locale.getDefault()).get(fragmentTypeId)) != null && (module = fragmentType.getModule()) != null) {
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(module.getClassLoader());
            try {
                module.processAction(portalControllerContext);
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        FragmentType fragmentType;
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String fragmentTypeId = request.getParameter("fragmentTypeId");
        if (fragmentTypeId == null) {
            fragmentTypeId = window.getProperty(FRAGMENT_TYPE_ID_WINDOW_PROPERTY);
        }
        request.setAttribute("fragmentTypeId", (Object)fragmentTypeId);
        if (fragmentTypeId != null && (fragmentType = (FragmentType)this.customizer.getFragmentTypes(Locale.getDefault()).get(fragmentTypeId)) != null) {
            IFragmentModule module = fragmentType.getModule();
            if (module != null) {
                ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(module.getClassLoader());
                try {
                    module.doAdmin(portalControllerContext);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(savedClassLoader);
                }
            }
            request.setAttribute("fragmentType", (Object)fragmentType);
        }
        Collection fragmentTypes = this.customizer.getFragmentTypes(request.getLocale()).values();
        ArrayList<FragmentType> filteredFragmentTypes = new ArrayList<FragmentType>(fragmentTypes.size());
        for (FragmentType fragmentType2 : fragmentTypes) {
            if (!fragmentType2.getModule().isDisplayedInAdmin()) continue;
            filteredFragmentTypes.add(fragmentType2);
        }
        request.setAttribute("fragmentTypes", filteredFragmentTypes);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            FragmentType fragmentType;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String fragmentTypeId = window.getProperty(FRAGMENT_TYPE_ID_WINDOW_PROPERTY);
            if (StringUtils.isNotEmpty((String)fragmentTypeId) && (fragmentType = (FragmentType)this.customizer.getFragmentTypes(Locale.getDefault()).get(fragmentTypeId)) != null) {
                IFragmentModule module = fragmentType.getModule();
                if (module != null) {
                    ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(module.getClassLoader());
                    try {
                        module.doView(portalControllerContext);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(savedClassLoader);
                    }
                }
                request.setAttribute("fragmentType", (Object)fragmentType);
            }
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher(PATH_VIEW).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }
}

