/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.user;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.service.user.UpdatePreferencesCommand;
import java.util.HashMap;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpSession;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.user.UserPreferences;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class UserPreferencesDelegation {
    private static final String PREFS_SESSION_ATTRIBUTE = "osivia.user.preferences";
    private PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);

    public UserPreferences getPreferences(PortalControllerContext context) throws PortalException {
        HttpSession httpSession = context.getHttpServletRequest().getSession();
        Object attribute = httpSession.getAttribute(PREFS_SESSION_ATTRIBUTE);
        UserPreferences userPreferences = null;
        if (attribute == null || !(attribute instanceof UserPreferences)) {
            String user;
            Person person;
            if (httpSession.getAttribute("PRINCIPAL_TOKEN") != null && (person = this.personService.getPerson(user = (String)httpSession.getAttribute("PRINCIPAL_TOKEN"))) != null) {
                Object ecmProfile = this.personService.getEcmProfile(context, person);
                if (ecmProfile instanceof Document) {
                    Document profile = (Document)ecmProfile;
                    userPreferences = this.toPreferencesDto(profile);
                }
                httpSession.setAttribute(PREFS_SESSION_ATTRIBUTE, (Object)userPreferences);
            }
        } else {
            userPreferences = (UserPreferences)attribute;
        }
        return userPreferences;
    }

    public void updateUserPreferences(CMSServiceCtx cmsContext, HttpSession httpSession) {
        UserPreferences userPreferences;
        Object attribute = httpSession.getAttribute(PREFS_SESSION_ATTRIBUTE);
        if (attribute != null && attribute instanceof UserPreferences && (userPreferences = (UserPreferences)attribute).isUpdate()) {
            PortletContext portletContext = cmsContext.getPortletCtx();
            NuxeoController nuxeoController = new NuxeoController(portletContext);
            nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
            nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            UpdatePreferencesCommand command = new UpdatePreferencesCommand(userPreferences);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        }
    }

    private UserPreferences toPreferencesDto(Document profile) {
        HashMap<String, String> prefs = new HashMap<String, String>();
        PropertyList list = profile.getProperties().getList("ttc_userprofile:folders_prefs");
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                PropertyMap map = list.getMap(i);
                Object objectValue = map.get("display_style");
                Object objectId = map.get("webid");
                if (objectId == null || objectValue == null) continue;
                prefs.put(objectId.toString(), objectValue.toString());
            }
        }
        UserPreferences upf = new UserPreferences(profile.getId());
        upf.setFolderDisplays(prefs);
        return upf;
    }
}

