/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindowHelper;
import fr.toutatice.portail.cms.nuxeo.api.domain.INavigationAdapterModule;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoServiceCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandServiceFactory;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.api.services.TaskDirective;
import fr.toutatice.portail.cms.nuxeo.portlets.binaries.FetchByShareLinkCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.NuxeoDocumentContextImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.commands.DocumentFetchPublishedCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.DocumentFetchLiveCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.FetchDocumentByUUIDCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.FileContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.InternalPictureCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.PictureContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.PutInTrashDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.RequestPublishStatus;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentPublishSpaceNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentsDiscoveryService;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentsMetadataCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ExtendedDocumentInfosCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.FullLoadedNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.FullLoadedNavigationItems;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetAncestorsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetChildrenCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetTasksCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetUserSubscriptionsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ListCMSSubitemsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PublishInfosCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.ReloadNuxeoSessionCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.sharing.ResolveSharingLinkCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.statistics.StatisticsCmsServiceDelegation;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.AskSetOnLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.CancelWorkflowCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentAddComplexPropertyCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentDeleteCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentRemovePropertyCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.DocumentUpdatePropertiesCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.SetOffLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.SetOnLineCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.ValidationPublishCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cache.services.ICacheService;
import org.osivia.portal.api.cms.CMSController;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.Symlink;
import org.osivia.portal.api.cms.Symlinks;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.VirtualNavigationUtils;
import org.osivia.portal.api.cms.exception.CMSException;
import org.osivia.portal.api.cms.exception.DocumentForbiddenException;
import org.osivia.portal.api.cms.exception.DocumentNotFoundException;
import org.osivia.portal.api.cms.model.Document;
import org.osivia.portal.api.cms.service.CMSSession;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.editor.EditorModule;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.page.PageParametersEncoder;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.player.Player;
import org.osivia.portal.api.portalobject.bridge.PortalObjectUtils;
import org.osivia.portal.api.statistics.IStatisticsService;
import org.osivia.portal.api.statistics.SpaceStatistics;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItemRestriction;
import org.osivia.portal.api.taskbar.TaskbarItemType;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.tasks.TaskModule;
import org.osivia.portal.api.theming.TabGroup;
import org.osivia.portal.api.theming.TemplateAdapter;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.cms.CMSConfigurationItem;
import org.osivia.portal.core.cms.CMSEditableWindow;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.DocumentMetadata;
import org.osivia.portal.core.cms.DocumentsMetadata;
import org.osivia.portal.core.cms.DomainContextualization;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.NavigationItem;
import org.osivia.portal.core.cms.RegionInheritance;
import org.osivia.portal.core.cms.Satellite;
import org.osivia.portal.core.cms.spi.NuxeoRepository;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.profils.IProfilManager;

public class CMSService
implements ICMSService {
    private static final String EXTENDED_DOCUMENT_INFOS_ATTRIBUTE_PREFIX = "osivia.cms.extendedDocumentInfos.";
    public static final String NUXEO_REPOSITORY_NAME = "nx";
    private static final Log LOG = LogFactory.getLog(CMSService.class);
    private static final String SLASH = "/";
    private final PortletContext portletCtx;
    private final ITaskbarService taskbarService;
    private IFormsService formsService;
    private PersonService personService;
    private GroupService groupService;
    private final DocumentsDiscoveryService documentsDiscoveryService;
    private final StatisticsCmsServiceDelegation statisticsServiceDelegation;
    private INuxeoCommandService nuxeoCommandService;
    private INuxeoService nuxeoService;
    private IProfilManager profilManager;
    private ICacheService serviceCache;
    private DefaultCMSCustomizer customizer;
    private IPortalUrlFactory urlFactory;
    private IStatisticsService statisticService;

    public CMSService(PortletContext portletCtx) {
        this.portletCtx = portletCtx;
        this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
        this.statisticService = (IStatisticsService)Locator.findMBean(IStatisticsService.class, (String)"osivia:service=StatisticsService");
        this.personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        this.groupService = (GroupService)DirServiceFactory.getService(GroupService.class);
        this.documentsDiscoveryService = DocumentsDiscoveryService.getInstance((CMSService)this);
        this.statisticsServiceDelegation = new StatisticsCmsServiceDelegation();
    }

    public DefaultCMSCustomizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(DefaultCMSCustomizer customizer) {
        this.customizer = customizer;
    }

    public CMSItem createItem(CMSServiceCtx cmsCtx, String path, String displayName, org.nuxeo.ecm.automation.client.model.Document doc) throws org.osivia.portal.core.cms.CMSException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("displayName", displayName);
        properties.put("type", doc.getType());
        if (BooleanUtils.toBoolean((String)doc.getString("ttc:showInMenu"))) {
            properties.put("menuItem", "1");
        }
        String domainId = doc.getString("ttc:domainID");
        String webId = doc.getString("ttc:webid");
        if (doc.getString("ttc:selectors") != null) {
            try {
                PageParametersEncoder.decodeProperties((String)doc.getString("ttc:selectors"));
                properties.put("selectors", doc.getString("ttc:selectors"));
            }
            catch (Throwable t) {
                Locale locale = cmsCtx.getServletRequest().getLocale();
                String warnMsgselectors = this.getCustomizer().getBundleFactory().getBundle(locale).getString("WARN_MSG_TTC_SELECTORS");
                LOG.warn((Object)warnMsgselectors, t);
            }
        }
        CMSItem cmsItem = new CMSItem(path, domainId, webId, properties, (Object)doc);
        cmsItem.setCmsPath(doc.getPath());
        DocumentType type = (DocumentType)this.customizer.getCMSItemTypes().get(doc.getType());
        cmsItem.setType(type);
        return cmsItem;
    }

    public CMSItem createItem(CMSServiceCtx cmsContext, String path, String displayName, org.nuxeo.ecm.automation.client.model.Document document, CMSPublicationInfos publicationInfos) throws org.osivia.portal.core.cms.CMSException {
        CMSItem cmsItem = this.createItem(cmsContext, path, displayName, document);
        if (publicationInfos != null) {
            cmsItem.setPublished(Boolean.valueOf(publicationInfos.isPublished()));
            cmsItem.setBeingModified(Boolean.valueOf(publicationInfos.isBeingModified()));
        }
        return cmsItem;
    }

    public CMSItem createNavigationItem(CMSServiceCtx cmsCtx, String path, String displayName, org.nuxeo.ecm.automation.client.model.Document document, String publishSpacePath) throws org.osivia.portal.core.cms.CMSException {
        CMSItem cmsItem = this.createItem(cmsCtx, path, displayName, document);
        CMSItem publishSpaceItem = null;
        publishSpaceItem = publishSpacePath != null && !path.equals(publishSpacePath) ? this.getPortalNavigationItem(cmsCtx, publishSpacePath, publishSpacePath) : cmsItem;
        this.getCustomizer().getNavigationItemAdapter().adaptPublishSpaceNavigationItem(cmsItem, publishSpaceItem);
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        List navigationAdapters = pluginManager.customizeNavigationAdapters();
        if (CollectionUtils.isNotEmpty((Collection)navigationAdapters)) {
            PortalControllerContext portalControllerContext = cmsCtx.getPortalControllerContext();
            for (INavigationAdapterModule navigationAdapter : navigationAdapters) {
                navigationAdapter.adaptNavigationItem(portalControllerContext, cmsItem);
            }
        }
        return cmsItem;
    }

    public IProfilManager getProfilManager() throws Exception {
        if (this.profilManager == null) {
            this.profilManager = (IProfilManager)this.portletCtx.getAttribute("ProfileService");
        }
        return this.profilManager;
    }

    public INuxeoService getNuxeoService() throws Exception {
        if (this.nuxeoService == null) {
            this.nuxeoService = (INuxeoService)this.portletCtx.getAttribute("NuxeoService");
        }
        return this.nuxeoService;
    }

    public ICacheService getCacheService() throws Exception {
        if (this.serviceCache == null) {
            this.serviceCache = (ICacheService)this.portletCtx.getAttribute("CacheService");
        }
        return this.serviceCache;
    }

    public INuxeoCommandService getNuxeoCommandService() throws Exception {
        if (this.nuxeoCommandService == null) {
            this.nuxeoCommandService = NuxeoCommandServiceFactory.getNuxeoCommandService((PortletContext)this.portletCtx);
        }
        return this.nuxeoCommandService;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        if (this.urlFactory == null) {
            this.urlFactory = (IPortalUrlFactory)this.portletCtx.getAttribute("UrlService");
        }
        return this.urlFactory;
    }

    public Object executeNuxeoCommand(CMSServiceCtx cmsCtx, INuxeoCommand command) throws Exception {
        NuxeoCommandContext commandCtx = null;
        if (cmsCtx.getPortalControllerContext() != null) {
            commandCtx = new NuxeoCommandContext(this.portletCtx, cmsCtx.getPortalControllerContext());
        }
        if (commandCtx == null) {
            commandCtx = new NuxeoCommandContext(this.portletCtx);
        }
        commandCtx.setAsyncCacheRefreshing(cmsCtx.isAsyncCacheRefreshing());
        if (cmsCtx.isForceReload()) {
            commandCtx.setForceReload(true);
        }
        String scope = cmsCtx.getScope();
        commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
        commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        if (scope != null && !"__nocache".equals(scope)) {
            if ("user_session".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_SESSION);
            } else if ("anonymous".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_ANONYMOUS);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else if ("superuser_context".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else if ("superuser_no_cache".equals(scope)) {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            } else {
                commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_PROFIL);
                commandCtx.setAuthProfil(this.getProfilManager().getProfil(scope));
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            }
        }
        commandCtx.setSatellite(cmsCtx.getSatellite());
        return this.getNuxeoCommandService().executeCommand(commandCtx, (INuxeoServiceCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSItem fetchContent(CMSServiceCtx cmsContext, String path) throws Exception {
        CMSItem cmsItem;
        String savedScope = cmsContext.getScope();
        try {
            boolean saveAsync = cmsContext.isAsyncCacheRefreshing();
            cmsContext.setAsyncCacheRefreshing(false);
            CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, path);
            path = publicationInfos.getDocumentPath();
            cmsContext.setAsyncCacheRefreshing(saveAsync);
            Satellite savedSatellite = cmsContext.getSatellite();
            try {
                org.nuxeo.ecm.automation.client.model.Document document;
                Satellite satellite = publicationInfos.getSatellite();
                cmsContext.setSatellite(satellite);
                boolean haveToGetLive = "1".equals(cmsContext.getDisplayLiveVersion());
                if (publicationInfos.getDocumentPath().equals(cmsContext.getForcedLivePath()) || publicationInfos.getLiveId().equals(cmsContext.getForcedLivePath())) {
                    haveToGetLive = true;
                }
                if (!publicationInfos.isPublished() && StringUtils.isNotEmpty((String)publicationInfos.getPublishSpacePath()) && publicationInfos.isLiveSpace()) {
                    haveToGetLive = true;
                }
                if (!publicationInfos.isPublished() && publicationInfos.getPublishSpacePath() == null) {
                    haveToGetLive = true;
                }
                if (haveToGetLive && Satellite.MAIN.equals((Object)satellite) && !path.startsWith("/task-root/")) {
                    document = this.fetchContentByConnect(cmsContext, path);
                } else {
                    cmsContext.setScope("superuser_context");
                    Object nuxeoCommand = haveToGetLive ? new DocumentFetchLiveCommand(path, "Read") : new DocumentFetchPublishedCommand(path);
                    document = (org.nuxeo.ecm.automation.client.model.Document)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)nuxeoCommand);
                }
                cmsItem = this.createItem(cmsContext, path, document.getTitle(), document, publicationInfos);
            }
            finally {
                cmsContext.setSatellite(savedSatellite);
            }
        }
        finally {
            cmsContext.setScope(savedScope);
        }
        return cmsItem;
    }

    private org.nuxeo.ecm.automation.client.model.Document fetchContentByConnect(CMSServiceCtx cmsContext, String path) throws Exception {
        CMSController ctrl = this.getConnectController(cmsContext);
        NuxeoRepository nuxeoRepository = (NuxeoRepository)((org.osivia.portal.api.cms.service.CMSService)Locator.getService(org.osivia.portal.api.cms.service.CMSService.class)).getUserRepository(ctrl.getCMSContext(), NUXEO_REPOSITORY_NAME);
        String internalId = nuxeoRepository.getInternalId(path);
        CMSSession session = ((org.osivia.portal.api.cms.service.CMSService)Locator.getService(org.osivia.portal.api.cms.service.CMSService.class)).getCMSSession(ctrl.getCMSContext());
        if (cmsContext.isForceReload()) {
            session.reload(new UniversalID(NUXEO_REPOSITORY_NAME, internalId));
        }
        Document document = session.getDocument(new UniversalID(NUXEO_REPOSITORY_NAME, internalId));
        return (org.nuxeo.ecm.automation.client.model.Document)document.getNativeItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSItem getContent(CMSServiceCtx cmsContext, String path) throws org.osivia.portal.core.cms.CMSException {
        CMSItem content;
        block9: {
            content = null;
            try {
                content = this.fetchContent(cmsContext, path);
                DocumentType type = content.getType();
                if (type != null && type.isForceContextualization()) {
                    content.getProperties().put("supportsOnlyPortalContextualization", "1");
                }
                if (!BooleanUtils.toBoolean((String)System.getProperty("osivia.services.userWorkSpace.adaptDocumentFolder")) || cmsContext.getPortalControllerContext().getHttpServletRequest() == null || cmsContext.getPortalControllerContext().getHttpServletRequest().getAttribute("osivia.controllerContext") == null || content == null || !(content.getNativeItem() instanceof org.nuxeo.ecm.automation.client.model.Document)) break block9;
                org.nuxeo.ecm.automation.client.model.Document doc = (org.nuxeo.ecm.automation.client.model.Document)content.getNativeItem();
                if (content.getType() == null || !"Folder".equals(content.getType().getName()) || !StringUtils.endsWith((String)content.getCmsPath(), (String)"/documents") || BooleanUtils.toBoolean((String)doc.getProperties().getString("ttc:adaptedContent"))) break block9;
                try {
                    CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
                    List navigationAdapters = pluginManager.customizeNavigationAdapters();
                    PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
                    for (INavigationAdapterModule navigationAdapter : navigationAdapters) {
                        navigationAdapter.adaptNavigationItem(portalControllerContext, content);
                    }
                }
                finally {
                    doc.set("ttc:adaptedContent", "true");
                }
            }
            catch (NuxeoException e) {
                e.rethrowCMSException();
            }
            catch (org.osivia.portal.core.cms.CMSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
        }
        return content;
    }

    public CMSItem getByShareId(CMSServiceCtx cmsContext, String shareId, boolean enabledLinkOnly) throws org.osivia.portal.core.cms.CMSException {
        CMSItem content = null;
        String savedScope = cmsContext.getScope();
        boolean ignoreError = false;
        try {
            cmsContext.setScope("superuser_no_cache");
            Documents docs = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)new FetchByShareLinkCommand(shareId, enabledLinkOnly));
            if (docs.size() > 1) {
                LOG.error((Object)(docs.size() + " documents whith share Id : " + shareId));
                if (docs.size() == 2) {
                    try {
                        LOG.info((Object)("deactivate link for " + docs.get(1).getPath()));
                        ArrayList<String> propertiesToRemove = new ArrayList<String>();
                        propertiesToRemove.add("rshr:linkId");
                        propertiesToRemove.add("rshr:enabledLink");
                        this.executeNuxeoCommand(cmsContext, (INuxeoCommand)new DocumentRemovePropertyCommand(docs.get(1), propertiesToRemove));
                        ignoreError = true;
                    }
                    catch (Exception e) {
                        throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
                    }
                }
            }
            if (docs.size() != 1 && !ignoreError) {
                throw new NuxeoException(3);
            }
            content = new CMSItem(docs.get(0).getPath(), null, null, null, (Object)docs.get(0));
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        finally {
            cmsContext.setScope(savedScope);
        }
        return content;
    }

    public CMSBinaryContent getBinaryContent(CMSServiceCtx cmsCtx, String type, String docPath, String parameter) throws org.osivia.portal.core.cms.CMSException {
        CMSBinaryContent content = new CMSBinaryContent();
        if ("file".equals(type)) {
            content = this.getFileContent(cmsCtx, docPath, parameter);
        } else if ("attachedPicture".equals(type)) {
            content = this.getAttachedPicture(cmsCtx, docPath, parameter);
        } else if ("picture".equals(type)) {
            content = this.getPicture(cmsCtx, docPath, parameter);
        }
        return content;
    }

    public CMSBinaryContent getAttachedPicture(CMSServiceCtx cmsCtx, String docPath, String pictureIndex) throws org.osivia.portal.core.cms.CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchAttachedPicture(cmsCtx, docPath, pictureIndex);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
        return cmsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSBinaryContent fetchAttachedPicture(CMSServiceCtx cmsCtx, String docPath, String pictureIndex) throws Exception {
        CMSBinaryContent pictureContent;
        block6: {
            pictureContent = null;
            String savedScope = cmsCtx.getScope();
            try {
                CMSItem containerDoc = this.fetchContent(cmsCtx, docPath);
                if (containerDoc == null) break block6;
                Satellite savedSatellite = this.setSatelliteInContext(cmsCtx, docPath);
                try {
                    cmsCtx.setScope("superuser_context");
                    pictureContent = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new InternalPictureCommand((org.nuxeo.ecm.automation.client.model.Document)containerDoc.getNativeItem(), pictureIndex));
                }
                finally {
                    this.restoreSatelliteInContext(cmsCtx, savedSatellite);
                }
            }
            finally {
                cmsCtx.setScope(savedScope);
            }
        }
        return pictureContent;
    }

    public CMSBinaryContent getPicture(CMSServiceCtx cmsCtx, String docPath, String content) throws org.osivia.portal.core.cms.CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchPicture(cmsCtx, docPath, content);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
        return cmsContent;
    }

    private CMSBinaryContent fetchPicture(CMSServiceCtx cmsCtx, String docPath, String content) throws Exception {
        CMSBinaryContent pictureContent = null;
        String savedScope = cmsCtx.getScope();
        String savedPubInfosScope = cmsCtx.getForcePublicationInfosScope();
        try {
            cmsCtx.setForcePublicationInfosScope("superuser_context");
            CMSPublicationInfos publiInfos = this.getPublicationInfos(cmsCtx, docPath);
            cmsCtx.setForcePublicationInfosScope(null);
            if (publiInfos.isAnonymouslyReadable()) {
                cmsCtx.setForcePublicationInfosScope("anonymous");
            }
            CMSItem picture = this.fetchContent(cmsCtx, publiInfos.getDocumentPath());
            cmsCtx.setScope("superuser_context");
            pictureContent = (CMSBinaryContent)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PictureContentCommand((org.nuxeo.ecm.automation.client.model.Document)picture.getNativeItem(), content));
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == 3) {
                    CMSBinaryContent cMSBinaryContent = null;
                    return cMSBinaryContent;
                }
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
            cmsCtx.setForcePublicationInfosScope(savedPubInfosScope);
        }
        return pictureContent;
    }

    public CMSBinaryContent getFileContent(CMSServiceCtx cmsCtx, String docPath, String fieldName) throws org.osivia.portal.core.cms.CMSException {
        CMSBinaryContent cmsContent = null;
        try {
            cmsContent = this.fetchFileContent(cmsCtx, docPath, fieldName);
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
        return cmsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSBinaryContent fetchFileContent(CMSServiceCtx cmsContext, String path, String fieldName) throws Exception {
        CMSBinaryContent content;
        block12: {
            String savedScope = cmsContext.getScope();
            if (StringUtils.isNotEmpty((String)savedScope)) {
                cmsContext.setForcePublicationInfosScope(savedScope);
            }
            try {
                org.nuxeo.ecm.automation.client.model.Document nuxeoDocument = null;
                if (!"downloadVersion".equals(cmsContext.getDisplayContext())) {
                    CMSItem document = this.fetchContent(cmsContext, path);
                    if (document != null) {
                        nuxeoDocument = (org.nuxeo.ecm.automation.client.model.Document)document.getNativeItem();
                    }
                } else {
                    FetchDocumentByUUIDCommand fetchVersion = new FetchDocumentByUUIDCommand(path);
                    cmsContext.setScope("superuser_context");
                    nuxeoDocument = (org.nuxeo.ecm.automation.client.model.Document)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)fetchVersion);
                }
                if (nuxeoDocument != null) {
                    Satellite savedSatellite = this.setSatelliteInContext(cmsContext, path);
                    try {
                        Long length;
                        PropertyMap map;
                        FileContentCommand command = new FileContentCommand(nuxeoDocument, fieldName);
                        cmsContext.setScope("superuser_context");
                        if (cmsContext.isStreamingSupport() && (map = FileContentCommand.getFileMap((org.nuxeo.ecm.automation.client.model.Document)nuxeoDocument, (String)fieldName)) != null && (length = map.getLong("length")) != null && length > 102400L) {
                            command.setStreamingSupport(true);
                            cmsContext.setScope("superuser_no_cache");
                        }
                        content = (CMSBinaryContent)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
                        break block12;
                    }
                    finally {
                        this.restoreSatelliteInContext(cmsContext, savedSatellite);
                    }
                }
                content = null;
            }
            finally {
                cmsContext.setScope(savedScope);
            }
        }
        return content;
    }

    private Satellite setSatelliteInContext(CMSServiceCtx cmsContext, String path) throws org.osivia.portal.core.cms.CMSException {
        CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, path);
        Satellite savedSatellite = cmsContext.getSatellite();
        Satellite satellite = publicationInfos.getSatellite();
        cmsContext.setSatellite(satellite);
        return savedSatellite;
    }

    private void restoreSatelliteInContext(CMSServiceCtx cmsContext, Satellite oldSatellite) {
        cmsContext.setSatellite(oldSatellite);
    }

    public boolean checkContentAnonymousAccess(CMSServiceCtx cmsCtx, String path) throws org.osivia.portal.core.cms.CMSException {
        try {
            CMSPublicationInfos pubInfos = this.getPublicationInfos(cmsCtx, path);
            return pubInfos.isAnonymouslyReadable();
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
        return false;
    }

    public Player getItemHandler(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        Player player;
        try {
            player = !"detailedView".equals(cmsContext.getDisplayContext()) ? this.customizer.getCMSPlayer(cmsContext) : this.customizer.getCMSDefaultPlayer(cmsContext);
            PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
            this.statisticService.incrementsUserStatistics(portalControllerContext, ((org.nuxeo.ecm.automation.client.model.Document)cmsContext.getDoc()).getPath());
        }
        catch (NuxeoException e) {
            player = null;
            e.rethrowCMSException();
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        return player;
    }

    public CMSItem getPortalNavigationItem(CMSServiceCtx cmsCtx, String publishSpacePath, String path) throws org.osivia.portal.core.cms.CMSException {
        String savedScope = cmsCtx.getScope();
        if (cmsCtx.getScope() == null || "__nocache".equals(cmsCtx.getScope())) {
            cmsCtx.setScope("user_session");
        }
        try {
            NavigationItem navItem;
            CustomizationPluginMgr pluginManager;
            List navigationAdapters;
            DocumentPublishSpaceNavigationCommand command;
            String livePath = DocumentHelper.computeNavPath((String)path);
            CMSItem publishSpaceConfig = this.getSpaceConfig(cmsCtx, publishSpacePath);
            if (publishSpaceConfig == null) {
                throw new org.osivia.portal.core.cms.CMSException(3);
            }
            Map navItems = null;
            boolean forceLiveVersion = false;
            if ("1".equals(cmsCtx.getDisplayLiveVersion()) || "1".equals(publishSpaceConfig.getProperties().get("displayLiveVersion"))) {
                forceLiveVersion = true;
            }
            if ((navItems = (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)(command = new DocumentPublishSpaceNavigationCommand(cmsCtx, publishSpaceConfig, forceLiveVersion, navigationAdapters = (pluginManager = this.customizer.getPluginManager()).customizeNavigationAdapters())))) != null && (navItem = (NavigationItem)navItems.get(livePath)) != null) {
                CMSItem item = navItem.getAdaptedCMSItem();
                if (item == null) {
                    if (navItem.getMainDoc() != null) {
                        navItem.setAdaptedCMSItem(this.createNavigationItem(cmsCtx, livePath, ((org.nuxeo.ecm.automation.client.model.Document)navItem.getMainDoc()).getTitle(), (org.nuxeo.ecm.automation.client.model.Document)navItem.getMainDoc(), publishSpaceConfig.getNavigationPath()));
                    } else {
                        CMSItem cMSItem = null;
                        return cMSItem;
                    }
                }
                CMSItem cMSItem = navItem.getAdaptedCMSItem();
                return cMSItem;
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return null;
    }

    public List<CMSItem> getPortalNavigationSubitems(CMSServiceCtx cmsCtx, String publishSpacePath, String path) throws org.osivia.portal.core.cms.CMSException {
        String savedScope = cmsCtx.getScope();
        if (cmsCtx.getScope() == null || "__nocache".equals(cmsCtx.getScope())) {
            cmsCtx.setScope("user_session");
        }
        try {
            NavigationItem navItem;
            CustomizationPluginMgr pluginManager;
            List navigationAdapters;
            DocumentPublishSpaceNavigationCommand command;
            CMSItem publishSpaceConfig = this.getSpaceConfig(cmsCtx, publishSpacePath);
            if (publishSpaceConfig == null) {
                throw new org.osivia.portal.core.cms.CMSException(3);
            }
            Map navItems = null;
            boolean forceLiveVersion = false;
            if ("1".equals(cmsCtx.getDisplayLiveVersion()) || "1".equals(publishSpaceConfig.getProperties().get("displayLiveVersion"))) {
                forceLiveVersion = true;
            }
            if ((navItems = (Map)this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)(command = new DocumentPublishSpaceNavigationCommand(cmsCtx, publishSpaceConfig, forceLiveVersion, navigationAdapters = (pluginManager = this.customizer.getPluginManager()).customizeNavigationAdapters())))) != null && (navItem = (NavigationItem)navItems.get(path)) != null) {
                ArrayList<CMSItem> childrens = new ArrayList<CMSItem>();
                for (NavigationItem child : navItem.getChildren()) {
                    String childNavPath = child.getPath();
                    NavigationItem navChild = (NavigationItem)navItems.get(childNavPath);
                    CMSItem item = navChild.getAdaptedCMSItem();
                    if (item == null && navChild.getMainDoc() != null) {
                        item = this.createNavigationItem(cmsCtx, childNavPath, ((org.nuxeo.ecm.automation.client.model.Document)navChild.getMainDoc()).getTitle(), (org.nuxeo.ecm.automation.client.model.Document)navChild.getMainDoc(), publishSpacePath);
                        navChild.setAdaptedCMSItem(item);
                    }
                    if (item != null) {
                        item.getProperties().put("unfetchedChildren", BooleanUtils.toStringTrueFalse((boolean)navChild.isUnfetchedChildren()));
                    }
                    childrens.add(navChild.getAdaptedCMSItem());
                }
                ArrayList<CMSItem> arrayList = childrens;
                return arrayList;
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
        finally {
            cmsCtx.setScope(savedScope);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CMSItem> getPortalSubitems(CMSServiceCtx cmsContext, String path) throws org.osivia.portal.core.cms.CMSException {
        try {
            String parentId;
            String version = cmsContext.getDisplayLiveVersion();
            try {
                cmsContext.setDisplayLiveVersion("1");
                org.nuxeo.ecm.automation.client.model.Document parent = (org.nuxeo.ecm.automation.client.model.Document)this.fetchContent(cmsContext, path).getNativeItem();
                parentId = parent.getId();
            }
            finally {
                cmsContext.setDisplayLiveVersion(version);
            }
            RequestPublishStatus publishStatus = RequestPublishStatus.setRequestPublishStatus((String)version);
            ListCMSSubitemsCommand nuxeoCommand = new ListCMSSubitemsCommand(cmsContext, parentId, publishStatus);
            return (List)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)nuxeoCommand);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSPublicationInfos getPublicationInfos(CMSServiceCtx ctx, String path) throws org.osivia.portal.core.cms.CMSException {
        CMSPublicationInfos pubInfos = new CMSPublicationInfos();
        try {
            String savedScope = ctx.getScope();
            Satellite savedSatellite = ctx.getSatellite();
            if (savedSatellite == null) {
                Satellite satellite = this.documentsDiscoveryService.discoverLocation(path);
                ctx.setSatellite(satellite);
            }
            try {
                List errors;
                if (StringUtils.isNotEmpty((String)ctx.getForcePublicationInfosScope())) {
                    ctx.setScope(ctx.getForcePublicationInfosScope());
                } else if (ctx.getServletRequest() != null) {
                    if (ctx.getServletRequest().getRemoteUser() == null) {
                        ctx.setScope("anonymous");
                    } else {
                        ctx.setScope("user_session");
                    }
                }
                if (Satellite.MAIN.equals((Object)ctx.getSatellite()) && !"0".equals(ctx.getDisplayLiveVersion()) && !path.startsWith("/task-root/")) {
                    try {
                        pubInfos = this.getPublicationInfosByConnect(ctx, path);
                    }
                    catch (CMSException exc) {
                        if (exc instanceof DocumentNotFoundException) {
                            throw new org.osivia.portal.core.cms.CMSException(3);
                        }
                        if (exc instanceof DocumentForbiddenException) {
                            throw new org.osivia.portal.core.cms.CMSException(1);
                        }
                        if (exc.getCause() instanceof org.osivia.portal.core.cms.CMSException) {
                            throw (org.osivia.portal.core.cms.CMSException)exc.getCause();
                        }
                        throw exc;
                    }
                } else {
                    pubInfos = (CMSPublicationInfos)this.executeNuxeoCommand(ctx, (INuxeoCommand)new PublishInfosCommand(ctx.getSatellite(), path));
                }
                if (pubInfos != null && (errors = pubInfos.getErrorCodes()) != null) {
                    if (errors.contains(2)) {
                        throw new org.osivia.portal.core.cms.CMSException(1);
                    }
                    if (errors.contains(1)) {
                        throw new org.osivia.portal.core.cms.CMSException(3);
                    }
                }
            }
            finally {
                ctx.setScope(savedScope);
                ctx.setSatellite(savedSatellite);
            }
        }
        catch (NuxeoException e) {
            e.rethrowCMSException();
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        return pubInfos;
    }

    private CMSPublicationInfos getPublicationInfosByConnect(CMSServiceCtx cmsContext, String path) throws Exception {
        CMSController ctrl = this.getConnectController(cmsContext);
        NuxeoRepository nuxeoRepository = (NuxeoRepository)((org.osivia.portal.api.cms.service.CMSService)Locator.getService(org.osivia.portal.api.cms.service.CMSService.class)).getUserRepository(ctrl.getCMSContext(), NUXEO_REPOSITORY_NAME);
        String internalId = nuxeoRepository.getInternalId(path);
        CMSSession session = ((org.osivia.portal.api.cms.service.CMSService)Locator.getService(org.osivia.portal.api.cms.service.CMSService.class)).getCMSSession(ctrl.getCMSContext());
        CMSPublicationInfos pubInfos = (CMSPublicationInfos)session.getPersonnalization(new UniversalID(NUXEO_REPOSITORY_NAME, internalId));
        return pubInfos;
    }

    private CMSController getConnectController(CMSServiceCtx cmsContext) {
        boolean superUser = false;
        if ("superuser_no_cache".equals(cmsContext.getScope())) {
            superUser = true;
        }
        if ("superuser_context".equals(cmsContext.getScope())) {
            superUser = true;
        }
        CMSController ctrl = new CMSController(cmsContext.getPortalControllerContext(), superUser);
        return ctrl;
    }

    public List<CMSItem> getWorkspaces(CMSServiceCtx cmsContext, boolean userWorkspaces, boolean administrator) throws org.osivia.portal.core.cms.CMSException {
        BrowserAdapter browserAdapter = this.customizer.getBrowserAdapter();
        List workspaces = userWorkspaces ? browserAdapter.getCurrentUserWorkspaces(cmsContext) : browserAdapter.getWorkspaces(cmsContext, administrator);
        return workspaces;
    }

    public CMSItem getUserWorkspace(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        List userWorkspaces = this.getWorkspaces(cmsContext, true, false);
        CMSItem userWorkspace = userWorkspaces != null && userWorkspaces.size() == 1 ? (CMSItem)userWorkspaces.get(0) : null;
        return userWorkspace;
    }

    public Map<String, NavigationItem> getFullLoadedPortalNavigationItems(CMSServiceCtx cmsContext, String basePath) throws org.osivia.portal.core.cms.CMSException {
        LinkedHashMap navigationItems;
        boolean liveVersion = "1".equals(cmsContext.getDisplayLiveVersion());
        PortletRequest request = cmsContext.getRequest();
        if (request == null) {
            navigationItems = null;
        } else {
            String name = FullLoadedNavigationItems.getRequestAttributeName((String)basePath);
            FullLoadedNavigationItems fullLoadedNavigationItems = (FullLoadedNavigationItems)request.getAttribute(name);
            if (fullLoadedNavigationItems == null) {
                FullLoadedNavigationCommand command = new FullLoadedNavigationCommand(basePath, liveVersion);
                try {
                    Documents documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
                    navigationItems = new LinkedHashMap(documents.size());
                    for (org.nuxeo.ecm.automation.client.model.Document document : documents.list()) {
                        String path = StringUtils.removeEnd((String)document.getPath(), (String)".proxy");
                        NavigationItem navigationItem = this.getNavigationItem(navigationItems, path);
                        navigationItem.setMainDoc((Object)document);
                        navigationItem.setPath(path);
                        CMSItem cmsItem = this.createNavigationItem(cmsContext, path, document.getTitle(), document, basePath);
                        navigationItem.setAdaptedCMSItem(cmsItem);
                        PortalObjectPath objectPath = PortalObjectPath.parse((String)path, (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT);
                        PortalObjectPath parentObjectPath = objectPath.getParent();
                        String parentPath = parentObjectPath.toString(PortalObjectPath.CANONICAL_FORMAT);
                        if (!StringUtils.startsWith((String)parentPath, (String)basePath)) continue;
                        NavigationItem parentNavigationItem = this.getNavigationItem(navigationItems, parentPath);
                        parentNavigationItem.getChildren().add(navigationItem);
                    }
                    fullLoadedNavigationItems = new FullLoadedNavigationItems(basePath, navigationItems);
                    request.setAttribute(name, (Object)fullLoadedNavigationItems);
                }
                catch (NuxeoException e) {
                    navigationItems = null;
                    e.rethrowCMSException();
                }
                catch (org.osivia.portal.core.cms.CMSException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
                }
            } else {
                navigationItems = fullLoadedNavigationItems.getNavigationItems();
            }
        }
        return navigationItems;
    }

    private NavigationItem getNavigationItem(Map<String, NavigationItem> items, String path) {
        NavigationItem item = items.get(path);
        if (item == null) {
            item = new NavigationItem();
            items.put(path, item);
        }
        return item;
    }

    public ExtendedDocumentInfos getExtendedDocumentInfos(CMSServiceCtx cmsContext, String path) throws org.osivia.portal.core.cms.CMSException {
        String attributeName;
        HttpServletRequest request = cmsContext.getServletRequest();
        ExtendedDocumentInfos infos = (ExtendedDocumentInfos)request.getAttribute(attributeName = EXTENDED_DOCUMENT_INFOS_ATTRIBUTE_PREFIX + StringEscapeUtils.escapeHtml((String)path));
        if (infos == null) {
            infos = new ExtendedDocumentInfos();
            Satellite savedSatellite = cmsContext.getSatellite();
            if (savedSatellite == null) {
                Satellite satellite = this.documentsDiscoveryService.discoverLocation(path);
                cmsContext.setSatellite(satellite);
            }
            try {
                if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_60)) {
                    ExtendedDocumentInfosCommand command = new ExtendedDocumentInfosCommand(path);
                    infos = (ExtendedDocumentInfos)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
                }
            }
            catch (NuxeoException e) {
                e.rethrowCMSException();
            }
            catch (org.osivia.portal.core.cms.CMSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            finally {
                cmsContext.setSatellite(savedSatellite);
            }
            request.setAttribute(attributeName, (Object)infos);
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSItem getSpaceConfig(CMSServiceCtx cmsCtx, String publishSpacePath) throws org.osivia.portal.core.cms.CMSException {
        CMSItem configItem = null;
        HttpServletRequest portalRequest = cmsCtx.getServletRequest();
        boolean forceLiveVersion = false;
        if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
            forceLiveVersion = true;
        }
        String requestKey = "osivia.cache.spaceConfig." + publishSpacePath + "." + forceLiveVersion;
        try {
            CMSItem value = (CMSItem)portalRequest.getAttribute(requestKey);
            if (value != null) {
                if (PageProperties.getProperties().isRefreshingPage() && portalRequest.getAttribute(requestKey + ".resfreshed") == null) {
                    portalRequest.setAttribute(requestKey + ".resfreshed", (Object)"1");
                    value = null;
                }
                if (value != null) {
                    return value;
                }
            }
            String savedScope = cmsCtx.getScope();
            String savedPubInfosScope = cmsCtx.getForcePublicationInfosScope();
            try {
                cmsCtx.setForcePublicationInfosScope("superuser_context");
                configItem = this.fetchContent(cmsCtx, publishSpacePath);
                this.getCustomizer().getNavigationItemAdapter().adaptPublishSpaceNavigationItem(configItem, configItem);
                CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
                List navigationAdapters = pluginManager.customizeNavigationAdapters();
                if (CollectionUtils.isNotEmpty((Collection)navigationAdapters)) {
                    PortalControllerContext portalControllerContext = cmsCtx.getPortalControllerContext();
                    for (INavigationAdapterModule navigationAdapter : navigationAdapters) {
                        navigationAdapter.adaptNavigationItem(portalControllerContext, configItem);
                    }
                }
                portalRequest.setAttribute(requestKey, (Object)configItem);
            }
            finally {
                cmsCtx.setScope(savedScope);
                cmsCtx.setForcePublicationInfosScope(savedPubInfosScope);
            }
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (NuxeoException e) {
            if (e.getErrorCode() == 3) {
                return null;
            }
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        return configItem;
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws org.osivia.portal.core.cms.CMSException {
        try {
            return this.customizer.parseCMSURL(cmsCtx, requestPath, requestParameters);
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == 3) {
                    return null;
                }
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
    }

    public String adaptWebPathToCms(CMSServiceCtx cmsContext, String requestPath) throws org.osivia.portal.core.cms.CMSException {
        try {
            CMSPublicationInfos pubInfos = this.getPublicationInfos(cmsContext, requestPath);
            return pubInfos.getDocumentPath();
        }
        catch (NuxeoException e) {
            if (e.getErrorCode() == 3) {
                return null;
            }
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws org.osivia.portal.core.cms.CMSException {
        try {
            return this.customizer.computeUserPreloadedPages(cmsCtx);
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.core.cms.CMSException)) {
                if (e instanceof NuxeoException && ((NuxeoException)((Object)e)).getErrorCode() == 3) {
                    return null;
                }
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.core.cms.CMSException)((Object)e);
        }
    }

    public List<CMSEditableWindow> getEditableWindows(CMSServiceCtx cmsContext, String path, String publishSpacePath, String sitePath, String navigationScope, Boolean isSpaceSite) throws org.osivia.portal.core.cms.CMSException {
        ArrayList<CMSEditableWindow> windows = new ArrayList<CMSEditableWindow>();
        String workingPath = path == null ? sitePath : path;
        boolean editionMode = false;
        if ("1".equals(cmsContext.getDisplayLiveVersion())) {
            editionMode = true;
        }
        Map inheritedRegions = new HashMap();
        int windowsCount = 0;
        if (isSpaceSite.booleanValue()) {
            inheritedRegions = this.getInheritedRegions(cmsContext, workingPath, publishSpacePath, sitePath, navigationScope, editionMode);
            for (List inheritedWindows : inheritedRegions.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)inheritedWindows)) continue;
                windows.addAll(inheritedWindows);
            }
            windowsCount = windows.size();
        }
        try {
            CMSItem navigationItem = publishSpacePath == null ? null : this.getPortalNavigationItem(cmsContext, publishSpacePath, workingPath);
            if (navigationItem != null) {
                PropertyList fragments;
                org.nuxeo.ecm.automation.client.model.Document navigationDocument = (org.nuxeo.ecm.automation.client.model.Document)navigationItem.getNativeItem();
                CMSItem pageItem = this.fetchContent(cmsContext, navigationDocument.getPath());
                org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)pageItem.getNativeItem();
                if (publishSpacePath != null && (fragments = document.getProperties().getList("fgts:fragments")) != null && !fragments.isEmpty()) {
                    Map editableWindows = this.customizer.getEditableWindows((Locale)cmsContext.getServletRequest().getLocales().nextElement());
                    int regionWindowsCount = 0;
                    for (int i = 0; i < fragments.size(); ++i) {
                        PropertyMap fragment = fragments.getMap(i);
                        String regionId = fragment.getString("regionId");
                        if (inheritedRegions.get(regionId) != null) continue;
                        String category = fragment.getString("fragmentCategory");
                        EditableWindow editableWindow = (EditableWindow)editableWindows.get(category);
                        if (editableWindow != null) {
                            int windowId = windowsCount + regionWindowsCount;
                            Map properties = editableWindow.fillProps(document, fragment, Boolean.valueOf(editionMode));
                            CMSEditableWindow window = editableWindow.createNewEditabletWindow(windowId, properties);
                            windows.add(window);
                            ++regionWindowsCount;
                            continue;
                        }
                        LOG.warn((Object)("Type de fragment " + category + " non g\u00e9r\u00e9"));
                    }
                }
            }
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            if (e.getErrorCode() != 1) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        return windows;
    }

    private Map<String, List<CMSEditableWindow>> getInheritedRegions(CMSServiceCtx cmsContext, String path, String publishSpacePath, String sitePath, String navigationScope, boolean editionMode) {
        boolean directInheritance;
        HashMap<String, List<CMSEditableWindow>> inheritedRegions = new HashMap<String, List<CMSEditableWindow>>();
        CMSServiceCtx navCMSContext = new CMSServiceCtx();
        navCMSContext.setPortalControllerContext(cmsContext.getPortalControllerContext());
        navCMSContext.setScope(navigationScope);
        Set overridedRegions = this.getPageOverridedRegions(cmsContext, path, publishSpacePath);
        int windowId = 0;
        String parentPath = CMSObjectPath.parse((String)path).getParent().toString();
        while (StringUtils.startsWith((String)parentPath, (String)publishSpacePath)) {
            Map pagePropagatedRegions = this.getPagePropagatedRegions(navCMSContext, overridedRegions, windowId, parentPath, publishSpacePath, editionMode);
            inheritedRegions.putAll(pagePropagatedRegions);
            overridedRegions.addAll(pagePropagatedRegions.keySet());
            for (List windows : pagePropagatedRegions.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)windows)) continue;
                windowId += windows.size();
            }
            parentPath = CMSObjectPath.parse((String)parentPath).getParent().toString();
        }
        boolean bl = directInheritance = publishSpacePath != null && StringUtils.startsWith((String)path, (String)sitePath);
        if (!directInheritance) {
            Map pagePropagatedRegions = this.getPagePropagatedRegions(navCMSContext, overridedRegions, windowId, sitePath, sitePath, editionMode);
            inheritedRegions.putAll(pagePropagatedRegions);
        }
        return inheritedRegions;
    }

    private Set<String> getPageOverridedRegions(CMSServiceCtx cmsContext, String path, String publishSpacePath) {
        TreeSet<String> overridedRegions = new TreeSet<String>();
        try {
            CMSItem navItem = this.getPortalNavigationItem(cmsContext, publishSpacePath, path);
            if (navItem != null) {
                Map regionsInheritance = this.getCMSRegionsInheritance(navItem);
                for (Map.Entry region : regionsInheritance.entrySet()) {
                    if (RegionInheritance.DEFAULT.equals(region.getValue())) continue;
                    overridedRegions.add((String)region.getKey());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return overridedRegions;
    }

    private Map<String, List<CMSEditableWindow>> getPagePropagatedRegions(CMSServiceCtx cmsContext, Set<String> overridedRegions, int windowsCount, String path, String publishSpacePath, boolean editionMode) {
        HashMap<String, List<CMSEditableWindow>> pagePropagatedRegions;
        block14: {
            pagePropagatedRegions = new HashMap<String, List<CMSEditableWindow>>();
            try {
                String regionId;
                PropertyMap fragment;
                PropertyList fragments;
                CMSItem item;
                CMSItem navItem = this.getPortalNavigationItem(cmsContext, publishSpacePath, path);
                if (navItem == null) break block14;
                HashSet<Object> propagatedRegions = new HashSet<Object>();
                HashSet lockedRegions = new HashSet();
                org.nuxeo.ecm.automation.client.model.Document document = null;
                boolean fetched = false;
                Portal portal = PortalObjectUtils.getPortal((PortalControllerContext)cmsContext.getPortalControllerContext());
                if (PortalObjectUtils.isSpaceSite((PortalObject)portal)) {
                    Map inheritance = this.getCMSRegionsInheritance(navItem);
                    for (Map.Entry region : inheritance.entrySet()) {
                        if (RegionInheritance.LOCKED.equals(region.getValue())) {
                            pagePropagatedRegions.put((String)region.getKey(), new ArrayList());
                            propagatedRegions.add(region.getKey());
                            lockedRegions.add(region.getKey());
                            continue;
                        }
                        if (overridedRegions.contains(region.getKey())) continue;
                        if (RegionInheritance.NO_INHERITANCE.equals(region.getValue())) {
                            pagePropagatedRegions.put((String)region.getKey(), (List<CMSEditableWindow>)null);
                            continue;
                        }
                        if (!RegionInheritance.PROPAGATED.equals(region.getValue())) continue;
                        pagePropagatedRegions.put((String)region.getKey(), new ArrayList());
                        propagatedRegions.add(region.getKey());
                    }
                } else {
                    item = this.fetchContent(cmsContext, path);
                    fetched = true;
                    if (item != null) {
                        document = (org.nuxeo.ecm.automation.client.model.Document)item.getNativeItem();
                        fragments = document.getProperties().getList("fgts:fragments");
                        for (int i = 0; i < fragments.size(); ++i) {
                            fragment = fragments.getMap(i);
                            regionId = fragment.getString("regionId");
                            if (propagatedRegions.contains(regionId)) continue;
                            pagePropagatedRegions.put(regionId, new ArrayList());
                            propagatedRegions.add(regionId);
                        }
                    }
                }
                if (!propagatedRegions.isEmpty()) {
                    if (!fetched && (item = this.fetchContent(cmsContext, path)) != null) {
                        document = (org.nuxeo.ecm.automation.client.model.Document)item.getNativeItem();
                    }
                    if (document != null) {
                        int regionWindowsCount = 0;
                        fragments = document.getProperties().getList("fgts:fragments");
                        for (int i = 0; i < fragments.size(); ++i) {
                            fragment = fragments.getMap(i);
                            regionId = fragment.getString("regionId");
                            if (!propagatedRegions.contains(regionId)) continue;
                            String category = fragment.getString("fragmentCategory");
                            Map editableWindows = this.customizer.getEditableWindows((Locale)cmsContext.getServletRequest().getLocales().nextElement());
                            EditableWindow editableWindow = (EditableWindow)editableWindows.get(category);
                            if (editableWindow == null) continue;
                            List windows = (List)pagePropagatedRegions.get(regionId);
                            int windowId = windowsCount + regionWindowsCount;
                            Map properties = editableWindow.fillProps(document, fragment, Boolean.valueOf(editionMode));
                            properties.put("osivia.cms.inheritance.indicator", String.valueOf(true));
                            if (lockedRegions.contains(regionId)) {
                                properties.put("osivia.cms.inheritance.locked", String.valueOf(true));
                            }
                            CMSEditableWindow window = editableWindow.createNewEditabletWindow(windowId, properties);
                            windows.add(window);
                            ++regionWindowsCount;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pagePropagatedRegions;
    }

    public Map<String, RegionInheritance> getCMSRegionsInheritance(CMSItem item) {
        org.nuxeo.ecm.automation.client.model.Document document;
        PropertyList regions;
        HashMap<String, RegionInheritance> regionsInheritance = new HashMap<String, RegionInheritance>();
        if (item != null && (regions = (document = (org.nuxeo.ecm.automation.client.model.Document)item.getNativeItem()).getProperties().getList("rg:regions")) != null) {
            for (int i = 0; i < regions.size(); ++i) {
                PropertyMap region = regions.getMap(i);
                String id = region.getString("regionId");
                RegionInheritance inheritance = RegionInheritance.fromValue((String)region.getString("inheritance"));
                regionsInheritance.put(id, inheritance);
            }
        }
        return regionsInheritance;
    }

    public void saveCMSRegionInheritance(CMSServiceCtx cmsContext, String path, String regionName, RegionInheritance inheritance) throws org.osivia.portal.core.cms.CMSException {
        cmsContext.setDisplayLiveVersion("1");
        try {
            CMSItem cmsItem = this.getContent(cmsContext, path);
            org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
            PropertyList regions = document.getProperties().getList("rg:regions");
            if (regions != null) {
                DocumentUpdatePropertiesCommand command;
                ArrayList<String> properties = new ArrayList<String>();
                for (int i = 0; i < regions.size(); ++i) {
                    PropertyMap region = regions.getMap(i);
                    if (!StringUtils.equals((String)regionName, (String)region.getString("regionId"))) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("rg:regions");
                    builder.append(SLASH);
                    builder.append(i);
                    builder.append(SLASH);
                    builder.append("inheritance");
                    builder.append("=");
                    builder.append(StringUtils.trimToEmpty((String)inheritance.getValue()));
                    properties.add(builder.toString());
                    break;
                }
                if (properties.isEmpty()) {
                    HashMap<String, String> value = new HashMap<String, String>();
                    value.put("regionId", regionName);
                    value.put("inheritance", StringUtils.trimToEmpty((String)inheritance.getValue()));
                    command = new DocumentAddComplexPropertyCommand(document, "rg:regions", value);
                } else {
                    command = new DocumentUpdatePropertiesCommand(document, properties);
                }
                this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            }
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public Set<CMSConfigurationItem> getCMSRegionLayoutsConfigurationItems(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)cmsContext);
        HashSet<CMSConfigurationItem> configurationItems = null;
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.REGION_LAYOUT);
            try {
                Documents documents = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)cmsContext, (CMSService)this, (WebConfigurationQueryCommand)command);
                configurationItems = new HashSet<CMSConfigurationItem>(documents.size());
                for (org.nuxeo.ecm.automation.client.model.Document document : documents) {
                    PropertyMap properties = document.getProperties();
                    String code = properties.getString("wconf:code");
                    String additionalCode = properties.getString("wconf:code2");
                    CMSConfigurationItem configurationItem = new CMSConfigurationItem(document.getTitle(), code);
                    configurationItem.setAdditionalCode(additionalCode);
                    configurationItems.add(configurationItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return configurationItems;
    }

    public Map<String, CMSConfigurationItem> getCmsRegionsInheritedLayout(CMSServiceCtx cmsContext, String basePath, String path, Set<CMSConfigurationItem> configuredLayouts) throws org.osivia.portal.core.cms.CMSException {
        HashMap<String, Object> inheritedLayouts;
        if (StringUtils.isEmpty((String)basePath) || StringUtils.isEmpty((String)path) || CollectionUtils.isEmpty(configuredLayouts)) {
            inheritedLayouts = new HashMap<String, CMSConfigurationItem>(0);
        } else {
            inheritedLayouts = new HashMap();
            HashSet<String> propagatedRegions = new HashSet<String>();
            String navigationPath = path;
            while (StringUtils.startsWith((String)navigationPath, (String)basePath)) {
                org.nuxeo.ecm.automation.client.model.Document document;
                PropertyList regions;
                CMSItem navigationItem = this.getPortalNavigationItem(cmsContext, basePath, navigationPath);
                if (navigationItem != null && (regions = (document = (org.nuxeo.ecm.automation.client.model.Document)navigationItem.getNativeItem()).getProperties().getList("rg:regions")) != null) {
                    for (int i = 0; i < regions.size(); ++i) {
                        PropertyMap region = regions.getMap(i);
                        String regionId = region.getString("regionId");
                        if (propagatedRegions.contains(regionId)) continue;
                        String layoutCode = region.getString("regionLayout");
                        CMSConfigurationItem layout = null;
                        if (StringUtils.isNotEmpty((String)layoutCode)) {
                            Iterator<CMSConfigurationItem> iterator = configuredLayouts.iterator();
                            while (layout == null && iterator.hasNext()) {
                                CMSConfigurationItem configuredLayout = iterator.next();
                                if (!StringUtils.equals((String)layoutCode, (String)configuredLayout.getCode())) continue;
                                layout = configuredLayout;
                            }
                        }
                        if (layout != null) {
                            inheritedLayouts.put(regionId, layout);
                        }
                        propagatedRegions.add(regionId);
                    }
                }
                navigationPath = CMSObjectPath.parse((String)navigationPath).getParent().toString();
            }
        }
        return inheritedLayouts;
    }

    public Map<String, CMSConfigurationItem> getCMSRegionsSelectedLayout(CMSItem item, Set<CMSConfigurationItem> regionLayouts) throws org.osivia.portal.core.cms.CMSException {
        org.nuxeo.ecm.automation.client.model.Document document;
        PropertyList regions;
        HashMap<String, CMSConfigurationItem> regionsLayout = new HashMap<String, CMSConfigurationItem>();
        if (item != null && (regions = (document = (org.nuxeo.ecm.automation.client.model.Document)item.getNativeItem()).getProperties().getList("rg:regions")) != null) {
            for (int i = 0; i < regions.size(); ++i) {
                PropertyMap region = regions.getMap(i);
                String id = region.getString("regionId");
                String regionLayoutCode = region.getString("regionLayout");
                CMSConfigurationItem selectedRegionLayout = null;
                for (CMSConfigurationItem regionLayout : regionLayouts) {
                    if (!StringUtils.equals((String)regionLayout.getCode(), (String)regionLayoutCode)) continue;
                    selectedRegionLayout = regionLayout;
                    break;
                }
                regionsLayout.put(id, selectedRegionLayout);
            }
        }
        return regionsLayout;
    }

    public void saveCMSRegionSelectedLayout(CMSServiceCtx cmsContext, String path, String regionName, String regionLayoutName) throws org.osivia.portal.core.cms.CMSException {
        cmsContext.setDisplayLiveVersion("1");
        try {
            CMSItem cmsItem = this.getContent(cmsContext, path);
            org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
            PropertyList regions = document.getProperties().getList("rg:regions");
            if (regions != null) {
                DocumentUpdatePropertiesCommand command;
                ArrayList<String> properties = new ArrayList<String>();
                for (int i = 0; i < regions.size(); ++i) {
                    PropertyMap region = regions.getMap(i);
                    if (!StringUtils.equals((String)regionName, (String)region.getString("regionId"))) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("rg:regions");
                    builder.append(SLASH);
                    builder.append(i);
                    builder.append(SLASH);
                    builder.append("regionLayout");
                    builder.append("=");
                    builder.append(StringUtils.trimToEmpty((String)regionLayoutName));
                    properties.add(builder.toString());
                    break;
                }
                if (properties.isEmpty()) {
                    HashMap<String, String> value = new HashMap<String, String>();
                    value.put("regionId", regionName);
                    value.put("regionLayout", StringUtils.trimToEmpty((String)regionLayoutName));
                    command = new DocumentAddComplexPropertyCommand(document, "rg:regions", value);
                } else {
                    command = new DocumentUpdatePropertiesCommand(document, properties);
                }
                this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            }
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public void deleteFragment(CMSServiceCtx cmsCtx, String pagePath, String refURI) throws org.osivia.portal.core.cms.CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        org.nuxeo.ecm.automation.client.model.Document doc = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        PropertyList fragments = doc.getProperties().getList("fgts:fragments");
        List propertiesToRemove = null;
        if (fragments != null && !fragments.isEmpty()) {
            for (int fragmentIndex = 0; fragmentIndex < fragments.size(); ++fragmentIndex) {
                if (!refURI.equals(fragments.getMap(fragmentIndex).get("uri"))) continue;
                String fragmentCategory = (String)fragments.getMap(fragmentIndex).get("fragmentCategory");
                Map editableWindows = this.customizer.getEditableWindows((Locale)cmsCtx.getServletRequest().getLocales().nextElement());
                EditableWindow ew = (EditableWindow)editableWindows.get(fragmentCategory);
                if (ew == null) continue;
                propertiesToRemove = ew.prepareDelete(doc, refURI);
            }
        }
        try {
            if (propertiesToRemove != null) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentRemovePropertyCommand(doc, propertiesToRemove));
                PageProperties.getProperties().setRefreshingPage(true);
                cmsCtx.setForceReload(true);
                this.getContent(cmsCtx, pagePath);
                cmsCtx.setForceReload(false);
            }
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public String getEcmDomain(CMSServiceCtx cmsCtx) {
        String fqdn = NuxeoConnectionProperties.getPublicDomainUri().toString();
        if (StringUtils.isBlank((String)fqdn) && cmsCtx != null && cmsCtx.getServletRequest() != null) {
            String vhost = null;
            if (cmsCtx.getServletRequest() != null) {
                vhost = cmsCtx.getServletRequest().getHeader("osivia-virtual-host");
            }
            if (StringUtils.isNotBlank(vhost)) {
                return vhost;
            }
            return cmsCtx.getRequest().getScheme() + "://" + cmsCtx.getRequest().getServerName();
        }
        return fqdn;
    }

    public void moveFragment(CMSServiceCtx cmsCtx, String pagePath, String fromRegion, Integer fromPos, String toRegion, Integer toPos, String refUri) throws org.osivia.portal.core.cms.CMSException {
        cmsCtx.setForceReload(true);
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        org.nuxeo.ecm.automation.client.model.Document doc = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        try {
            List propertiesToUpdate = EditableWindowHelper.checkBeforeMove((org.nuxeo.ecm.automation.client.model.Document)doc, (String)fromRegion, (Integer)fromPos, (String)refUri);
            if (propertiesToUpdate.size() > 0) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentUpdatePropertiesCommand(doc, propertiesToUpdate));
                CMSItem content = this.getContent(cmsCtx, pagePath);
                doc = (org.nuxeo.ecm.automation.client.model.Document)content.getNativeItem();
            }
            if ((propertiesToUpdate = EditableWindowHelper.prepareMove((org.nuxeo.ecm.automation.client.model.Document)doc, (String)fromRegion, (Integer)fromPos, (String)toRegion, (Integer)toPos, (String)refUri)).size() > 0) {
                this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentUpdatePropertiesCommand(doc, propertiesToUpdate));
                PageProperties.getProperties().setRefreshingPage(true);
                this.getContent(cmsCtx, pagePath);
            }
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        finally {
            cmsCtx.setForceReload(false);
        }
    }

    public boolean isCmsWebPage(CMSServiceCtx cmsCtx, String cmsPath) throws org.osivia.portal.core.cms.CMSException {
        CMSItem content = this.getContent(cmsCtx, cmsPath);
        org.nuxeo.ecm.automation.client.model.Document nativeItem = (org.nuxeo.ecm.automation.client.model.Document)content.getNativeItem();
        PropertyList list = nativeItem.getProperties().getList("fgts:fragments");
        return list != null;
    }

    public void publishDocument(CMSServiceCtx cmsCtx, String pagePath) throws org.osivia.portal.core.cms.CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        org.nuxeo.ecm.automation.client.model.Document doc = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new SetOnLineCommand(doc));
            cmsCtx.setDisplayLiveVersion("0");
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public void unpublishDocument(CMSServiceCtx cmsCtx, String pagePath) throws org.osivia.portal.core.cms.CMSException {
        org.nuxeo.ecm.automation.client.model.Document inputDoc;
        String reloadPagePath = pagePath;
        cmsCtx.setDisplayLiveVersion("0");
        CMSItem cmsPublishedItem = this.getContent(cmsCtx, pagePath);
        org.nuxeo.ecm.automation.client.model.Document publishedDoc = (org.nuxeo.ecm.automation.client.model.Document)cmsPublishedItem.getNativeItem();
        cmsCtx.setDisplayLiveVersion("1");
        boolean isRemoteProxy = false;
        PropertyList facetsProp = publishedDoc.getFacets();
        for (Object facet : facetsProp.list()) {
            if (!facet.toString().equals("isRemoteProxy")) continue;
            isRemoteProxy = true;
        }
        if (isRemoteProxy) {
            inputDoc = publishedDoc;
            reloadPagePath = StringUtils.substringBeforeLast((String)pagePath, (String)SLASH);
            cmsCtx.setDisplayLiveVersion("0");
        } else {
            CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
            inputDoc = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        }
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new SetOffLineCommand(inputDoc));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, reloadPagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public void askToPublishDocument(CMSServiceCtx cmsCtx, String pagePath) throws org.osivia.portal.core.cms.CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        org.nuxeo.ecm.automation.client.model.Document doc = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new AskSetOnLineCommand(doc));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public void cancelPublishWorkflow(CMSServiceCtx cmsCtx, String pagePath) throws org.osivia.portal.core.cms.CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        org.nuxeo.ecm.automation.client.model.Document doc = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new CancelWorkflowCommand(doc, "toutatice_online_approbation"));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public void validatePublicationOfDocument(CMSServiceCtx cmsCtx, String pagePath) throws org.osivia.portal.core.cms.CMSException {
        this.callValidationCommand(cmsCtx, pagePath, true);
    }

    public void rejectPublicationOfDocument(CMSServiceCtx cmsCtx, String pagePath) throws org.osivia.portal.core.cms.CMSException {
        this.callValidationCommand(cmsCtx, pagePath, false);
    }

    public void callValidationCommand(CMSServiceCtx cmsCtx, String pagePath, boolean accept) throws org.osivia.portal.core.cms.CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        org.nuxeo.ecm.automation.client.model.Document doc = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new ValidationPublishCommand(doc, accept));
            cmsCtx.setForceReload(true);
            this.getContent(cmsCtx, pagePath);
            cmsCtx.setForceReload(false);
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public void deleteDocument(CMSServiceCtx cmsCtx, String pagePath) throws org.osivia.portal.core.cms.CMSException {
        cmsCtx.setDisplayLiveVersion("1");
        CMSItem cmsItem = this.getContent(cmsCtx, pagePath);
        org.nuxeo.ecm.automation.client.model.Document doc = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new DocumentDeleteCommand(doc));
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public Map<String, String> getNxPathParameters(String cmsPath) {
        String params;
        HashMap<String, String> parameters = new HashMap<String, String>(0);
        if (StringUtils.contains((String)cmsPath, (String)"?") && StringUtils.isNotBlank((String)(params = StringUtils.substringAfter((String)cmsPath, (String)"?")))) {
            String[] keysValues;
            for (String keyValue : keysValues = StringUtils.split((String)params, (String)"&")) {
                String[] keyNValue = StringUtils.split((String)keyValue, (String)"=");
                parameters.put(keyNValue[0], keyNValue[1]);
            }
        }
        return parameters;
    }

    public void putDocumentInTrash(CMSServiceCtx cmsCtx, String docId) throws org.osivia.portal.core.cms.CMSException {
        try {
            this.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new PutInTrashDocumentCommand(docId));
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public String refreshUserAvatar(CMSServiceCtx cmsCtx, String username) {
        return this.customizer.refreshUserAvatar(cmsCtx, username);
    }

    public Link getBinaryResourceURL(CMSServiceCtx cmsCtx, BinaryDescription binary) throws org.osivia.portal.core.cms.CMSException {
        return this.customizer.getBinaryResourceURL(cmsCtx, binary);
    }

    public BinaryDelegation validateBinaryDelegation(CMSServiceCtx cmsCtx, String path) {
        return this.customizer.validateBinaryDelegation(cmsCtx, path);
    }

    public String getParentPath(String documentPath) {
        if (StringUtils.endsWith((String)documentPath, (String)SLASH)) {
            documentPath = StringUtils.removeEnd((String)documentPath, (String)SLASH);
        }
        return StringUtils.substringBeforeLast((String)documentPath, (String)SLASH);
    }

    public TaskbarItems getTaskbarItems(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.customizeTaskbarItems();
    }

    public List<TaskbarTask> getTaskbarTasks(CMSServiceCtx cmsContext, String basePath, boolean navigation) throws org.osivia.portal.core.cms.CMSException {
        CMSItem spaceCmsItem = this.getSpaceConfig(cmsContext, basePath);
        org.nuxeo.ecm.automation.client.model.Document spaceDocument = (org.nuxeo.ecm.automation.client.model.Document)spaceCmsItem.getNativeItem();
        String shortname = spaceDocument.getString("webc:url");
        CMSPublicationInfos publicationInfos = null;
        String webIdPrefix = "workspace_" + shortname + "_";
        List cmsItems = navigation ? this.getPortalNavigationSubitems(cmsContext, basePath, basePath) : this.getChildren(cmsContext, spaceDocument.getId(), 1);
        TaskbarItems taskbarItems = this.getTaskbarItems(cmsContext);
        TaskbarFactory factory = this.taskbarService.getFactory();
        ArrayList<TaskbarTask> tasks = new ArrayList<TaskbarTask>(cmsItems.size());
        for (CMSItem cmsItem : cmsItems) {
            TaskbarTask task;
            org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
            DocumentType type = cmsItem.getType();
            String webId = document.getString("ttc:webid");
            boolean disabled = !"1".equals(cmsItem.getProperties().get("menuItem"));
            TaskbarItem taskbarItem = null;
            for (TaskbarItem item : taskbarItems.getAll()) {
                String expectedWebId;
                if (!TaskbarItemType.STAPLED.equals((Object)item.getType()) && !document.getType().equals(item.getDocumentType()) || !(expectedWebId = webIdPrefix + StringUtils.lowerCase((String)item.getId())).equals(webId)) continue;
                taskbarItem = item;
                break;
            }
            if (taskbarItem == null && type != null) {
                String taskPath = document.getPath();
                if (navigation && StringUtils.isNotEmpty((String)cmsItem.getNavigationPath()) && StringUtils.isNotEmpty((String)VirtualNavigationUtils.getWebId((String)cmsItem.getNavigationPath()))) {
                    taskPath = cmsItem.getNavigationPath();
                }
                task = factory.createTaskbarTask(document.getId(), document.getTitle(), type.getIcon(), taskPath, type.getName(), disabled);
            } else if (taskbarItem != null) {
                boolean granted;
                TaskbarItemRestriction restriction = taskbarItem.getRestriction();
                if (restriction == null) {
                    granted = true;
                } else {
                    if (publicationInfos == null) {
                        publicationInfos = this.getPublicationInfos(cmsContext, basePath);
                    }
                    granted = TaskbarItemRestriction.EDITION.equals((Object)restriction) ? publicationInfos.isEditableByUser() : (TaskbarItemRestriction.MANAGEMENT.equals((Object)restriction) ? publicationInfos.isManageableByUser() : false);
                }
                task = granted ? factory.createTaskbarTask(taskbarItem, document.getTitle(), document.getPath(), disabled) : null;
            } else {
                task = null;
            }
            if (task == null) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private List<CMSItem> getChildren(CMSServiceCtx cmsContext, String parentId, int state) throws org.osivia.portal.core.cms.CMSException {
        Documents documents;
        try {
            GetChildrenCommand command = new GetChildrenCommand(parentId, state);
            documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        ArrayList<CMSItem> cmsItems = new ArrayList<CMSItem>(documents.size());
        for (org.nuxeo.ecm.automation.client.model.Document document : documents) {
            CMSItem cmsItem = this.createItem(cmsContext, document.getPath(), document.getTitle(), document);
            cmsItems.add(cmsItem);
        }
        return cmsItems;
    }

    public PanelPlayer getNavigationPanelPlayer(String instance) {
        return (PanelPlayer)this.customizer.getNavigationPanelPlayers().get(instance);
    }

    public String getMoveUrl(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        String url = null;
        PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
        org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)cmsContext.getDoc();
        CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, document.getPath());
        DocumentType cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
        if (cmsItemType != null && cmsItemType.isEditable()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.move.documentPath", publicationInfos.getDocumentPath());
            properties.put("osivia.move.cmsBasePath", publicationInfos.getPublishSpacePath());
            properties.put("osivia.move.acceptedTypes", cmsItemType.getName());
            try {
                url = this.urlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-move-portlet-instance", properties, PortalUrlType.POPUP);
            }
            catch (PortalException e) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
        }
        return url;
    }

    public String getReorderUrl(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        String url = null;
        PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
        org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)cmsContext.getDoc();
        CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, document.getPath());
        if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_62) || !DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)publicationInfos) && publicationInfos.isLiveSpace()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.reorder.path", document.getPath());
            try {
                url = this.urlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-reorder-portlet-instance", properties, PortalUrlType.POPUP);
            }
            catch (PortalException e) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
        }
        return url;
    }

    public String getAdaptedNavigationPath(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)cmsContext.getDoc();
        String path = document.getPath();
        CMSPublicationInfos publicationInfos = this.getPublicationInfos(cmsContext, path);
        if (publicationInfos.isDraft()) {
            return publicationInfos.getDraftContextualizationPath();
        }
        String navigationPath = null;
        List adapters = pluginManager.customizeNavigationAdapters();
        if (CollectionUtils.isNotEmpty((Collection)adapters)) {
            Iterator adaptersIterator = adapters.iterator();
            while (StringUtils.isEmpty(navigationPath) && adaptersIterator.hasNext()) {
                Symlinks symlinks;
                INavigationAdapterModule adapter = (INavigationAdapterModule)adaptersIterator.next();
                navigationPath = adapter.adaptNavigationPath(portalControllerContext, (EcmDocument)document);
                if (!StringUtils.isEmpty((String)navigationPath) || (symlinks = adapter.getSymlinks(portalControllerContext)) == null || !CollectionUtils.isNotEmpty((Collection)symlinks.getLinks())) continue;
                Iterator symlinksIterator = symlinks.getLinks().iterator();
                while (StringUtils.isEmpty((String)navigationPath) && symlinksIterator.hasNext()) {
                    Symlink symlink = (Symlink)symlinksIterator.next();
                    if (!StringUtils.startsWith((String)path, (String)symlink.getTargetPath())) continue;
                    navigationPath = symlink.getNavigationPath();
                }
            }
        }
        return navigationPath;
    }

    public DomainContextualization getDomainContextualization(CMSServiceCtx cmsContext, String domainPath) {
        PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        List domainContextualizations = pluginManager.customizeDomainContextualization();
        DomainContextualization result = null;
        for (DomainContextualization domainContextualization : domainContextualizations) {
            if (!domainContextualization.contextualize(portalControllerContext, domainPath)) continue;
            result = domainContextualization;
            break;
        }
        return result;
    }

    public DocumentMetadata getDocumentMetadata(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        DocumentMetadata metadata = new DocumentMetadata();
        org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)cmsContext.getDoc();
        if (document != null) {
            String author;
            metadata.setTitle(document.getTitle());
            Map seo = metadata.getSeo();
            String description = document.getString("dc:description");
            if (StringUtils.isNotBlank((String)description)) {
                seo.put("description", description);
            }
            if (StringUtils.isNotBlank((String)(author = document.getString("dc:creator")))) {
                seo.put("author", author);
            }
            String keywordsProperty = System.getProperty("nuxeo.keywords.property", "ttc:keywords");
            PropertyList keywords = document.getProperties().getList(keywordsProperty);
            if (keywords != null && !keywords.isEmpty()) {
                seo.put("keywords", StringUtils.join((Collection)keywords.list(), (String)", "));
            }
        }
        return metadata;
    }

    public DocumentsMetadata getDocumentsMetadata(CMSServiceCtx cmsContext, String basePath, Long timestamp) throws org.osivia.portal.core.cms.CMSException {
        DocumentsMetadata metadata;
        PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        List adapters = pluginManager.customizeNavigationAdapters();
        RequestPublishStatus version = "1".equals(cmsContext.getDisplayLiveVersion()) ? RequestPublishStatus.live : RequestPublishStatus.published;
        Symlinks symlinks = null;
        for (INavigationAdapterModule adapter : adapters) {
            Symlinks adapterSymlinks = adapter.getSymlinks(portalControllerContext);
            if (adapterSymlinks == null) continue;
            if (symlinks == null) {
                symlinks = adapterSymlinks;
                continue;
            }
            symlinks.addAll(adapterSymlinks);
        }
        DocumentsMetadataCommand command = new DocumentsMetadataCommand(basePath, version, symlinks, timestamp);
        String savedScope = cmsContext.getScope();
        cmsContext.setScope("superuser_no_cache");
        try {
            metadata = (DocumentsMetadata)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        finally {
            cmsContext.setScope(savedScope);
        }
        return metadata;
    }

    public Map<String, TabGroup> getTabGroups(CMSServiceCtx cmsContext) {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.customizeTabGroups();
    }

    public List<MenubarModule> getMenubarModules(CMSServiceCtx cmsContext) {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.customizeMenubarModules();
    }

    public NuxeoDocumentContext getDocumentContext(CMSServiceCtx cmsContext, String path) throws org.osivia.portal.core.cms.CMSException {
        return NuxeoDocumentContextImpl.getDocumentContext((CMSServiceCtx)cmsContext, (String)path);
    }

    public <D extends DocumentContext> D getDocumentContext(CMSServiceCtx cmsContext, String path, Class<D> expectedType) throws org.osivia.portal.core.cms.CMSException {
        NuxeoDocumentContext nuxeoDocumentContext = this.getDocumentContext(cmsContext, path);
        DocumentContext expectedDocumentContext = expectedType.isInstance(nuxeoDocumentContext) ? (DocumentContext)expectedType.cast(nuxeoDocumentContext) : null;
        return (D)expectedDocumentContext;
    }

    public List<TemplateAdapter> getTemplateAdapters(CMSServiceCtx cmsContext) {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.customizeTemplateAdapters();
    }

    public List<EcmDocument> getTasks(CMSServiceCtx cmsContext, String user) throws org.osivia.portal.core.cms.CMSException {
        Documents documents;
        Set actors = this.getTaskActors(user, false);
        HashSet<String> directives = new HashSet<String>(TaskDirective.values().length);
        for (TaskDirective directive : TaskDirective.values()) {
            directives.add(directive.getId());
        }
        GetTasksCommand command = new GetTasksCommand(actors, true, directives);
        try {
            documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        return new ArrayList<EcmDocument>(documents.list());
    }

    public EcmDocument getTask(CMSServiceCtx cmsContext, String user, String path, UUID uuid) throws org.osivia.portal.core.cms.CMSException {
        Documents documents;
        Set actors = this.getTaskActors(user, true);
        GetTasksCommand command = new GetTasksCommand(actors, path, uuid);
        try {
            documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        org.nuxeo.ecm.automation.client.model.Document task = documents.size() == 1 ? documents.get(0) : null;
        return task;
    }

    public Map<String, String> updateTask(CMSServiceCtx cmsContext, UUID uuid, String actionId, Map<String, String> variables) throws org.osivia.portal.core.cms.CMSException {
        Map updatedVariables;
        PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
        try {
            CMSItem task = this.getTask(cmsContext, uuid);
            updatedVariables = task != null ? this.formsService.proceed(portalControllerContext, (org.nuxeo.ecm.automation.client.model.Document)task.getNativeItem(), actionId, variables) : null;
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        return updatedVariables;
    }

    public CMSItem getTask(CMSServiceCtx cmsContext, UUID uuid) throws org.osivia.portal.core.cms.CMSException {
        CMSItem cmsItem;
        PortalControllerContext portalControllerContext = cmsContext.getPortalControllerContext();
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        String user = portalControllerContext.getHttpServletRequest().getRemoteUser();
        Set actors = null;
        if (StringUtils.isNotEmpty((String)user)) {
            actors = this.getTaskActors(user, true);
        }
        GetTasksCommand command = new GetTasksCommand(actors, null, uuid);
        try {
            Documents documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            if (documents.size() == 1) {
                org.nuxeo.ecm.automation.client.model.Document document = documents.get(0);
                cmsItem = this.createItem(cmsContext, document.getPath(), document.getTitle(), document, null);
                List taskModules = pluginManager.getTaskModules();
                if (CollectionUtils.isNotEmpty((Collection)taskModules)) {
                    for (TaskModule taskModule : taskModules) {
                        taskModule.adaptTaskItem(portalControllerContext, (EcmDocument)document, cmsItem.getProperties());
                    }
                }
            } else {
                cmsItem = null;
            }
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        return cmsItem;
    }

    private Set<String> getTaskActors(String user, boolean includeAnonymous) {
        String anonymousUser;
        Name dn = this.personService.getEmptyPerson().buildDn(user);
        Group criteria = this.groupService.getEmptyGroup();
        criteria.setMembers(Arrays.asList(dn));
        List groups = this.groupService.search(criteria);
        HashSet<String> actors = new HashSet<String>((groups.size() + 1) * 2);
        actors.add(user);
        actors.add("user:" + user);
        for (Group group : groups) {
            if (group == null) continue;
            String cn = group.getCn();
            actors.add(cn);
            actors.add("group:" + cn);
        }
        if (includeAnonymous && StringUtils.isNotEmpty((String)(anonymousUser = System.getProperty("user.anonymous")))) {
            actors.add("user:" + anonymousUser);
        }
        return actors;
    }

    public void reloadSession(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        HttpServletRequest servletRequest = cmsContext.getPortalControllerContext().getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        ReloadNuxeoSessionCommand command = new ReloadNuxeoSessionCommand();
        try {
            this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        session.setAttribute("osivia.session.reload", (Object)true);
    }

    public List<EcmDocument> getUserSubscriptions(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        Documents documents;
        String savedScope = cmsContext.getScope();
        try {
            cmsContext.setScope("user_session");
            GetUserSubscriptionsCommand command = new GetUserSubscriptionsCommand();
            documents = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        finally {
            cmsContext.setScope(savedScope);
        }
        ArrayList<EcmDocument> subscriptions = new ArrayList<EcmDocument>(documents.size());
        subscriptions.addAll(documents.list());
        return subscriptions;
    }

    public Map<String, String> getTitleMetadataProperties(CMSServiceCtx cmsContext, String path) throws org.osivia.portal.core.cms.CMSException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        CMSItem cmsItem = this.getContent(cmsContext, path);
        org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        String description = document.getString("dc:description");
        windowProperties.put("osivia.subtitle", description);
        PropertyMap vignetteMap = document.getProperties().getMap("ttc:vignette");
        if (vignetteMap != null && !vignetteMap.isEmpty()) {
            BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.FILE, document.getPath());
            binary.setFieldName("ttc:vignette");
            binary.setDocument((Object)document);
            Link vignetteLink = this.getBinaryResourceURL(cmsContext, binary);
            String vignetteUrl = vignetteLink.getUrl();
            windowProperties.put("osivia.vignette.url", vignetteUrl);
        }
        return windowProperties;
    }

    public List<CMSEditableWindow> getProcedureDashboards(CMSServiceCtx cmsContext, String path) throws org.osivia.portal.core.cms.CMSException {
        ArrayList<CMSEditableWindow> procedureDashboards = new ArrayList<CMSEditableWindow>();
        try {
            String user = cmsContext.getRequest().getRemoteUser();
            List userProfiles = this.personService.getPerson(user).getProfiles();
            CMSItem pageItem = this.fetchContent(cmsContext, path);
            org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)pageItem.getNativeItem();
            PropertyList dashboards = document.getProperties().getList("pcd:dashboards");
            String webid = document.getProperties().getString("ttc:webid");
            if (dashboards != null) {
                for (Object dashboardO : dashboards.list()) {
                    PropertyMap dashboardM = (PropertyMap)dashboardO;
                    String name = dashboardM.getString("name");
                    List groupsList = dashboardM.getList("groups").list();
                    if (!this.isAuthorised(userProfiles, groupsList)) continue;
                    HashMap<String, String> applicationProperties = new HashMap<String, String>(11);
                    applicationProperties.put("osivia.forms.list.model.id", webid);
                    applicationProperties.put("osivia.forms.dashboard.id", name);
                    applicationProperties.put("osivia.services.procedure.webid", webid);
                    applicationProperties.put("osivia.services.procedure.uuid", document.getId());
                    applicationProperties.put("osivia.doctype", document.getType());
                    applicationProperties.put("osivia.hideDecorators", "1");
                    applicationProperties.put("theme.dyna.partial_refresh_enabled", "true");
                    applicationProperties.put("osivia.ajaxLink", "1");
                    applicationProperties.put("osivia.cms.displayLiveVersion", "1");
                    applicationProperties.put("osivia.title", name);
                    applicationProperties.put("theme.order", String.valueOf(procedureDashboards.size()));
                    CMSEditableWindow ew = new CMSEditableWindow(name, "toutatice-portail-cms-nuxeo-viewProcedurePortletInstance", applicationProperties);
                    procedureDashboards.add(ew);
                }
            }
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            if (e.getErrorCode() != 1) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
        return procedureDashboards;
    }

    private boolean isAuthorised(List<Name> userProfiles, List<Object> groupsList) {
        if (CollectionUtils.isEmpty(groupsList)) {
            return true;
        }
        for (Object group : groupsList) {
            for (Name userProfile : userProfiles) {
                Enumeration<String> groupName = userProfile.getAll();
                while (groupName.hasMoreElements()) {
                    String nextElement = groupName.nextElement();
                    String userGroup = StringUtils.split((String)nextElement, (char)'=')[1];
                    if (!StringUtils.equals((String)userGroup, (String)((String)group))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<SpaceStatistics> getSpaceStatistics(CMSServiceCtx cmsContext, Set<String> paths) throws org.osivia.portal.core.cms.CMSException {
        if (cmsContext.getPortletCtx() == null) {
            cmsContext.setPortletCtx(this.portletCtx);
        }
        return this.statisticsServiceDelegation.getSpaceStatistics(cmsContext, paths);
    }

    public void incrementsStatistics(CMSServiceCtx cmsContext, HttpSession httpSession, String path) throws org.osivia.portal.core.cms.CMSException {
        if (cmsContext.getPortletCtx() == null) {
            cmsContext.setPortletCtx(this.portletCtx);
        }
        this.statisticsServiceDelegation.increments(cmsContext, path);
    }

    public void updateStatistics(CMSServiceCtx cmsContext, HttpSession httpSession, List<SpaceStatistics> spaceStatistics) throws org.osivia.portal.core.cms.CMSException {
        if (cmsContext.getPortletCtx() == null) {
            cmsContext.setPortletCtx(this.portletCtx);
        }
        this.statisticsServiceDelegation.updateStatistics(cmsContext, httpSession, spaceStatistics);
    }

    public Set<Satellite> getSatellites() throws org.osivia.portal.core.cms.CMSException {
        LinkedHashSet<Satellite> satellites;
        Object[] ids = StringUtils.split((String)System.getProperty("nuxeo.satellites"), (String)",");
        if (ArrayUtils.isEmpty((Object[])ids)) {
            satellites = null;
        } else {
            satellites = new LinkedHashSet<Satellite>(ids.length);
            for (Object id : ids) {
                Satellite satellite = new Satellite((String)id);
                satellite.setLabel(StringUtils.defaultIfBlank((String)System.getProperty("nuxeo.satellite." + (String)id + ".label"), (String)id));
                satellite.setPublicHost(System.getProperty("nuxeo.satellite." + (String)id + ".publicHost"));
                satellite.setPublicPort(System.getProperty("nuxeo.satellite." + (String)id + ".publicPort"));
                satellite.setPrivateHost(System.getProperty("nuxeo.satellite." + (String)id + ".privateHost"));
                satellite.setPrivatePort(System.getProperty("nuxeo.satellite." + (String)id + ".privatePort"));
                Object[] paths = StringUtils.split((String)System.getProperty("nuxeo.satellite." + (String)id + ".paths"), (String)",");
                if (ArrayUtils.isNotEmpty((Object[])paths)) {
                    ArrayList<Pattern> patterns = new ArrayList<Pattern>(paths.length);
                    for (Object path : paths) {
                        Pattern pattern = Pattern.compile((String)path, 2);
                        patterns.add(pattern);
                    }
                    satellite.setPaths(patterns);
                }
                satellites.add(satellite);
            }
        }
        return satellites;
    }

    public CMSItem getSharingRoot(CMSServiceCtx cmsContext) throws org.osivia.portal.core.cms.CMSException {
        CMSItem root;
        HttpServletRequest servletRequest = cmsContext.getPortalControllerContext().getHttpServletRequest();
        String user = servletRequest.getRemoteUser();
        Object nativeItem = cmsContext.getDoc();
        if (StringUtils.isNotEmpty((String)user) && nativeItem != null && nativeItem instanceof org.nuxeo.ecm.automation.client.model.Document) {
            org.nuxeo.ecm.automation.client.model.Document document = (org.nuxeo.ecm.automation.client.model.Document)nativeItem;
            String path = document.getPath();
            GetAncestorsCommand command = new GetAncestorsCommand(path);
            try {
                org.nuxeo.ecm.automation.client.model.Document ancestor2;
                Documents ancestors = (Documents)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
                if (ancestors == null || ancestors.isEmpty()) {
                    root = null;
                }
                HashMap<String, org.nuxeo.ecm.automation.client.model.Document> map = new HashMap<String, org.nuxeo.ecm.automation.client.model.Document>(ancestors.size());
                for (org.nuxeo.ecm.automation.client.model.Document ancestor2 : ancestors) {
                    map.put(ancestor2.getPath(), ancestor2);
                }
                String rootPath = null;
                ancestor2 = (org.nuxeo.ecm.automation.client.model.Document)map.get(path);
                while (ancestor2 != null && StringUtils.countMatches((String)path, (String)SLASH) > 1) {
                    boolean enabled = false;
                    PropertyList facets = ancestor2.getFacets();
                    if (facets != null) {
                        for (int i = 0; !enabled && i < facets.size(); ++i) {
                            String facet = facets.getString(i);
                            enabled = "Sharing".equals(facet);
                        }
                    }
                    if (enabled) {
                        rootPath = ancestor2.getPath();
                    }
                    path = StringUtils.substringBeforeLast((String)path, (String)SLASH);
                    ancestor2 = (org.nuxeo.ecm.automation.client.model.Document)map.get(path);
                }
                if (rootPath == null) {
                    root = null;
                }
                root = new CMSItem(rootPath, null, null, null, map.get(rootPath));
            }
            catch (org.osivia.portal.core.cms.CMSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
        } else {
            root = null;
        }
        return root;
    }

    public String resolveLinkSharing(CMSServiceCtx cmsContext, String linkId) throws org.osivia.portal.core.cms.CMSException {
        String path;
        HttpServletRequest servletRequest = cmsContext.getPortalControllerContext().getHttpServletRequest();
        String user = servletRequest.getRemoteUser();
        if (StringUtils.isBlank((String)linkId) || StringUtils.isEmpty((String)user)) {
            path = null;
        } else {
            org.nuxeo.ecm.automation.client.model.Document document;
            ResolveSharingLinkCommand command = new ResolveSharingLinkCommand(linkId, user);
            String savedScope = cmsContext.getScope();
            try {
                cmsContext.setScope("superuser_context");
                document = (org.nuxeo.ecm.automation.client.model.Document)this.executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            }
            catch (org.osivia.portal.core.cms.CMSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
            }
            finally {
                cmsContext.setScope(savedScope);
            }
            path = document == null ? null : document.getPath();
        }
        return path;
    }

    public List<EditorModule> getEditorModules(CMSServiceCtx cmsContext) {
        CustomizationPluginMgr pluginManager = this.customizer.getPluginManager();
        return pluginManager.getEditorModules();
    }

    public Map<String, String> getEditorWindowBaseProperties(CMSServiceCtx cmsContext) {
        PortletRequest request = cmsContext.getRequest();
        MimeResponse response = cmsContext.getResponse();
        PortletContext portletContext = cmsContext.getPortletCtx();
        NuxeoController nuxeoController = new NuxeoController(request, (PortletResponse)response, portletContext);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.editor.basePath", nuxeoController.getBasePath());
        properties.put("osivia.editor.path", nuxeoController.getContentPath());
        return properties;
    }

    public UniversalID getUniversalIDFromPath(CMSServiceCtx cmsContext, String path) throws org.osivia.portal.core.cms.CMSException {
        try {
            CMSController ctrl = new CMSController(cmsContext.getPortalControllerContext());
            NuxeoRepository nuxeoRepository = (NuxeoRepository)((org.osivia.portal.api.cms.service.CMSService)Locator.getService(org.osivia.portal.api.cms.service.CMSService.class)).getUserRepository(ctrl.getCMSContext(), NUXEO_REPOSITORY_NAME);
            return new UniversalID(NUXEO_REPOSITORY_NAME, nuxeoRepository.getInternalId(path));
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public String getPathFromUniversalID(CMSServiceCtx cmsContext, UniversalID id) throws org.osivia.portal.core.cms.CMSException {
        try {
            CMSController ctrl = new CMSController(cmsContext.getPortalControllerContext());
            NuxeoRepository nuxeoRepository = (NuxeoRepository)((org.osivia.portal.api.cms.service.CMSService)Locator.getService(org.osivia.portal.api.cms.service.CMSService.class)).getUserRepository(ctrl.getCMSContext(), id.getRepositoryName());
            return nuxeoRepository.getPath(id.getInternalID());
        }
        catch (Exception e) {
            throw new org.osivia.portal.core.cms.CMSException((Throwable)e);
        }
    }

    public PortletContext getPortletContext() throws org.osivia.portal.core.cms.CMSException {
        return this.portletCtx;
    }
}

