/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.AvatarInfo;
import fr.toutatice.portail.cms.nuxeo.portlets.document.DocumentFetchLiveCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.FileContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetUserProfileCommand;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class AvatarUtils {
    private static final Log log = LogFactory.getLog(AvatarUtils.class);
    protected static PortletContext portletContext;
    private static Long timeout;
    private static Map<String, AvatarInfo> avatarMap;

    private static Document getUserProfile(String userId, boolean reload) {
        Document fetchedUserProfile;
        NuxeoController ctx = new NuxeoController(portletContext);
        ctx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        ctx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        ctx.setCacheTimeOut(timeout.longValue());
        if (reload) {
            ctx.setForceReload(true);
        }
        try {
            GetUserProfileCommand userProfileCommand = new GetUserProfileCommand(userId);
            Document userProfile = (Document)ctx.executeNuxeoCommand((INuxeoCommand)userProfileCommand);
            if (userProfile != null) {
                DocumentFetchLiveCommand fetchLiveCommand = new DocumentFetchLiveCommand(userProfile.getPath(), "Read");
                fetchedUserProfile = (Document)ctx.executeNuxeoCommand((INuxeoCommand)fetchLiveCommand);
            } else {
                fetchedUserProfile = null;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            fetchedUserProfile = null;
        }
        return fetchedUserProfile;
    }

    private static CMSBinaryContent getAvatarContent(Document userProfile) {
        NuxeoController ctx = new NuxeoController(portletContext);
        ctx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        ctx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        ctx.setForceReload(true);
        try {
            FileContentCommand command = new FileContentCommand(userProfile, "userprofile:avatar");
            CMSBinaryContent content = (CMSBinaryContent)ctx.executeNuxeoCommand((INuxeoCommand)command);
            return content;
        }
        catch (Exception e) {
            log.error((Object)e);
            CMSBinaryContent content = null;
            return content;
        }
    }

    private static void fillAvatar(String username, AvatarInfo avatar) {
        Document fetchedUserProfile = AvatarUtils.getUserProfile(username, true);
        if (fetchedUserProfile != null) {
            avatar.setDigest(AvatarUtils.getAvatarDigest(fetchedUserProfile));
        }
        if (fetchedUserProfile == null || avatar.getDigest() == null) {
            avatar.setGenericResource(true);
        } else {
            CMSBinaryContent binaryContent = AvatarUtils.getAvatarContent(fetchedUserProfile);
            if (binaryContent != null) {
                avatar.setGenericResource(false);
                avatar.setBinaryContent(binaryContent);
            } else {
                avatar.setGenericResource(true);
            }
        }
    }

    private static String getAvatarDigest(Document fetchedUserProfile) {
        PropertyMap avatarMap;
        String digest = fetchedUserProfile != null ? ((avatarMap = FileContentCommand.getFileMap(fetchedUserProfile, "userprofile:avatar")) != null ? avatarMap.getString("digest") : null) : null;
        return digest;
    }

    protected static AvatarInfo getAvatar(String username, boolean checkCache) {
        Document fetchedUserProfile;
        AvatarInfo avatar = avatarMap.get(username);
        if (avatar != null && avatar.isFetched().booleanValue() && checkCache && !StringUtils.equals((String)AvatarUtils.getAvatarDigest(fetchedUserProfile = AvatarUtils.getUserProfile(username, false)), (String)avatar.getDigest())) {
            avatar = null;
        }
        if (avatar == null) {
            AvatarUtils.refreshUserAvatar(username);
            avatar = avatarMap.get(username);
        }
        if (!avatar.isFetched().booleanValue()) {
            AvatarUtils.fillAvatar(username, avatar);
            avatar.setFetched(true);
        }
        return avatar;
    }

    public static AvatarInfo getAvatar(String username) {
        return AvatarUtils.getAvatar(username, false);
    }

    public static String refreshUserAvatar(String username) {
        AvatarInfo avatarInfo = new AvatarInfo();
        avatarMap.put(username, avatarInfo);
        return avatarInfo.getTimeStamp();
    }

    static {
        timeout = TimeUnit.MINUTES.toMillis(10L);
        avatarMap = new ConcurrentHashMap<String, AvatarInfo>();
    }
}

