/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.test.common.service;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.test.common.model.Configuration;
import fr.toutatice.portail.cms.test.common.service.ITestRepository;
import fr.toutatice.portail.cms.test.common.service.ITestService;
import fr.toutatice.portail.cms.test.common.service.TestRepositoryImpl;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.selection.ISelectionService;
import org.osivia.portal.api.selection.SelectionItem;
import org.osivia.portal.api.sequencing.IPortletSequencingService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;

public class TestServiceImpl
implements ITestService {
    private static TestServiceImpl instance;
    private final ITestRepository repository = TestRepositoryImpl.getInstance();
    private final DocumentDAO documentDao = DocumentDAO.getInstance();
    private final ISelectionService selectionService = (ISelectionService)Locator.findMBean(ISelectionService.class, (String)"osivia:service=SelectionService");
    private final IPortletSequencingService portletSequencingService = (IPortletSequencingService)Locator.findMBean(IPortletSequencingService.class, (String)"osivia:service=PortletSequencingService");

    protected TestServiceImpl() {
    }

    public static ITestService getInstance() {
        if (instance == null) {
            instance = new TestServiceImpl();
        }
        return instance;
    }

    public void injectTagsData(PortalControllerContext portalControllerContext, Configuration configuration) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        NuxeoController nuxeoController = new NuxeoController(request, response, portletContext);
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        if (StringUtils.isNotBlank((String)configuration.getPath())) {
            String path = nuxeoController.getComputedPath(configuration.getPath());
            NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)portletContext, (String)path);
            Document nuxeoDocument = documentContext.getDoc();
            DocumentDTO document = this.documentDao.toDTO(nuxeoDocument);
            request.setAttribute("document", (Object)document);
            try {
                CMSPublicationInfos publicationInfos = cmsService.getPublicationInfos(cmsContext, path);
                if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && publicationInfos.isCommentableByUser()) {
                    INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
                    List comments = commentsService.getDocumentComments(cmsContext, nuxeoDocument);
                    document.setCommentable(true);
                    document.getComments().addAll(comments);
                }
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    public void injectAttributesStorageData(PortalControllerContext portalControllerContext, Configuration configuration) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("priority", (Object)window.getProperty("osivia.sequence.priority"));
        request.setAttribute("lastRefresh", (Object)new Date());
        request.setAttribute("storageAttributes", (Object)this.portletSequencingService.getAttributes(portalControllerContext));
    }

    public void addToSelection(PortalControllerContext portalControllerContext, String content) throws PortletException {
        Configuration configuration = this.repository.getConfiguration(portalControllerContext);
        String selectionId = configuration.getSelectionId();
        SelectionItem item = new SelectionItem(UUID.randomUUID().toString(), content, null);
        this.selectionService.addItem(portalControllerContext, selectionId, item);
    }

    public void addToStorage(PortalControllerContext portalControllerContext, String name, String value) throws PortletException {
        this.portletSequencingService.setAttribute(portalControllerContext, name, (Object)value);
    }

    public void removeFromStorage(PortalControllerContext portalControllerContext, String name) throws PortletException {
        this.portletSequencingService.removeAttribute(portalControllerContext, name);
    }
}

