/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.test.common;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.test.common.model.Configuration;
import fr.toutatice.portail.cms.test.common.model.Tab;
import fr.toutatice.portail.cms.test.common.service.ITestRepository;
import fr.toutatice.portail.cms.test.common.service.ITestService;
import fr.toutatice.portail.cms.test.common.service.TestRepositoryImpl;
import fr.toutatice.portail.cms.test.common.service.TestServiceImpl;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;

public class TestPortlet
extends CMSPortlet {
    private static final String PATH_PREFIX = "/WEB-INF/jsp/view-";
    private static final String PATH_SUFFIX = ".jsp";
    private final ITestService service = TestServiceImpl.getInstance();
    private final ITestRepository repository = TestRepositoryImpl.getInstance();

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        Configuration configuration = this.repository.getConfiguration(portalControllerContext);
        request.setAttribute("configuration", (Object)configuration);
        Tab[] tabs = Tab.values();
        request.setAttribute("tabs", (Object)tabs);
        String currentTabId = request.getParameter("currentTabId");
        Tab currentTab = currentTabId != null ? Tab.fromId((String)currentTabId) : configuration.getDefaultTab();
        request.setAttribute("currentTabId", (Object)currentTab.getId());
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(PATH_PREFIX + currentTab.getId() + PATH_SUFFIX);
        if (Tab.TAGS.equals((Object)currentTab)) {
            this.service.injectTagsData(portalControllerContext, configuration);
        }
        if (Tab.ATTRIBUTES_STORAGE.equals((Object)currentTab)) {
            this.service.injectAttributesStorageData(portalControllerContext, configuration);
        }
        response.setContentType("text/html");
        dispatcher.include(request, response);
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        Configuration configuration = this.repository.getConfiguration(portalControllerContext);
        request.setAttribute("configuration", (Object)configuration);
        Tab[] tabs = Tab.values();
        request.setAttribute("tabs", (Object)tabs);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/admin.jsp").include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                Configuration configuration = new Configuration();
                configuration.setDefaultTab(Tab.fromId((String)request.getParameter("defaultTab")));
                configuration.setPath(request.getParameter("path"));
                configuration.setUser(request.getParameter("user"));
                configuration.setSelectionId(request.getParameter("selectionId"));
                this.repository.setConfiguration(portalControllerContext, configuration);
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        } else if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            this.processCommentAction(request, response);
            if ("addToSelection".equals(action)) {
                String content = request.getParameter("content");
                this.service.addToSelection(portalControllerContext, content);
            } else if ("editStorage".equals(action)) {
                if (request.getParameter("add") != null) {
                    String name = request.getParameter("attributeName");
                    String value = request.getParameter("attributeValue");
                    this.service.addToStorage(portalControllerContext, name, value);
                } else if (request.getParameter("remove") != null) {
                    String name = request.getParameter("remove");
                    this.service.removeFromStorage(portalControllerContext, name);
                }
            }
            response.setRenderParameter("tab", StringUtils.trimToEmpty((String)request.getParameter("tab")));
        }
    }
}

