/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.test.common.service;

import fr.toutatice.portail.cms.test.common.model.Configuration;
import fr.toutatice.portail.cms.test.common.model.Tab;
import fr.toutatice.portail.cms.test.common.service.ITestRepository;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class TestRepositoryImpl
implements ITestRepository {
    private static final String DEFAULT_TAB_WINDOW_PROPERTY = "toutatice.test.defaultTab";
    private static final String PATH_WINDOW_PROPERTY = "toutatice.test.path";
    private static final String USER_WINDOW_PROPERTY = "toutatice.test.user";
    private static final String SELECTION_ID_WINDOW_PROPERTY = "toutatice.test.selectionId";
    private static ITestRepository instance;

    protected TestRepositoryImpl() {
    }

    public static ITestRepository getInstance() {
        if (instance == null) {
            instance = new TestRepositoryImpl();
        }
        return instance;
    }

    public Configuration getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        Configuration configuration = new Configuration();
        configuration.setDefaultTab(Tab.fromId((String)window.getProperty(DEFAULT_TAB_WINDOW_PROPERTY)));
        configuration.setPath(window.getProperty(PATH_WINDOW_PROPERTY));
        configuration.setUser(window.getProperty(USER_WINDOW_PROPERTY));
        configuration.setSelectionId(window.getProperty(SELECTION_ID_WINDOW_PROPERTY));
        return configuration;
    }

    public void setConfiguration(PortalControllerContext portalControllerContext, Configuration configuration) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        window.setProperty(DEFAULT_TAB_WINDOW_PROPERTY, configuration.getDefaultTab().getId());
        window.setProperty(PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)configuration.getPath()));
        window.setProperty(USER_WINDOW_PROPERTY, StringUtils.trimToNull((String)configuration.getUser()));
        window.setProperty(SELECTION_ID_WINDOW_PROPERTY, StringUtils.trimToNull((String)configuration.getSelectionId()));
    }
}

