/*
 * Decompiled with CFR 0.152.
 */
package fr.edu.lyon.nuxeo.restAPI;

import fr.edu.lyon.nuxeo.linker.api.FieldLinkService;
import fr.edu.lyon.nuxeo.restAPI.DatasetResultSummary;
import fr.edu.lyon.nuxeo.serializer.SerializerHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class DatasetRestlet
extends BaseStatelessNuxeoRestlet {
    private static final Log log = LogFactory.getLog(DatasetRestlet.class);
    private static final String defaultColumns = "dc:title,dc:description,dc:creator,url,dc:created,dc:modified,dc:nature,dc:subjects";
    public static final String START_RESULT_PARAM = "startItem";
    public static final String PAGESIZE_PARAM = "pageSize";
    public static final String ALLPAGE_PARAM = "pagerAll";
    protected static final String SORT_PARAM_COLOMN = "sort";
    protected static final String SORT_PARAM_ASCENDING = "ascending";
    protected static final String FILTER_PARAM_PREFIX = "filter";
    public static final String SEARCH_RESTLET = "search";
    public static final String VIEW_RESTLET = "view";
    private static PageProviderService ppService;
    int start = 0;
    int pagesize = 10;
    boolean pagerAll = false;
    protected DatasetResultSummary summary;
    protected String sortColomn;
    protected boolean sortAscending = false;
    protected JSONObject filters;
    protected CoreSession session;
    private FieldLinkService fieldLinkService;
    private SchemaManager schemaManager;

    protected String getDefaultColumns() {
        return defaultColumns;
    }

    private SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            this.schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        }
        return this.schemaManager;
    }

    private void initPaginationParameters(Request req) {
        try {
            String startValue = req.getResourceRef().getQueryAsForm().getFirstValue(START_RESULT_PARAM);
            if (startValue != null) {
                this.start = Integer.parseInt(startValue);
            }
        }
        catch (Exception startValue) {
            // empty catch block
        }
        try {
            String pagesizeValue = req.getResourceRef().getQueryAsForm().getFirstValue(PAGESIZE_PARAM);
            if (pagesizeValue != null) {
                this.pagesize = Integer.parseInt(pagesizeValue);
            }
        }
        catch (Exception pagesizeValue) {
            // empty catch block
        }
        try {
            String pagerAllValue = req.getResourceRef().getQueryAsForm().getFirstValue(ALLPAGE_PARAM);
            if (pagerAllValue != null) {
                this.pagerAll = Boolean.parseBoolean(pagerAllValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected PageProviderService getPageProviderService(DOMDocument result, Response res) {
        if (ppService == null) {
            try {
                ppService = (PageProviderService)Framework.getService(PageProviderService.class);
                if (ppService == null) {
                    DatasetRestlet.handleError((DOMDocument)result, (Response)res, (String)"Impossible d'obtenir le service de PageProviders");
                    return null;
                }
            }
            catch (Exception e) {
                DatasetRestlet.handleError((DOMDocument)result, (Response)res, (Exception)e);
                return null;
            }
        }
        return ppService;
    }

    protected String getPageProviderName(Request req) {
        return (String)req.getAttributes().get("PPName");
    }

    protected CoreSession getCoreSession(Request req, Response res, String repoName) {
        try {
            Repository repository = repoName == null ? ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository() : ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepository(repoName);
            if (repository == null) {
                throw new ClientException("Cannot get repository");
            }
            HashMap<String, Serializable> context = new HashMap<String, Serializable>();
            context.put("principal", DatasetRestlet.getSerializablePrincipal((Request)req));
            return repository.open(context);
        }
        catch (Exception e) {
            DatasetRestlet.handleError((Response)res, (Exception)e);
            return null;
        }
    }

    protected DocumentModel getFilter() {
        DocumentModelImpl dm = DocumentModelFactory.createDocumentModel((String)"AdvancedSearch");
        if (this.filters != null) {
            try {
                JSONArray criterias = this.filters.getJSONArray("criterias");
                int i = 0;
                while (i < criterias.length()) {
                    Object value;
                    JSONObject criteria = criterias.getJSONObject(i);
                    String xpath = criteria.getString("field");
                    String schemaName = null;
                    String fieldName = null;
                    boolean simpleType = true;
                    if (xpath.contains(":")) {
                        String[] parts = xpath.split("\\:");
                        Schema schema = this.getSchemaManager().getSchemaFromPrefix(parts[0]);
                        if (schema == null) {
                            schema = this.getSchemaManager().getSchema(parts[0]);
                        }
                        if (schema != null) {
                            fieldName = parts[1];
                            schemaName = schema.getName();
                            Field field = schema.getField(fieldName);
                            if (field != null) {
                                simpleType = field.getType().isSimpleType();
                            }
                        }
                    }
                    if (criteria.get("value") instanceof JSONArray) {
                        JSONArray jvalues = criteria.getJSONArray("value");
                        String[] tmpValues = new String[jvalues.length()];
                        int v = 0;
                        while (v < jvalues.length()) {
                            tmpValues[v] = schemaName != null ? this.getFieldLinkService().getPathValue(this.session, schemaName, fieldName, jvalues.getString(v)) : jvalues.getString(v);
                            ++v;
                        }
                        if (simpleType) {
                            if (tmpValues.length > 0) {
                                value = tmpValues[0];
                                log.warn((Object)("Seule la premi\u00e8re valeur pass\u00e9e (" + value + ") sera prise en compte pour le filtre " + xpath));
                            } else {
                                value = "";
                            }
                        } else {
                            value = tmpValues;
                        }
                    } else {
                        value = this.getFieldLinkService().getPathValue(this.session, schemaName, fieldName, criteria.getString("value"));
                        if (!simpleType) {
                            String[] values = new String[]{(String)value};
                            value = values;
                        }
                    }
                    try {
                        dm.setProperty(schemaName, fieldName, value);
                    }
                    catch (Exception e) {
                        log.warn((Object)("erreur lors du traitement du filtre " + xpath));
                    }
                    ++i;
                }
            }
            catch (JSONException e) {
                log.warn((Object)e.getMessage());
            }
        }
        return dm;
    }

    private DocumentModelList handleSearch(DOMDocument result, Request req, Response res) throws ClientException {
        PageProvider pageProvider;
        this.initPaginationParameters(req);
        PageProviderService ppService = this.getPageProviderService(result, res);
        if (ppService == null) {
            throw new ClientException("Impossible d'acc\u00e9der au Service PageProvider");
        }
        String ppName = this.getPageProviderName(req);
        this.summary.setTitle("R\u00e9sultat de la recherche " + ppName);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        Object[] parameters = null;
        List<Object> strParams = this.extractQueryParameters(req);
        if (strParams != null && !strParams.isEmpty()) {
            parameters = strParams.toArray();
        }
        if ((pageProvider = ppService.getPageProvider(ppName, null, null, null, props, parameters)) == null) {
            String message = "Impossible de trouver le PageProvider " + ppName;
            DatasetRestlet.handleError((DOMDocument)result, (Response)res, (String)message);
            throw new ClientException(message);
        }
        pageProvider.setSearchDocumentModel(this.getFilter());
        if (this.sortColomn != null) {
            pageProvider.setSortInfo(new SortInfo(this.sortColomn, this.sortAscending));
        }
        pageProvider.setPageSize((long)(this.pagerAll ? 0 : this.pagesize));
        int page = this.pagerAll ? 0 : new Double(this.start / this.pagesize).intValue();
        List docs = pageProvider.setCurrentPage((long)page);
        this.summary.setPages((int)pageProvider.getNumberOfPages());
        this.summary.setPageNumber(page);
        this.summary.setTotal(pageProvider.getResultsCount());
        this.summary.setPageSize(this.pagesize);
        this.summary.setStart(this.start);
        this.summary.setDescription("R\u00e9sultat de la recherche " + ppName + ". Nombre de documents trouv\u00e9s : " + this.summary.getTotal());
        return new DocumentModelListImpl(docs);
    }

    private DocumentModelList handleView(DOMDocument result, Request req, Response res) throws ClientException {
        String docid = (String)req.getAttributes().get("docid");
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(docid));
        DocumentModelListImpl dmList = new DocumentModelListImpl();
        dmList.add((Object)doc);
        return dmList;
    }

    public void handle(Request req, Response res) {
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        this.summary = new DatasetResultSummary();
        String searchOrView = (String)req.getResourceRef().getSegments().get(3);
        this.session = this.getCoreSession(req, res, null);
        DocumentModelList dmList = null;
        try {
            try {
                dmList = SEARCH_RESTLET.equals(searchOrView) ? this.handleSearch(result, req, res) : this.handleView(result, req, res);
                String columnsDefinition = req.getResourceRef().getQueryAsForm().getFirstValue("columns");
                if (columnsDefinition == null) {
                    columnsDefinition = this.getDefaultColumns();
                }
                this.summary.setAuthor(DatasetRestlet.getUserPrincipal((Request)req).getName());
                this.summary.setModificationDate(new Date());
                this.summary.setLink(VirtualHostHelper.getBaseURL((ServletRequest)DatasetRestlet.getHttpRequest((Request)req)));
                SerializerHelper.formatResult(this.session, this.summary, dmList, res, columnsDefinition, DatasetRestlet.getHttpRequest((Request)req));
            }
            catch (Exception e) {
                DatasetRestlet.handleError((Response)res, (Exception)e);
                try {
                    Repository.close((CoreSession)this.session);
                }
                catch (Exception e2) {
                    log.error((Object)"Repository close failed", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                Repository.close((CoreSession)this.session);
            }
            catch (Exception e) {
                log.error((Object)"Repository close failed", (Throwable)e);
            }
        }
    }

    protected String getDomainPath(Request req) {
        String domain = req.getResourceRef().getQueryAsForm().getFirstValue("domain");
        if (domain == null) {
            domain = "/default-domain/";
        } else if (domain.equals("*")) {
            domain = "/";
        } else {
            if (!domain.startsWith("/")) {
                domain = "/" + domain;
            }
            if (!domain.endsWith("/")) {
                domain = String.valueOf(domain) + "/";
            }
        }
        return domain;
    }

    protected List<Object> extractQueryParameters(Request req) {
        Form form = req.getResourceRef().getQueryAsForm();
        ArrayList rp = new ArrayList(form.getNames());
        Collections.sort(rp);
        for (String k : rp) {
            if (k.startsWith(SORT_PARAM_COLOMN)) {
                this.sortColomn = form.getFirstValue(k);
            }
            if (k.startsWith(SORT_PARAM_ASCENDING)) {
                String param = form.getFirstValue(k);
                if ("true".equalsIgnoreCase(param) || "1".equals(param)) {
                    this.sortAscending = true;
                } else if ("false".equalsIgnoreCase(param) || "0".equals(param)) {
                    this.sortAscending = false;
                }
            }
            if (!k.startsWith(FILTER_PARAM_PREFIX)) continue;
            try {
                this.filters = new JSONObject(form.getFirstValue(k));
            }
            catch (JSONException e) {
                log.warn((Object)"Filtre pass\u00e9 incorrect : json attendu");
            }
        }
        String ppName = this.getPageProviderName(req);
        ArrayList<Object> qp = new ArrayList<Object>();
        if ("USER_DOCUMENTS".equals(ppName)) {
            qp.add(0, DatasetRestlet.getUserPrincipal((Request)req).getName());
            qp.add(1, this.getDomainPath(req));
        } else if ("USER_DELETED_DOCUMENTS".equals(ppName)) {
            qp.add(0, DatasetRestlet.getUserPrincipal((Request)req).getName());
        } else if ("USER_WORKSPACES".equals(ppName)) {
            qp.add(0, this.getDomainPath(req));
            qp.add(1, String.valueOf(this.getDomainPath(req)) + "templates");
            qp.add(2, String.valueOf(this.getDomainPath(req)) + "UserWorkspaces");
        } else if ("USER_SITES".equals(ppName)) {
            qp.add(0, this.getDomainPath(req));
            qp.add(1, String.valueOf(this.getDomainPath(req)) + "templates");
        } else if (!"DOMAIN_PUBLISHED_DOCUMENTS".equals(ppName)) {
            if ("DOMAIN_DOCUMENTS".equals(ppName)) {
                qp.add(0, this.getDomainPath(req));
                qp.add(1, String.valueOf(this.getDomainPath(req)) + "templates");
            } else if ("USER_SECTIONS".equals(ppName)) {
                qp.add(0, this.getDomainPath(req));
            }
        }
        return qp;
    }

    private FieldLinkService getFieldLinkService() {
        if (this.fieldLinkService == null) {
            try {
                this.fieldLinkService = (FieldLinkService)Framework.getService(FieldLinkService.class);
            }
            catch (Exception e) {
                log.error((Object)"FieldLink Service injoignable");
            }
        }
        return this.fieldLinkService;
    }
}

