/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.portal.identity.db;

import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.IdentityServiceController;
import org.jboss.portal.identity.IdentityContext;
import org.jboss.portal.identity.event.IdentityEventBroadcaster;
import org.jboss.portal.identity.event.RoleUpdatedEvent;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import java.util.Set;
import java.util.HashSet;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet </a>
 * @author <a href="mailto:theute@jboss.org">Thomas Heute </a>
 * @author Roy Russo : roy at jboss dot org
 * @author <a href="mailto:boleslaw dot dawidowicz at jboss.org">Boleslaw Dawidowicz</a>
 * @version $Revision: 5448 $
 */
public class HibernateRoleImpl
   implements Role
{

   /** . */
   private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(HibernateRoleImpl.class);

   private Long key;
   private String name;
   private Set users;
   private String displayName;
   private IdentityEventBroadcaster eventBroadcaster;

   /**
    *
    */
   public HibernateRoleImpl()
   {
      this.key = null;
      this.name = null;
      this.displayName = null;
      this.users = new HashSet();
   }

   /**
    *
    */
   public HibernateRoleImpl(String name)
   {
      this.key = null;
      this.name = name;
      this.displayName = name;
      this.users = new HashSet();
   }

   /**
    *
    */
   public HibernateRoleImpl(String name, String displayName)
   {
      this.key = null;
      this.name = name;
      this.displayName = displayName;
      this.users = new HashSet();
   }

   /**
    * @hibernate.id column="jbp_rid" generator-class="native"
    * <p/>
    * Called by hibernate.
    */
   protected Long getKey()
   {
      return key;
   }

   /** Called by hibernate. */
   protected void setKey(Long key)
   {
      this.key = key;
   }

   /** Called by hibernate. */
   protected void setName(String name)
   {
      this.name = name;
   }

   /** Called by hibernate. */
   protected void setUsers(Set users)
   {
      this.users = users;
   }

   // ******************************************************************************************************************

   public Object getId()
   {
      return key;
   }

   /**
    *
    */
   public String getName()
   {
      return name;
   }

   /**
    *
    */
   public String getDisplayName()
   {
      return displayName;
   }

   /**
    *
    */
   public void setDisplayName(String displayName)
   {
      this.displayName = displayName;

      IdentityEventBroadcaster broadcaster = getEventBroadcaster();

      if (broadcaster != null)
      {
         // This can be called on object creation by hibernate so make sure that all fields are populated first
         if (getId() != null && getName() != null && getDisplayName() != null)
         {
            RoleUpdatedEvent event = new RoleUpdatedEvent(getId(), getName(), displayName);
            broadcaster.fireEvent(event);
         }

      }
   }

   /**
    *
    */
   public Set getUsers()
   {
      return users;
   }

   public String toString()
   {
      return "Role[" + key + "," + name + "]";
   }

   private IdentityEventBroadcaster getEventBroadcaster()
   {
      if (eventBroadcaster == null)
      {

         try
         {
            MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
            IdentityServiceController identityService = (IdentityServiceController)MBeanProxy.get(
               IdentityServiceController.class, new ObjectName("portal:service=Module,type=IdentityServiceController"), mbeanServer);

            eventBroadcaster = (IdentityEventBroadcaster)identityService.getIdentityContext().getObject(IdentityContext.TYPE_IDENTITY_EVENT_BROADCASTER);
         }
         catch (Exception e)
         {
            log.error("Failed to obtain IdentityEventBroadcaster. RoleUpdatedEvent won't be broadcasted");
         }
      }
      
      return eventBroadcaster;
   }
}
