/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.repository.AbstractRepositoryTestCase;
import org.nuxeo.ecm.platform.annotations.service.DummyDocumentEventListener;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;

public class AnnotatedEventListenerTest
extends AbstractRepositoryTestCase {
    private static final String HTTP_LOCALHOST_8080_NUXEO = "http://localhost:8080/nuxeo";

    @Test
    public void testEventLister() throws Exception {
        DummyDocumentEventListener.resetTest();
        Assert.assertNotNull((Object)this.annotation);
        UserPrincipal user = new UserPrincipal("bob", new ArrayList(), false, false);
        Annotation createdAnnotation = this.service.addAnnotation(this.annotation, (NuxeoPrincipal)user, HTTP_LOCALHOST_8080_NUXEO);
        Assert.assertNotNull((Object)createdAnnotation);
        int result = DummyDocumentEventListener.getTest();
        Assert.assertEquals((long)Integer.parseInt("11", 2), (long)result);
        StatementImpl statement = new StatementImpl((Node)createdAnnotation.getSubject(), (Node)new ResourceImpl("http://www.w3.org/2000/10/annotation-ns#body"), (Node)new LiteralImpl("My new body"));
        createdAnnotation.setBody((Statement)statement);
        this.service.updateAnnotation(createdAnnotation, (NuxeoPrincipal)user, HTTP_LOCALHOST_8080_NUXEO);
        result = DummyDocumentEventListener.getTest();
        Assert.assertEquals((long)Integer.parseInt("110011", 2), (long)result);
        createdAnnotation = this.service.getAnnotation(createdAnnotation.getId(), (NuxeoPrincipal)user, HTTP_LOCALHOST_8080_NUXEO);
        result = DummyDocumentEventListener.getTest();
        Assert.assertEquals((long)Integer.parseInt("111111", 2), (long)result);
        this.service.deleteAnnotation(createdAnnotation, (NuxeoPrincipal)user);
        result = DummyDocumentEventListener.getTest();
        Assert.assertEquals((long)Integer.parseInt("11111111", 2), (long)result);
    }
}

