/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers;

import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;
import org.nuxeo.ecm.automation.client.model.RecordSet;

public class RecordSetMarshaller
implements JsonMarshaller<RecordSet> {
    @Override
    public String getType() {
        return "recordSet";
    }

    @Override
    public Class<RecordSet> getJavaType() {
        return RecordSet.class;
    }

    @Override
    public RecordSet read(JsonParser jp) throws Exception {
        jp.nextToken();
        String key = jp.getCurrentName();
        if ("isPaginable".equals(key)) {
            jp.nextToken();
            boolean isPaginable = jp.getBooleanValue();
            if (isPaginable) {
                jp.nextToken();
                return this.readPaginableRecordSet(jp);
            }
        }
        return this.readRecord(jp);
    }

    protected RecordSet readPaginableRecordSet(JsonParser jp) throws Exception {
        RecordSet record = new RecordSet();
        JsonToken tok = jp.getCurrentToken();
        while (tok != null && tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("pageSize".equals(key)) {
                record.setPageSize(jp.getIntValue());
            } else if ("numberOfPages".equals(key)) {
                record.setNumberOfPages(jp.getIntValue());
            } else if ("currentPageIndex".equals(key)) {
                record.setCurrentPageIndex(jp.getIntValue());
            } else if ("entries".equals(key)) {
                this.readRecordEntries(jp, record);
            }
            tok = jp.nextToken();
        }
        if (tok == null) {
            throw new IllegalArgumentException("Unexpected end of stream.");
        }
        return record;
    }

    protected RecordSet readRecord(JsonParser jp) throws Exception {
        RecordSet record = new RecordSet();
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_ARRAY) {
            String key = jp.getCurrentName();
            if ("entries".equals(key)) {
                this.readRecordEntries(jp, record);
                return record;
            }
            tok = jp.nextToken();
        }
        return record;
    }

    protected void readRecordEntries(JsonParser jp, RecordSet record) throws Exception {
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_ARRAY) {
            Map entry = (Map)jp.readValueAs(Map.class);
            record.add(entry);
            tok = jp.nextToken();
        }
    }

    @Override
    public void write(JsonGenerator jg, Object value) throws Exception {
    }
}

