/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.rest.api;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.nuxeo.ecm.automation.client.AutomationException;

public class RestResponse {
    protected final ClientResponse clientResponse;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected JsonNode responseAsJson;

    public RestResponse(ClientResponse clientResponse) {
        this.clientResponse = clientResponse;
    }

    public ClientResponse getClientResponse() {
        return this.clientResponse;
    }

    public int getStatus() {
        return this.clientResponse.getStatus();
    }

    public JsonNode asJson() {
        this.computeResponseAsJson();
        return this.responseAsJson;
    }

    protected void computeResponseAsJson() {
        if (this.responseAsJson == null) {
            try {
                this.responseAsJson = this.objectMapper.readTree(this.clientResponse.getEntityInputStream());
            }
            catch (IOException e) {
                throw new AutomationException(e);
            }
        }
    }

    public Map<String, Object> asMap() {
        this.computeResponseAsJson();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)this.objectMapper.readValue(this.responseAsJson, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new AutomationException(e);
        }
    }
}

