/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.wizard.context.Context;
import org.nuxeo.wizard.context.ParamCollector;
import org.nuxeo.wizard.download.DownloadablePackageOptions;
import org.nuxeo.wizard.download.PackageDownloader;
import org.nuxeo.wizard.helpers.ConnectRegistrationHelper;
import org.nuxeo.wizard.helpers.IPValidator;
import org.nuxeo.wizard.helpers.NumberValidator;
import org.nuxeo.wizard.helpers.PackageDownloaderHelper;
import org.nuxeo.wizard.nav.Page;
import org.nuxeo.wizard.nav.SimpleNavigationHandler;

public class RouterServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(RouterServlet.class);
    protected SimpleNavigationHandler navHandler = SimpleNavigationHandler.instance();
    public static final String CONNECT_TOKEN_KEY = "ConnectRegistrationToken";

    protected String getAction(HttpServletRequest req) {
        String action;
        String uri = req.getRequestURI();
        int idx = uri.indexOf("?");
        if (idx > 0) {
            uri = uri.substring(0, idx - 1);
        }
        if ((action = uri.replace(req.getContextPath() + "/router/", "")).startsWith("/")) {
            action = action.substring(1);
        }
        return action;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleAction(this.getAction(req), req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context.instance((HttpServletRequest)req).getCollector().collectConfigurationParams(req);
        this.doGet(req, resp);
    }

    protected Method findhandler(Page currentPage, String verb) {
        String methodName = "handle" + currentPage.getAction() + verb;
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, Page.class, HttpServletRequest.class, HttpServletResponse.class);
        }
        catch (Exception e) {
            methodName = "handleDefault" + verb;
            try {
                method = this.getClass().getMethod(methodName, Page.class, HttpServletRequest.class, HttpServletResponse.class);
            }
            catch (Exception e2) {
                log.error((Object)("Unable to resolve default handler for " + verb), (Throwable)e);
            }
        }
        return method;
    }

    protected void handleAction(String action, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Page currentPage = this.navHandler.getCurrentPage(action);
        if (currentPage == null) {
            resp.sendError(404, "Action " + action + " is not supported");
            return;
        }
        Method handler = this.findhandler(currentPage, req.getMethod());
        if (handler == null) {
            resp.sendError(500, "No handler found for " + action);
            return;
        }
        try {
            handler.invoke((Object)this, currentPage, req, resp);
        }
        catch (Exception e) {
            log.error((Object)"Error during handler execution", (Throwable)e);
            req.setAttribute("error", (Object)e);
            req.getRequestDispatcher("/error.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public void handleDefaultGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        currentPage.dispatchToJSP(req, resp);
    }

    public void handleDefaultPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        currentPage.next().dispatchToJSP(req, resp, true);
    }

    public void handleConnectGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context ctx = Context.instance((HttpServletRequest)req);
        String cbUrl = req.getRequestURL().toString();
        cbUrl = cbUrl.replace("/router/" + currentPage.getAction(), "/ConnectCallback?cb=yes");
        if (ctx.getBaseUrl() != null) {
            cbUrl = ctx.getBaseUrl() + "ConnectCallback?cb=yes";
        }
        cbUrl = URLEncoder.encode(cbUrl, "UTF-8");
        req.setAttribute("callBackUrl", (Object)cbUrl);
        this.handleDefaultGET(currentPage, req, resp);
    }

    public void handleConnectCallbackGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String token = req.getParameter(CONNECT_TOKEN_KEY);
        String action = req.getParameter("action");
        String targetNav = null;
        if (action == null || action.isEmpty()) {
            action = "skip";
        }
        if (action.equals("register") && (token == null || token.isEmpty())) {
            action = "skip";
        }
        if ("register".equals(action)) {
            HashMap<String, String> connectMap = new HashMap<String, String>();
            Context context = Context.instance((HttpServletRequest)req);
            if (token != null) {
                String[] tokenDataLines;
                String tokenData = new String(Base64.decodeBase64((String)token));
                for (String line : tokenDataLines = tokenData.split("\n")) {
                    String[] parts = line.split(":");
                    if (parts.length <= 1) continue;
                    connectMap.put(parts[0], parts[1]);
                }
                context.storeConnectMap(connectMap);
            }
            if (context.isConnectRegistrationDone()) {
                ConnectRegistrationHelper.saveConnectRegistrationFile((Context)context);
            }
            SimpleNavigationHandler.instance().deactivatePage("ConnectFinish");
            targetNav = currentPage.next().getAction();
        } else if ("skip".equals(action)) {
            SimpleNavigationHandler.instance().activatePage("ConnectFinish");
            targetNav = currentPage.next().getAction();
        } else if ("prev".equals(action)) {
            targetNav = currentPage.prev().prev().getAction();
        }
        String targetUrl = req.getContextPath() + "/" + targetNav;
        req.setAttribute("targetUrl", (Object)targetUrl);
        this.handleDefaultGET(currentPage, req, resp);
    }

    public void handleConnectFinishGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String token = req.getParameter(CONNECT_TOKEN_KEY);
        HashMap<String, String> connectMap = new HashMap<String, String>();
        if (token != null) {
            String[] tokenDataLines;
            String tokenData = new String(Base64.decodeBase64((String)token));
            for (String line : tokenDataLines = tokenData.split("\n")) {
                String[] parts = line.split(":");
                if (parts.length <= 1) continue;
                connectMap.put(parts[0], parts[1]);
            }
            Context.instance((HttpServletRequest)req).storeConnectMap(connectMap);
        }
        this.handleDefaultGET(currentPage, req, resp);
    }

    public void handleDBPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context ctx = Context.instance((HttpServletRequest)req);
        ParamCollector collector = ctx.getCollector();
        if ("true".equals(req.getParameter("refresh"))) {
            String templateName = collector.getConfigurationParam("nuxeo.dbtemplate");
            collector.changeDBTemplate(templateName);
            currentPage.dispatchToJSP(req, resp);
            return;
        }
        if (!collector.getConfigurationParam("nuxeo.dbtemplate").equals("default")) {
            if (collector.getConfigurationParam("nuxeo.db.name").isEmpty()) {
                ctx.trackError("nuxeo.db.name", "error.dbname.required");
            }
            if (collector.getConfigurationParam("nuxeo.db.user").isEmpty()) {
                ctx.trackError("nuxeo.db.user", "error.dbuser.required");
            }
            if (collector.getConfigurationParam("nuxeo.db.password").isEmpty()) {
                ctx.trackError("nuxeo.db.password", "error.dbpassword.required");
            }
            if (collector.getConfigurationParam("nuxeo.db.host").isEmpty()) {
                ctx.trackError("nuxeo.db.host", "error.dbhost.required");
            }
            if (collector.getConfigurationParam("nuxeo.db.port").isEmpty()) {
                ctx.trackError("nuxeo.db.port", "error.dbport.required");
            } else if (!NumberValidator.validate((String)collector.getConfigurationParam("nuxeo.db.port"))) {
                ctx.trackError("nuxeo.db.port", "error.invalid.port");
            } else {
                int dbPort = Integer.parseInt(collector.getConfigurationParam("nuxeo.db.port"));
                if (dbPort < 1024 || dbPort > 65536) {
                    ctx.trackError("nuxeo.db.port", "error.invalid.port");
                }
            }
            ConfigurationGenerator cg = collector.getConfigurationGenerator();
            try {
                cg.checkDatabaseConnection(collector.getConfigurationParam("nuxeo.dbtemplate"), collector.getConfigurationParam("nuxeo.db.name"), collector.getConfigurationParam("nuxeo.db.user"), collector.getConfigurationParam("nuxeo.db.password"), collector.getConfigurationParam("nuxeo.db.host"), collector.getConfigurationParam("nuxeo.db.port"));
            }
            catch (DatabaseDriverException e) {
                ctx.trackError("nuxeo.db.name", "error.db.driver.notfound");
                log.warn((Object)e);
            }
            catch (SQLException e) {
                ctx.trackError("nuxeo.db.name", "error.db.connection");
                log.warn((Object)e);
            }
        }
        if (ctx.hasErrors()) {
            currentPage.dispatchToJSP(req, resp);
        } else {
            currentPage.next().dispatchToJSP(req, resp, true);
        }
    }

    public void handleUserPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String directoryType;
        String refreshParam;
        ParamCollector collector;
        Context ctx;
        block36: {
            ctx = Context.instance((HttpServletRequest)req);
            collector = ctx.getCollector();
            refreshParam = req.getParameter("refresh");
            directoryType = collector.getConfigurationParam("nuxeo.directory.type");
            if ("true".equals(refreshParam)) {
                currentPage.dispatchToJSP(req, resp);
                return;
            }
            if ("checkNetwork".equals(refreshParam) || "checkAuth".equals(refreshParam) || "checkUserLdapParam".equals(refreshParam) || "checkGroupLdapParam".equals(refreshParam)) {
                try {
                    String searchFilter;
                    String searchClass;
                    String searchScope;
                    String searchBaseDn;
                    if ("checkNetwork".equals(refreshParam)) {
                        this.bindLdapConnection(collector, false);
                        ctx.trackInfo("nuxeo.ldap.url", "info.host.found");
                        break block36;
                    }
                    if ("checkAuth".equals(refreshParam)) {
                        this.bindLdapConnection(collector, true);
                        ctx.trackInfo("nuxeo.ldap.auth", "info.auth.success");
                        break block36;
                    }
                    InitialDirContext dirContext = new InitialDirContext(this.getContextEnv(collector, true));
                    if ("checkUserLdapParam".equals(refreshParam)) {
                        searchBaseDn = collector.getConfigurationParam("nuxeo.ldap.user.searchBaseDn");
                        searchScope = collector.getConfigurationParam("nuxeo.ldap.user.searchScope");
                        searchClass = collector.getConfigurationParam("nuxeo.ldap.user.searchClass");
                        searchFilter = collector.getConfigurationParam("nuxeo.ldap.user.searchFilter");
                    } else {
                        searchBaseDn = collector.getConfigurationParam("nuxeo.ldap.group.searchBaseDn");
                        searchScope = collector.getConfigurationParam("nuxeo.ldap.group.searchScope");
                        searchFilter = collector.getConfigurationParam("nuxeo.ldap.group.searchFilter");
                        searchClass = "";
                    }
                    SearchControls scts = new SearchControls();
                    if ("onelevel".equals(searchScope)) {
                        scts.setSearchScope(1);
                    } else {
                        scts.setSearchScope(2);
                    }
                    String filter = String.format("(&(%s)(objectClass=%s))", searchFilter.isEmpty() ? "objectClass=*" : searchFilter, searchClass.isEmpty() ? "*" : searchClass);
                    try {
                        NamingEnumeration<SearchResult> results = dirContext.search(searchBaseDn, filter, scts);
                        if (!results.hasMore()) {
                            ctx.trackError("nuxeo.ldap.search", "error.ldap.noresult");
                        } else {
                            SearchResult result = results.next();
                            if (searchBaseDn.equalsIgnoreCase(result.getNameInNamespace()) && results.hasMore()) {
                                result = results.next();
                            }
                            ctx.trackInfo("dn", result.getNameInNamespace());
                            Attributes attributes = result.getAttributes();
                            NamingEnumeration<String> ids = attributes.getIDs();
                            while (ids.hasMore()) {
                                String id = ids.next();
                                NamingEnumeration<?> values = attributes.get(id).getAll();
                                StringBuilder sb = new StringBuilder();
                                while (values.hasMore()) {
                                    sb.append(values.next()).append(" , ");
                                }
                                ctx.trackInfo(id, sb.substring(0, sb.length() - 3));
                            }
                        }
                    }
                    catch (NameNotFoundException e) {
                        ctx.trackError("nuxeo.ldap.search", "error.ldap.searchBaseDn");
                        log.warn((Object)e);
                    }
                    dirContext.close();
                }
                catch (AuthenticationException e) {
                    ctx.trackError("nuxeo.ldap.auth", "error.auth.failed");
                    log.warn((Object)e);
                }
                catch (NamingException e) {
                    ctx.trackError("nuxeo.ldap.url", "error.host.not.found");
                    log.warn((Object)e);
                }
            }
        }
        if (!"default".equals(directoryType) && refreshParam.isEmpty()) {
            String userGroupStorage;
            try {
                this.bindLdapConnection(collector, true);
            }
            catch (NamingException e) {
                ctx.trackError("nuxeo.ldap.auth", "error.ldap.bind.failed");
                log.warn((Object)e);
            }
            if (collector.getConfigurationParam("nuxeo.ldap.user.searchBaseDn").isEmpty()) {
                ctx.trackError("nuxeo.ldap.user.searchBaseDn", "error.user.searchBaseDn.required");
            }
            if (collector.getConfigurationParam("nuxeo.ldap.user.mapping.rdn").isEmpty()) {
                ctx.trackError("nuxeo.ldap.user.mapping.rdn", "error.user.rdn.required");
            }
            if (collector.getConfigurationParam("nuxeo.ldap.user.mapping.username").isEmpty()) {
                ctx.trackError("nuxeo.ldap.user.mapping.username", "error.user.username.required");
            }
            if (collector.getConfigurationParam("nuxeo.ldap.user.mapping.password").isEmpty()) {
                ctx.trackError("nuxeo.ldap.user.mapping.password", "error.user.password.required");
            }
            if (collector.getConfigurationParam("nuxeo.ldap.user.mapping.firstname").isEmpty()) {
                ctx.trackError("nuxeo.ldap.user.mapping.firstname", "error.user.firstname.required");
            }
            if (collector.getConfigurationParam("nuxeo.ldap.user.mapping.lastname").isEmpty()) {
                ctx.trackError("nuxeo.ldap.user.mapping.lastname", "error.user.lastname.required");
            }
            if (!"userLdapOnly".equals(userGroupStorage = collector.getConfigurationParam("nuxeo.user.group.storage")) && !"multiUserSqlGroup".equals(userGroupStorage)) {
                if (collector.getConfigurationParam("nuxeo.ldap.group.searchBaseDn").isEmpty()) {
                    ctx.trackError("nuxeo.ldap.group.searchBaseDn", "error.group.searchBaseDn.required");
                }
                if (collector.getConfigurationParam("nuxeo.ldap.group.mapping.rdn").isEmpty()) {
                    ctx.trackError("nuxeo.ldap.group.mapping.rdn", "error.group.rdn.required");
                }
                if (collector.getConfigurationParam("nuxeo.ldap.group.mapping.name").isEmpty()) {
                    ctx.trackError("nuxeo.ldap.group.mapping.name", "error.group.name.required");
                }
            }
            if ("true".equals(collector.getConfigurationParam("nuxeo.user.emergency.enable"))) {
                if (collector.getConfigurationParam("nuxeo.user.emergency.username").isEmpty()) {
                    ctx.trackError("nuxeo.user.emergency.username", "error.emergency.username.required");
                }
                if (collector.getConfigurationParam("nuxeo.user.emergency.password").isEmpty()) {
                    ctx.trackError("nuxeo.user.emergency.password", "error.emergency.password.required");
                }
            }
        }
        if (ctx.hasErrors() || ctx.hasInfos()) {
            currentPage.dispatchToJSP(req, resp);
        } else {
            currentPage.next().dispatchToJSP(req, resp, true);
        }
    }

    private Hashtable<Object, Object> getContextEnv(ParamCollector collector, boolean checkAuth) {
        String ldapUrl = collector.getConfigurationParam("nuxeo.ldap.url");
        String ldapBindDn = collector.getConfigurationParam("nuxeo.ldap.binddn");
        String ldapBindPassword = collector.getConfigurationParam("nuxeo.ldap.bindpassword");
        ConfigurationGenerator cg = collector.getConfigurationGenerator();
        return cg.getContextEnv(ldapUrl, ldapBindDn, ldapBindPassword, checkAuth);
    }

    private void bindLdapConnection(ParamCollector collector, boolean authenticate) throws NamingException {
        ConfigurationGenerator cg = collector.getConfigurationGenerator();
        cg.checkLdapConnection(this.getContextEnv(collector, authenticate));
    }

    public void handleSmtpPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context ctx = Context.instance((HttpServletRequest)req);
        ParamCollector collector = ctx.getCollector();
        if (collector.getConfigurationParam("mail.transport.auth").equals("true")) {
            if (collector.getConfigurationParam("mail.transport.user").isEmpty()) {
                ctx.trackError("mail.transport.user", "error.mail.transport.user.required");
            }
            if (collector.getConfigurationParam("mail.transport.password").isEmpty()) {
                ctx.trackError("mail.transport.password", "error.mail.transport.password.required");
            }
        }
        if (!collector.getConfigurationParam("mail.transport.port").isEmpty() && !NumberValidator.validate((String)collector.getConfigurationParam("mail.transport.port"))) {
            ctx.trackError("mail.transport.port", "error.mail.transport.port.mustbeanumber");
        }
        if (ctx.hasErrors()) {
            currentPage.dispatchToJSP(req, resp);
        } else {
            currentPage.next().dispatchToJSP(req, resp, true);
        }
    }

    public void handleRecapPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context ctx = Context.instance((HttpServletRequest)req);
        ParamCollector collector = ctx.getCollector();
        ConfigurationGenerator cg = collector.getConfigurationGenerator();
        PackageDownloaderHelper.markPackageSelectionDone((Context)ctx);
        Map changedParameters = collector.getConfigurationParams();
        changedParameters.put("nuxeo.wizard.done", "true");
        try {
            cg.saveFilteredConfiguration(changedParameters);
            currentPage.next().dispatchToJSP(req, resp, true);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Could not save wizard parameters.", (Throwable)e);
            currentPage.dispatchToJSP(req, resp);
        }
    }

    public void handleGeneralPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context ctx = Context.instance((HttpServletRequest)req);
        ParamCollector collector = ctx.getCollector();
        String bindAddress = collector.getConfigurationParamValue("nuxeo.bind.address");
        if (bindAddress != null && !bindAddress.isEmpty()) {
            if (!IPValidator.validate((String)bindAddress)) {
                ctx.trackError("nuxeo.bind.address", "error.invalid.ip");
            }
            try {
                InetAddress inetAddress = ConfigurationGenerator.getBindAddress((String)bindAddress);
                ConfigurationGenerator.checkAddressReachable((InetAddress)inetAddress);
            }
            catch (ConfigurationException e) {
                ctx.trackError("nuxeo.bind.address", "error.already.used.ip");
            }
        }
        if (ctx.hasErrors()) {
            currentPage.dispatchToJSP(req, resp);
        } else {
            currentPage.next().dispatchToJSP(req, resp, true);
        }
    }

    public void handleHomeGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context ctx = Context.instance((HttpServletRequest)req);
        if (PackageDownloaderHelper.isPackageSelectionDone((Context)ctx)) {
            this.navHandler.deactivatePage("PackagesSelection");
            this.navHandler.deactivatePage("PackagesDownload");
            this.navHandler.activatePage("PackagesSelectionDone");
        }
        this.handleDefaultGET(currentPage, req, resp);
    }

    public void handleHomePOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String browserInternetAccess;
        String baseUrl = req.getParameter("baseUrl");
        if (baseUrl != null && !baseUrl.isEmpty() && baseUrl.endsWith("Home")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 4);
            Context.instance((HttpServletRequest)req).setBaseUrl(baseUrl);
        }
        if ("true".equals(browserInternetAccess = req.getParameter("browserInternetAccess"))) {
            Context.instance((HttpServletRequest)req).setBrowserInternetAccess(true);
            SimpleNavigationHandler.instance().deactivatePage("NetworkBlocked");
            SimpleNavigationHandler.instance().activatePage("Connect");
        } else {
            Context.instance((HttpServletRequest)req).setBrowserInternetAccess(false);
            SimpleNavigationHandler.instance().activatePage("NetworkBlocked");
            SimpleNavigationHandler.instance().deactivatePage("Connect");
        }
        currentPage.next().dispatchToJSP(req, resp, true);
    }

    public void handleProxyPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Context ctx = Context.instance((HttpServletRequest)req);
        ParamCollector collector = ctx.getCollector();
        String proxyType = collector.getConfigurationParamValue("nuxeo.http.proxy.type");
        if ("none".equals(proxyType)) {
            collector.addConfigurationParam("nuxeo.http.proxy.type", null);
            collector.addConfigurationParam("nuxeo.http.proxy.login", null);
            collector.addConfigurationParam("nuxeo.http.proxy.password", null);
            collector.addConfigurationParam("nuxeo.http.proxy.host", null);
            collector.addConfigurationParam("nuxeo.http.proxy.port", null);
            collector.addConfigurationParam("nuxeo.http.proxy.ntml.host", null);
            collector.addConfigurationParam("nuxeo.http.proxy.ntml.domain", null);
            if (!PackageDownloaderHelper.isPackageSelectionDone((Context)ctx)) {
                PackageDownloader.instance().setProxy(null, 0, null, null, null, null);
            }
        } else {
            if (!NumberValidator.validate((String)collector.getConfigurationParam("nuxeo.http.proxy.port"))) {
                ctx.trackError("nuxeo.http.proxy.port", "error.nuxeo.http.proxy.port");
            }
            if (collector.getConfigurationParam("nuxeo.http.proxy.host").isEmpty()) {
                ctx.trackError("nuxeo.http.proxy.host", "error.nuxeo.http.proxy.emptyHost");
            }
            if ("anonymous".equals(proxyType)) {
                collector.addConfigurationParam("nuxeo.http.proxy.login", null);
                collector.addConfigurationParam("nuxeo.http.proxy.password", null);
                collector.addConfigurationParam("nuxeo.http.proxy.ntml.host", null);
                collector.addConfigurationParam("nuxeo.http.proxy.ntml.domain", null);
                if (!ctx.hasErrors() && !PackageDownloaderHelper.isPackageSelectionDone((Context)ctx)) {
                    PackageDownloader.instance().setProxy(collector.getConfigurationParamValue("nuxeo.http.proxy.host"), Integer.parseInt(collector.getConfigurationParamValue("nuxeo.http.proxy.port")), null, null, null, null);
                }
            } else if (collector.getConfigurationParam("nuxeo.http.proxy.login").isEmpty()) {
                ctx.trackError("nuxeo.http.proxy.login", "error.nuxeo.http.proxy.emptyLogin");
            } else if (!ctx.hasErrors() && !PackageDownloaderHelper.isPackageSelectionDone((Context)ctx)) {
                PackageDownloader.instance().setProxy(collector.getConfigurationParamValue("nuxeo.http.proxy.host"), Integer.parseInt(collector.getConfigurationParamValue("nuxeo.http.proxy.port")), collector.getConfigurationParamValue("nuxeo.http.proxy.login"), collector.getConfigurationParamValue("nuxeo.http.proxy.password"), collector.getConfigurationParamValue("nuxeo.http.proxy.ntlm.host"), collector.getConfigurationParamValue("nuxeo.http.proxy.ntml.domain"));
            }
        }
        if (ctx.hasErrors()) {
            currentPage.dispatchToJSP(req, resp);
        } else {
            currentPage.next().dispatchToJSP(req, resp, true);
        }
    }

    public void handleResetGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Context.reset();
        SimpleNavigationHandler.reset();
        PackageDownloader.reset();
        String target = "/" + req.getContextPath() + "/" + SimpleNavigationHandler.instance().getDefaultPage().getAction();
        if (target.startsWith("//")) {
            target = target.substring(1);
        }
        resp.sendRedirect(target);
    }

    public void handlePackageOptionsResourceGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        DownloadablePackageOptions options = PackageDownloader.instance().getPackageOptions();
        resp.setContentType("text/json");
        resp.getWriter().write(options.asJson());
    }

    public void handlePackagesSelectionGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleDefaultGET(currentPage, req, resp);
    }

    public void handlePackagesSelectionPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<String> options = new ArrayList<String>();
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String p = (String)params.nextElement();
            if (!"on".equals(req.getParameter(p))) continue;
            options.add(p);
        }
        PackageDownloader.instance().selectOptions(options);
        currentPage.next().dispatchToJSP(req, resp, true);
    }

    public void handlePackagesDownloadGET(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("true".equals(req.getParameter("startDownload"))) {
            PackageDownloader.instance().startDownload();
        } else if (req.getParameter("reStartDownload") != null) {
            PackageDownloader.instance().reStartDownload(req.getParameter("reStartDownload"));
        }
        currentPage.dispatchToJSP(req, resp);
    }

    public void handlePackagesDownloadPOST(Page currentPage, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ParamCollector collector = Context.instance((HttpServletRequest)req).getCollector();
        String installationFilePath = new File(collector.getConfigurationParam("nuxeo.data.dir"), "installAfterRestart.log").getAbsolutePath();
        PackageDownloader.instance().scheduleDownloadedPackagesForInstallation(installationFilePath);
        PackageDownloader.reset();
        currentPage.next().dispatchToJSP(req, resp, true);
    }
}

