/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wizard.download;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wizard.download.DownloadPackage;
import org.nuxeo.wizard.download.DownloadablePackageOption;
import org.nuxeo.wizard.download.Preset;

public class DownloadablePackageOptions {
    protected List<DownloadablePackageOption> pkgOptions = new ArrayList();
    protected List<DownloadPackage> pkg4Install = new ArrayList();
    protected List<DownloadPackage> commonPackages = new ArrayList();
    protected List<DownloadPackage> allPackages = new ArrayList();
    protected List<Preset> presets = new ArrayList();
    protected static final Log log = LogFactory.getLog(DownloadablePackageOptions.class);

    public List<DownloadablePackageOption> getOptions() {
        return this.pkgOptions;
    }

    public void addOptions(DownloadablePackageOption pkgOption) {
        this.pkgOptions.add(pkgOption);
    }

    public void addCommonPackage(DownloadPackage pkg) {
        this.commonPackages.add(pkg);
    }

    public int size() {
        return this.getOptions().size();
    }

    public DownloadablePackageOption get(int idx) {
        return (DownloadablePackageOption)this.getOptions().get(idx);
    }

    public void resetSelection() {
        this.pkg4Install = new ArrayList();
        for (DownloadablePackageOption option : this.pkgOptions) {
            this.resetSelection(option);
        }
    }

    protected void resetSelection(DownloadablePackageOption option) {
        option.setSelected(false);
        for (DownloadablePackageOption child : option.getChildrenPackages()) {
            this.resetSelection(child);
        }
    }

    public List<String> checkSelectionValid(List<String> ids) {
        for (String id : ids) {
            ArrayList<String> newIds;
            DownloadablePackageOption option = this.findById(id, this.pkgOptions);
            if (option == null) {
                newIds = new ArrayList<String>();
                newIds.addAll(ids);
                newIds.remove(id);
                return this.checkSelectionValid(newIds);
            }
            if (option.getParent() != null && !ids.contains(option.getParent().getId())) {
                newIds = new ArrayList();
                newIds.addAll(ids);
                newIds.add(0, option.getParent().getId());
                return this.checkSelectionValid(newIds);
            }
            if (option.isExclusive()) {
                for (DownloadablePackageOption sib : option.getSiblingPackages()) {
                    if (!ids.contains(sib.getId())) continue;
                    ids.remove(option.getId());
                    log.warn((Object)"Unsatisfied constraints in selection ... fixing");
                    return this.checkSelectionValid(ids);
                }
                continue;
            }
            for (DownloadablePackageOption sib : option.getSiblingPackages()) {
                if (!ids.contains(sib.getId()) || !sib.isExclusive()) continue;
                ids.remove(sib.getId());
                log.warn((Object)"Unsatisfied constraints in selection ... fixing");
                return this.checkSelectionValid(ids);
            }
        }
        return ids;
    }

    protected void markForDownload(String pkgId) {
        for (DownloadPackage pkg : this.allPackages) {
            if (!pkg.getId().equals(pkgId)) continue;
            this.markForDownload(pkg);
            break;
        }
    }

    protected void markForDownload(DownloadPackage pkg) {
        if (!this.pkg4Install.contains(pkg)) {
            if (pkg.getFilename() != null && !"".equals(pkg.getFilename())) {
                for (String dep : pkg.getImpliedDeps()) {
                    this.markForDownload(dep);
                }
            }
            this.pkg4Install.add(pkg);
        }
    }

    public void select(List<String> ids) {
        this.resetSelection();
        ids = this.checkSelectionValid(ids);
        for (String id : ids) {
            DownloadablePackageOption option = this.findById(id, this.pkgOptions);
            option.setSelected(true);
            DownloadPackage pkg = option.getPackage();
            if (pkg == null) continue;
            this.markForDownload(pkg);
        }
    }

    protected DownloadablePackageOption findById(String id, List<DownloadablePackageOption> options) {
        for (DownloadablePackageOption option : options) {
            if (option.getId().equals(id)) {
                return option;
            }
            DownloadablePackageOption childOption = this.findById(id, option.getChildrenPackages());
            if (childOption == null) continue;
            return childOption;
        }
        return null;
    }

    public List<DownloadPackage> getPkg4Install() {
        ArrayList<DownloadPackage> pkgs = new ArrayList<DownloadPackage>(this.commonPackages);
        pkgs.addAll(this.pkg4Install);
        return pkgs;
    }

    protected void asJson(DownloadablePackageOption option, StringBuffer sb) {
        sb.append("{");
        sb.append("\"id\":\"" + option.id + "\",");
        sb.append("\"package\":\"" + option.getPackage().getId() + "\",");
        sb.append("\"color\":\"" + option.getColor() + "\",");
        sb.append("\"textcolor\":\"" + option.getTextColor() + "\",");
        sb.append("\"label\":\"" + option.getLabel() + "\",");
        sb.append("\"shortlabel\":\"" + option.getShortLabel() + "\",");
        sb.append("\"selected\":\"" + option.selected + "\",");
        sb.append("\"exclusive\":\"" + option.exclusive + "\",");
        sb.append("\"children\": [");
        List children = option.getChildrenPackages();
        for (int i = 0; i < children.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            this.asJson((DownloadablePackageOption)children.get(i), sb);
        }
        sb.append("] }");
    }

    protected DownloadablePackageOption getSelectedRoot() {
        for (DownloadablePackageOption option : this.pkgOptions) {
            if (!option.isSelected()) continue;
            return option;
        }
        return (DownloadablePackageOption)this.pkgOptions.get(0);
    }

    public String asJson() {
        StringBuffer sb = new StringBuffer();
        this.asJson(this.getSelectedRoot(), sb);
        return sb.toString();
    }

    void addPreset(String id, String label, String[] pkgIds) {
        this.presets.add(new Preset(id, label, pkgIds));
    }

    public List<Preset> getPresets() {
        return this.presets;
    }

    public List<DownloadPackage> getAllPackages() {
        return this.allPackages;
    }

    public void setAllPackages(List<DownloadPackage> allPackages) {
        this.allPackages = allPackages;
    }
}

