/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.runtime.api.Framework;

public class DataFetch {
    private static Log log = LogFactory.getLog(DataFetch.class);
    public static int DEFAULT_PAGE_SIZE = 100;
    public static boolean ORDERBY_PATH = true;

    public DocumentModelList getAllChildren(CoreSession session, DocumentModel doc) throws ClientException, IOException {
        String request = this.getChildrenDocQuery(doc, ORDERBY_PATH);
        log.debug((Object)("start query: " + request));
        DocumentModelList res = session.query(request);
        log.debug((Object)"done query");
        return res;
    }

    public PageProvider<DocumentModel> getAllChildrenPaginated(CoreSession session, DocumentModel doc) throws ClientException {
        return this.getAllChildrenPaginated(session, doc, DEFAULT_PAGE_SIZE, ORDERBY_PATH);
    }

    public CoreQueryDocumentPageProvider getAllChildrenPaginated(CoreSession session, DocumentModel doc, long pageSize, boolean orderByPath) throws ClientException {
        String request = this.getChildrenDocQuery(doc, orderByPath);
        log.debug((Object)("will initialize a paginated query:" + request));
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
        desc.setPattern(request);
        Long targetPage = null;
        Long targetPageSize = pageSize;
        List sortInfos = null;
        Object[] parameters = null;
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)session);
        PageProvider provider = pps.getPageProvider("", (PageProviderDefinition)desc, null, sortInfos, targetPageSize, targetPage, props, parameters);
        provider.setPageSize(pageSize);
        provider.setMaxPageSize(pageSize);
        CoreQueryDocumentPageProvider cqdpp = (CoreQueryDocumentPageProvider)provider;
        return cqdpp;
    }

    public String getChildrenDocQuery(DocumentModel doc, boolean ordered) {
        String parentPath = doc.getPathAsString();
        String request = String.format("SELECT * FROM Document WHERE ecm:path STARTSWITH '%s' AND ecm:mixinType = 'Folderish' AND %s", parentPath, DataFetch.baseRequest());
        if (ordered) {
            return request + " ORDER BY ecm:path";
        }
        return request;
    }

    protected static String baseRequest() {
        return "ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
    }
}

