/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.test;

import com.google.inject.Inject;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class BaseTest {
    protected ObjectMapper mapper;
    protected WebResource service;
    @Inject
    public CoreSession session;

    @Before
    public void doBefore() throws Exception {
        this.service = this.getServiceFor("Administrator", "Administrator");
        this.mapper = new ObjectMapper();
    }

    protected WebResource getServiceFor(String user, String password) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(MultiPartWriter.class);
        Client client = Client.create((ClientConfig)config);
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, password));
        return client.resource("http://localhost:18090/api/v1/");
    }

    protected ClientResponse getResponse(RequestType requestType, String path) {
        return this.getResponse(requestType, path, null, null, null, null);
    }

    protected ClientResponse getResponse(RequestType requestType, String path, Map<String, String> headers) {
        return this.getResponse(requestType, path, null, null, null, headers);
    }

    protected ClientResponse getResponse(RequestType requestType, String path, MultiPart mp) {
        return this.getResponse(requestType, path, null, null, mp, null);
    }

    protected ClientResponse getResponse(RequestType requestType, String path, MultivaluedMap<String, String> queryParams) {
        return this.getResponse(requestType, path, null, queryParams, null, null);
    }

    protected ClientResponse getResponse(RequestType requestType, String path, String data) {
        return this.getResponse(requestType, path, data, null, null, null);
    }

    protected ClientResponse getResponse(RequestType requestType, String path, String data, Map<String, String> headers) {
        return this.getResponse(requestType, path, data, null, null, headers);
    }

    protected ClientResponse getResponse(RequestType requestType, String path, String data, MultivaluedMap<String, String> queryParams, MultiPart mp, Map<String, String> headers) {
        WebResource wr = this.service.path(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            wr = wr.queryParams(queryParams);
        }
        WebResource.Builder builder = requestType == RequestType.GETES ? wr.accept(new String[]{"application/json+esentity"}) : (WebResource.Builder)wr.accept(new String[]{"application/json"}).header("X-NXDocumentProperties", (Object)"dublincore");
        if (mp != null) {
            builder = wr.type(MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (requestType == RequestType.POSTREQUEST) {
            builder.header("Content-type", (Object)"application/json+nxrequest");
        } else {
            builder.header("Content-type", (Object)"application/json+nxentity");
        }
        if (headers != null && !headers.isEmpty()) {
            for (String headerKey : headers.keySet()) {
                builder.header(headerKey, (Object)headers.get(headerKey));
            }
        }
        switch (requestType) {
            case GET: 
            case GETES: {
                return (ClientResponse)builder.get(ClientResponse.class);
            }
            case POST: 
            case POSTREQUEST: {
                if (mp != null) {
                    return (ClientResponse)builder.post(ClientResponse.class, (Object)mp);
                }
                return (ClientResponse)builder.post(ClientResponse.class, (Object)data);
            }
            case PUT: {
                if (mp != null) {
                    return (ClientResponse)builder.put(ClientResponse.class, (Object)mp);
                }
                return (ClientResponse)builder.put(ClientResponse.class, (Object)data);
            }
            case DELETE: {
                return (ClientResponse)builder.delete(ClientResponse.class, (Object)data);
            }
        }
        throw new RuntimeException();
    }

    protected JsonNode getResponseAsJson(RequestType responseType, String url) throws IOException, JsonProcessingException {
        return this.getResponseAsJson(responseType, url, null);
    }

    protected JsonNode getResponseAsJson(RequestType responseType, String url, MultivaluedMap<String, String> queryParams) throws JsonProcessingException, IOException {
        ClientResponse response = this.getResponse(responseType, url, queryParams);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        return this.mapper.readTree(response.getEntityInputStream());
    }

    protected void fetchInvalidations() throws ClientException {
        this.session.save();
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected void assertNodeEqualsDoc(JsonNode node, DocumentModel note) throws Exception {
        Assert.assertEquals((Object)"document", (Object)node.get("entity-type").getValueAsText());
        Assert.assertEquals((Object)note.getPathAsString(), (Object)node.get("path").getValueAsText());
        Assert.assertEquals((Object)note.getId(), (Object)node.get("uid").getValueAsText());
        Assert.assertEquals((Object)note.getTitle(), (Object)node.get("title").getValueAsText());
    }

    protected List<JsonNode> getLogEntries(JsonNode node) {
        Assert.assertEquals((Object)"documents", (Object)node.get("entity-type").getValueAsText());
        Assert.assertTrue((boolean)node.get("entries").isArray());
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        Iterator elements = node.get("entries").getElements();
        while (elements.hasNext()) {
            result.add((JsonNode)elements.next());
        }
        return result;
    }

    protected String getErrorMessage(JsonNode node) {
        Assert.assertEquals((Object)"exception", (Object)node.get("entity-type").getValueAsText());
        Assert.assertTrue((boolean)node.get("message").isTextual());
        return node.get("message").getValueAsText();
    }

    protected void assertEntityEqualsDoc(InputStream in, DocumentModel doc) throws Exception {
        JsonNode node = this.mapper.readTree(in);
        this.assertNodeEqualsDoc(node, doc);
    }

    protected static enum RequestType {
        GET,
        POST,
        DELETE,
        PUT,
        POSTREQUEST,
        GETES;

    }
}

