/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.impl;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.impl.WSSBackendAdapter;
import org.nuxeo.wss.impl.WSSFakeBackend;
import org.nuxeo.wss.impl.WSSVirtualBackendAdapter;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dummy.DummyWSSListItem;
import org.nuxeo.wss.spi.dws.DWSMetaData;
import org.nuxeo.wss.spi.dws.Site;

public class WSSRootBackendAdapter
extends WSSBackendAdapter {
    private static final Log log = LogFactory.getLog(WSSRootBackendAdapter.class);

    public WSSRootBackendAdapter(Backend backend, String virtualRoot) {
        super(backend, virtualRoot);
        this.urlRoot = virtualRoot + backend.getRootUrl();
    }

    @Override
    public boolean exists(String location) {
        return this.getBackend(location).exists(location);
    }

    @Override
    public WSSListItem getItem(String location) throws WSSException {
        if ("".equals(location) || "/".equals(location)) {
            return new DummyWSSListItem("", "WSS Root", null);
        }
        return this.getBackend(location).getItem(location);
    }

    @Override
    public List<WSSListItem> listItems(String location) throws WSSException {
        WSSBackend backend = this.getBackend(location);
        return backend.listItems(location);
    }

    @Override
    public void begin() throws WSSException {
    }

    @Override
    public void saveChanges() throws WSSException {
        super.saveChanges();
    }

    @Override
    public WSSListItem moveItem(String location, String destination) throws WSSException {
        WSSBackend sourceBackend = this.getBackend(location);
        DocumentModel source = null;
        if (sourceBackend instanceof WSSBackendAdapter) {
            source = ((WSSBackendAdapter)sourceBackend).getDocument(location);
        }
        if (source == null) {
            throw new WSSException("Can't move document. Source did not found.");
        }
        WSSBackend destinationBackend = this.getBackend(destination);
        if (destinationBackend instanceof WSSBackendAdapter) {
            return ((WSSBackendAdapter)destinationBackend).moveItem(source, destination);
        }
        return sourceBackend.moveItem(location, destination);
    }

    @Override
    public void removeItem(String location) throws WSSException {
        this.getBackend(location).removeItem(location);
    }

    @Override
    public WSSListItem createFolder(String parentPath, String name) throws WSSException {
        return this.getBackend(parentPath).createFolder(parentPath, name);
    }

    @Override
    public WSSListItem createFileItem(String parentPath, String name) throws WSSException {
        return this.getBackend(parentPath).createFileItem(parentPath, name);
    }

    @Override
    public DWSMetaData getMetaData(String location, WSSRequest wssRequest) throws WSSException {
        return this.getBackend(location).getMetaData(location, wssRequest);
    }

    @Override
    public Site getSite(String location) throws WSSException {
        return this.getBackend(location).getSite(location);
    }

    protected WSSBackend getBackend(String location) {
        try {
            HashSet names = new HashSet(this.backend.getVirtualFolderNames());
            Path locationPath = new Path(location);
            String[] segments = locationPath.segments();
            int removeSegments = 0;
            for (String segment : segments) {
                if (names.contains(segment)) break;
                ++removeSegments;
            }
            Path localVirtualRootPath = locationPath.removeLastSegments(locationPath.segmentCount() - removeSegments);
            this.virtualRoot = this.cleanPath(localVirtualRootPath.toString());
        }
        catch (ClientException e) {
            log.warn((Object)"Error during resolve virtual root");
        }
        location = this.cleanLocation(location);
        Backend backend = this.backend.getBackend(location);
        if (backend == null) {
            return new WSSFakeBackend();
        }
        if (backend.isVirtual()) {
            return new WSSVirtualBackendAdapter(backend, this.virtualRoot);
        }
        return new WSSBackendAdapter(backend, this.virtualRoot);
    }
}

