/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit;

import com.sun.star.uno.RuntimeException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WrapperQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.audit.api.AuditRuntimeException;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.query.AuditQueryException;
import org.nuxeo.ecm.platform.audit.api.query.DateRangeParser;
import org.nuxeo.ecm.platform.audit.service.AbstractAuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.DefaultAuditBackend;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.io.AuditEntryJSONReader;
import org.nuxeo.elasticsearch.audit.io.AuditEntryJSONWriter;
import org.nuxeo.elasticsearch.seqgen.SequenceGenerator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ESAuditBackend
extends AbstractAuditBackend
implements AuditBackend {
    public static final String IDX_NAME = "audit";
    public static final String IDX_TYPE = "entry";
    public static final String SEQ_NAME = "audit";
    protected Client esClient = null;
    protected static final Log log = LogFactory.getLog(ESAuditBackend.class);
    protected BaseLogEntryProvider provider = null;

    protected Client getClient() {
        if (this.esClient == null) {
            log.info((Object)"Activate Elasticsearch backend for Audit");
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
            this.esClient = esa.getClient();
        }
        return this.esClient;
    }

    public void deactivate() throws Exception {
        if (this.esClient != null) {
            this.esClient.close();
        }
    }

    public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{"audit"}).setTypes(new String[]{IDX_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        if (filterMap == null || filterMap.size() == 0) {
            builder.setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"docUUID", (Object)uuid));
        } else {
            BoolFilterBuilder filterBuilder = FilterBuilders.boolFilter();
            for (String key : filterMap.keySet()) {
                FilterMapEntry entry = filterMap.get(key);
                filterBuilder.must((FilterBuilder)FilterBuilders.termFilter((String)entry.getColumnName(), (Object)entry.getObject()));
            }
            builder.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchQuery((String)"docUUID", (Object)uuid), (FilterBuilder)filterBuilder));
        }
        SearchResponse searchResponse = (SearchResponse)builder.setFrom(0).setSize(60).execute().actionGet();
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (SearchHit hit : searchResponse.getHits()) {
            try {
                entries.add(AuditEntryJSONReader.read(hit.getSourceAsString()));
            }
            catch (Exception e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries;
    }

    public LogEntry getLogEntryByID(long id) {
        SearchResponse searchResponse = (SearchResponse)this.getClient().prepareSearch(new String[]{"audit"}).setTypes(new String[]{IDX_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{String.valueOf(id)})).setFrom(0).setSize(10).execute().actionGet();
        SearchHits hits = searchResponse.getHits();
        if (hits.getTotalHits() > 1L) {
            throw new RuntimeException("Found several match for the same ID : there is something wrong");
        }
        try {
            return AuditEntryJSONReader.read(hits.getAt(0).getSourceAsString());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read Entry for id " + id, (Object)e);
        }
    }

    public SearchRequestBuilder buildQuery(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            query = this.expandQueryVariables(query, params);
        }
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{"audit"}).setTypes(new String[]{IDX_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        builder.setQuery(query);
        return builder;
    }

    public String expandQueryVariables(String query, Object[] params) {
        HashMap<String, Object> qParams = new HashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            query = query.replaceFirst("\\?", "\\${param" + i + "}");
            qParams.put("param" + i, params[i]);
        }
        return this.expandQueryVariables(query, qParams);
    }

    public String expandQueryVariables(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            TextTemplate tmpl = new TextTemplate();
            for (String key : params.keySet()) {
                Object val = params.get(key);
                if (val == null) continue;
                if (val instanceof Calendar) {
                    tmpl.setVariable(key, ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)((Calendar)val))));
                    continue;
                }
                if (val instanceof Date) {
                    tmpl.setVariable(key, ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)((Date)val))));
                    continue;
                }
                tmpl.setVariable(key, val.toString());
            }
            query = tmpl.process((CharSequence)query);
        }
        return query;
    }

    public List<?> nativeQuery(String query, Map<String, Object> params, int pageNb, int pageSize) {
        SearchRequestBuilder builder = this.buildQuery(query, params);
        if (pageNb > 0) {
            builder.setFrom(pageNb * pageSize);
        }
        if (pageSize > 0) {
            builder.setSize(pageSize);
        }
        SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (SearchHit hit : searchResponse.getHits()) {
            try {
                entries.add(AuditEntryJSONReader.read(hit.getSourceAsString()));
            }
            catch (Exception e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries;
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{"audit"}).setTypes(new String[]{IDX_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        BoolFilterBuilder filterBuilder = FilterBuilders.boolFilter();
        int nbClauses = 0;
        int nbFilters = 0;
        if (eventIds != null && eventIds.length > 0) {
            if (eventIds.length == 1) {
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"eventId", (Object)eventIds[0]));
                ++nbClauses;
            } else {
                filterBuilder.must((FilterBuilder)FilterBuilders.termsFilter((String)"eventId", (String[])eventIds));
                ++nbFilters;
            }
        }
        if (categories != null && categories.length > 0) {
            if (categories.length == 1) {
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"category", (Object)categories[0]));
                ++nbClauses;
            } else {
                filterBuilder.must((FilterBuilder)FilterBuilders.termsFilter((String)"category", (String[])categories));
                ++nbFilters;
            }
        }
        if (path != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"docPath", (Object)path));
            ++nbClauses;
        }
        if (limit != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"eventDate").lt((Object)limit));
            ++nbClauses;
        }
        Object targetBuilder = null;
        Object targetFilter = null;
        targetBuilder = nbClauses > 0 ? queryBuilder : QueryBuilders.matchAllQuery();
        targetFilter = nbFilters > 0 ? filterBuilder : FilterBuilders.matchAllFilter();
        builder.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)targetBuilder, (FilterBuilder)targetFilter));
        if (pageNb > 0) {
            builder.setFrom(pageNb * pageSize);
        }
        if (pageSize > 0) {
            builder.setSize(pageSize);
        }
        SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (SearchHit hit : searchResponse.getHits()) {
            try {
                entries.add(AuditEntryJSONReader.read(hit.getSourceAsString()));
            }
            catch (Exception e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries;
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String[] categories, String path, int pageNb, int pageSize) {
        Date limit = null;
        if (dateRange != null) {
            try {
                limit = DateRangeParser.parseDateRangeQuery((Date)new Date(), (String)dateRange);
            }
            catch (AuditQueryException aqe) {
                throw new AuditRuntimeException("Wrong date range query. Query was " + dateRange, (Throwable)aqe);
            }
        }
        return this.queryLogsByPage(eventIds, limit, categories, path, pageNb, pageSize);
    }

    public void addLogEntries(List<LogEntry> entries) {
        BulkRequestBuilder bulkRequest = this.getClient().prepareBulk();
        JsonFactory factory = new JsonFactory();
        SequenceGenerator sg = (SequenceGenerator)Framework.getService(SequenceGenerator.class);
        try {
            for (LogEntry entry : entries) {
                entry.setId(sg.getNextId("audit"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Indexing log enry Id: %s, with logDate : %s, for docUUID: %s ", entry.getId(), entry.getLogDate(), entry.getDocUUID()));
                }
                XContentBuilder builder = XContentFactory.jsonBuilder();
                JsonGenerator jsonGen = factory.createJsonGenerator(builder.stream());
                AuditEntryJSONWriter.asJSON(jsonGen, entry);
                bulkRequest.add(this.getClient().prepareIndex("audit", IDX_TYPE, String.valueOf(entry.getId())).setSource(builder));
            }
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
            if (bulkResponse.hasFailures()) {
                for (BulkItemResponse response : bulkResponse.getItems()) {
                    if (!response.isFailed()) continue;
                    log.error((Object)("Unable to index audit entry " + response.getItemId() + " :" + response.getFailureMessage()));
                }
            }
        }
        catch (Exception e) {
            throw new ClientException("Error while indexing Audit entries", (Throwable)e);
        }
    }

    public Long getEventsCount(String eventId) {
        CountResponse res = (CountResponse)this.getClient().prepareCount(new String[]{"audit"}).setTypes(new String[]{IDX_TYPE}).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"eventId", (Object)eventId)).execute().actionGet();
        return res.getCount();
    }

    protected BaseLogEntryProvider getProvider() {
        if (this.provider == null) {
            this.provider = new BaseLogEntryProvider(){

                public int removeEntries(String eventId, String pathPattern) {
                    throw new UnsupportedOperationException("Not implemented yet!");
                }

                public void addLogEntry(LogEntry logEntry) {
                    ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
                    entries.add(logEntry);
                    ESAuditBackend.this.addLogEntries(entries);
                }
            };
        }
        return this.provider;
    }

    public long syncLogCreationEntries(String repoId, String path, Boolean recurs) {
        return this.syncLogCreationEntries(this.getProvider(), repoId, path, recurs);
    }

    protected FilterBuilder buildFilter(PredicateDefinition[] predicates, DocumentModel searchDocumentModel) {
        if (searchDocumentModel == null) {
            return FilterBuilders.matchAllFilter();
        }
        BoolFilterBuilder filterBuilder = FilterBuilders.boolFilter();
        int nbFilters = 0;
        for (PredicateDefinition predicate : predicates) {
            Object[] val;
            try {
                PredicateFieldDefinition[] fieldDef = predicate.getValues();
                val = new Object[fieldDef.length];
                for (int fidx = 0; fidx < fieldDef.length; ++fidx) {
                    val[fidx] = fieldDef[fidx].getXpath() != null ? searchDocumentModel.getPropertyValue(fieldDef[fidx].getXpath()) : searchDocumentModel.getProperty(fieldDef[fidx].getSchema(), fieldDef[fidx].getName());
                }
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            if (!this.isNonNullParam(val)) continue;
            ++nbFilters;
            String op = predicate.getOperator();
            if (op.equalsIgnoreCase("IN")) {
                String[] values = null;
                if (val[0] instanceof Iterable) {
                    ArrayList<String> l = new ArrayList<String>();
                    Iterable vals = (Iterable)val[0];
                    for (Object v : vals) {
                        if (v == null) continue;
                        l.add(v.toString());
                    }
                    values = l.toArray(new String[l.size()]);
                } else if (val[0] instanceof Object[]) {
                    values = (String[])val[0];
                }
                filterBuilder.must((FilterBuilder)FilterBuilders.termsFilter((String)predicate.getParameter(), values));
                continue;
            }
            if (op.equalsIgnoreCase("BETWEEN")) {
                filterBuilder.must((FilterBuilder)FilterBuilders.rangeFilter((String)predicate.getParameter()).gt(val[0]));
                if (val.length <= 1) continue;
                filterBuilder.must((FilterBuilder)FilterBuilders.rangeFilter((String)predicate.getParameter()).lt(val[1]));
                continue;
            }
            if (">".equals(op)) {
                filterBuilder.must((FilterBuilder)FilterBuilders.rangeFilter((String)predicate.getParameter()).gt(val[0]));
                continue;
            }
            if (">=".equals(op)) {
                filterBuilder.must((FilterBuilder)FilterBuilders.rangeFilter((String)predicate.getParameter()).gte(val[0]));
                continue;
            }
            if ("<".equals(op)) {
                filterBuilder.must((FilterBuilder)FilterBuilders.rangeFilter((String)predicate.getParameter()).lt(val[0]));
                continue;
            }
            if ("<=".equals(op)) {
                filterBuilder.must((FilterBuilder)FilterBuilders.rangeFilter((String)predicate.getParameter()).lte(val[0]));
                continue;
            }
            filterBuilder.must((FilterBuilder)FilterBuilders.termFilter((String)predicate.getParameter(), (Object)val[0]));
        }
        if (nbFilters == 0) {
            return FilterBuilders.matchAllFilter();
        }
        return filterBuilder;
    }

    public SearchRequestBuilder buildSearchQuery(String fixedPart, PredicateDefinition[] predicates, DocumentModel searchDocumentModel) {
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{"audit"}).setTypes(new String[]{IDX_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        WrapperQueryBuilder queryBuilder = QueryBuilders.wrapperQuery((String)fixedPart);
        FilterBuilder filterBuilder = this.buildFilter(predicates, searchDocumentModel);
        builder.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder));
        return builder;
    }

    protected boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (v == null) continue;
            if (v instanceof String) {
                if (((String)v).isEmpty()) continue;
                return true;
            }
            if (v instanceof String[]) {
                if (((String[])v).length <= 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public String migrate(int batchSize) throws Exception {
        DefaultAuditBackend sourceBackend = new DefaultAuditBackend();
        sourceBackend.activate(this.component);
        String MIGRATION_WORK_ID = "AuditMigration";
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        Work.State migrationState = wm.getWorkState("AuditMigration");
        if (migrationState != null) {
            return "Migration already scheduled : " + migrationState.toString();
        }
        List res = sourceBackend.nativeQuery("select count(*) from LogEntry", 1, 20);
        final long nbEntriesToMigrate = (Long)res.get(0);
        AbstractWork migrationWork = new AbstractWork("AuditMigration", (AuditBackend)sourceBackend, batchSize){
            final /* synthetic */ AuditBackend val$sourceBackend;
            final /* synthetic */ int val$batchSize;
            {
                this.val$sourceBackend = auditBackend;
                this.val$batchSize = n;
                super(x0);
            }

            public String getTitle() {
                return "Audit migration worker";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void work() throws Exception {
                TransactionHelper.commitOrRollbackTransaction();
                try {
                    long t0 = System.currentTimeMillis();
                    long nbEntriesMigrated = 0L;
                    int pageIdx = 1;
                    while (nbEntriesMigrated < nbEntriesToMigrate) {
                        List entries = this.val$sourceBackend.nativeQuery("from LogEntry log order by log.id asc", pageIdx, this.val$batchSize);
                        if (entries.size() == 0) {
                            log.warn((Object)("Migration ending after " + nbEntriesMigrated + " entries"));
                            break;
                        }
                        this.setProgress(new Work.Progress(nbEntriesMigrated, nbEntriesToMigrate));
                        ESAuditBackend.this.addLogEntries(entries);
                        ++pageIdx;
                        log.info((Object)("migrated " + (nbEntriesMigrated += (long)entries.size()) + " log entries on " + nbEntriesToMigrate));
                        double dt = (double)(System.currentTimeMillis() - t0) / 1000.0;
                        if (dt == 0.0) continue;
                        log.info((Object)("migration speed " + (double)nbEntriesMigrated / dt + " entries/s"));
                    }
                }
                finally {
                    TransactionHelper.startTransaction();
                }
            }
        };
        wm.schedule((Work)migrationWork);
        return "Migration work started : AuditMigration";
    }
}

