/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.segment.io;

import com.github.segmentio.models.Props;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class SegmentIODataWrapper {
    public static final String LOGIN_KEY = "login";
    public static final String PRINCIPAL_KEY = "principal";
    public static final String EMAIL_KEY = "email";
    public static final String GROUP_KEY_PREFIX = "group_";
    protected static final Log log = LogFactory.getLog(SegmentIODataWrapper.class);
    protected String userId;
    protected Map<String, Serializable> metadata;

    public SegmentIODataWrapper(NuxeoPrincipal principal, Map<String, Serializable> metadata) {
        if (metadata == null) {
            metadata = new HashMap<String, Serializable>();
        }
        if (metadata.containsKey(PRINCIPAL_KEY) && metadata.get(PRINCIPAL_KEY) != null) {
            principal = (NuxeoPrincipal)metadata.get(PRINCIPAL_KEY);
        }
        this.userId = principal.getName();
        if (!metadata.containsKey(EMAIL_KEY)) {
            metadata.put(EMAIL_KEY, (Serializable)((Object)principal.getEmail()));
        }
        if (metadata.containsKey(LOGIN_KEY)) {
            this.userId = (String)((Object)metadata.get(LOGIN_KEY));
        }
        this.metadata = metadata;
    }

    public String getUserId() {
        return this.userId;
    }

    private boolean isPrimitive(Object value) {
        boolean primitive = false;
        if (value != null) {
            Class<?> clazz = value.getClass();
            primitive = clazz.isPrimitive() || ClassUtils.wrapperToPrimitive(clazz) != null;
        }
        return primitive;
    }

    protected boolean isAllowed(Object value) {
        return this.isPrimitive(value) || value instanceof String || value instanceof Date || value instanceof Props || value instanceof BigDecimal || value instanceof Collection || value instanceof Map || value instanceof Object[];
    }

    public Map<String, Serializable> getMetadata() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (String key : this.metadata.keySet()) {
            if (key.startsWith(GROUP_KEY_PREFIX)) continue;
            Serializable value = this.metadata.get(key);
            if (value != null) {
                if (this.isAllowed(value)) {
                    map.put(key, value);
                    continue;
                }
                map.put(key, (Serializable)((Object)value.toString()));
                continue;
            }
            log.debug((Object)("Skip null value for key " + key));
        }
        return map;
    }

    public Map<String, Serializable> getGroupMetadata() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (String key : this.metadata.keySet()) {
            if (!key.startsWith(GROUP_KEY_PREFIX)) continue;
            String gKey = key.substring(GROUP_KEY_PREFIX.length());
            Serializable value = this.metadata.get(key);
            if (value != null) {
                if (this.isAllowed(value)) {
                    map.put(gKey, value);
                    continue;
                }
                map.put(gKey, (Serializable)((Object)value.toString()));
                continue;
            }
            log.debug((Object)("Skip null value for key " + key));
        }
        return map;
    }
}

