/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.segment.io;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.segment.io.SegmentIO;

@XObject(value="mapper")
public class SegmentIOMapper {
    private static Log log = LogFactory.getLog(SegmentIOMapper.class);
    @XNode(value="@name")
    String name;
    @XNode(value="@targetAPI")
    String target = "track";
    @XNodeList(value="events/event", type=ArrayList.class, componentType=String.class)
    List<String> events;
    @XNode(value="groovy")
    String groovyMapping;
    @XNodeMap(value="parameters/parameter", key="@name", type=HashMap.class, componentType=String.class)
    Map<String, String> parameters = new HashMap<String, String>();
    private Class<?> klass;

    public boolean equals(Object obj) {
        if (obj instanceof SegmentIOMapper) {
            return this.name.equals(((SegmentIOMapper)obj).name);
        }
        return super.equals(obj);
    }

    public boolean isIdentify() {
        return SegmentIO.ACTIONS.identify.name().equalsIgnoreCase(this.target);
    }

    public boolean isPage() {
        return SegmentIO.ACTIONS.page.name().equalsIgnoreCase(this.target);
    }

    public boolean isScreen() {
        return SegmentIO.ACTIONS.screen.name().equalsIgnoreCase(this.target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getGroovyClazz() {
        if (this.klass == null) {
            SegmentIOMapper segmentIOMapper = this;
            synchronized (segmentIOMapper) {
                if (this.klass == null) {
                    StringBuffer sb = new StringBuffer();
                    for (String key : this.parameters.keySet()) {
                        sb.append("mapping.put(\"");
                        sb.append(key);
                        sb.append("\", ");
                        sb.append(this.parameters.get(key));
                        sb.append(");\n");
                    }
                    if (this.groovyMapping != null && !this.groovyMapping.isEmpty()) {
                        sb.append(this.groovyMapping);
                    }
                    try (GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader());){
                        this.klass = loader.parseClass(sb.toString());
                    }
                    catch (IOException e) {
                        throw new NuxeoException(String.format("Error during Groovy script execution for the '%s' segmentIO mapper", this.name), (Throwable)e);
                    }
                }
            }
        }
        return this.klass;
    }

    public Map<String, Serializable> getMappedData(Map<String, Object> context) {
        HashMap<String, Serializable> mapping = new HashMap<String, Serializable>();
        context.put("mapping", mapping);
        Binding binding = new Binding(context);
        Script script = InvokerHelper.createScript(this.getGroovyClazz(), (Binding)binding);
        script.run();
        return mapping;
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }
}

