/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.segment.io.listener;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.segment.io.SegmentIO;
import org.nuxeo.segment.io.SegmentIOMapper;

public class SegmentIOAsyncListener
implements PostCommitFilteringEventListener {
    public boolean acceptEvent(Event event) {
        SegmentIO service = (SegmentIO)Framework.getService(SegmentIO.class);
        return service.getMappedEvents().contains(event.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(EventBundle bundle) {
        SegmentIO service = (SegmentIO)Framework.getService(SegmentIO.class);
        List<String> eventToProcess = service.getMappedEvents().stream().filter(event -> bundle.containsEventName(event)).collect(Collectors.toList());
        Map<String, List<SegmentIOMapper>> event2Mappers = service.getMappers(eventToProcess);
        try {
            LoginContext login = Framework.login();
            try {
                this.processEvents(event2Mappers, bundle);
            }
            finally {
                if (login != null) {
                    login.logout();
                }
            }
        }
        catch (LoginException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void processEvents(Map<String, List<SegmentIOMapper>> event2Mappers, EventBundle bundle) {
        block0: for (Event event : bundle) {
            List<SegmentIOMapper> mappers = event2Mappers.get(event.getName());
            if (mappers == null || mappers.size() == 0) continue;
            for (SegmentIOMapper mapper : mappers) {
                HashMap<String, Object> ctx = new HashMap<String, Object>();
                NuxeoPrincipal principal = event.getContext().getPrincipal();
                SegmentIO service = (SegmentIO)Framework.getService(SegmentIO.class);
                if (!service.mustTrackprincipal(principal.getName())) continue block0;
                ctx.put("event", event);
                ctx.put("eventContext", event.getContext());
                ctx.put("principal", principal);
                if (event.getContext() instanceof DocumentEventContext) {
                    DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
                    ctx.put("doc", docCtx.getSourceDocument());
                    ctx.put("repository", docCtx.getRepositoryName());
                    ctx.put("session", docCtx.getCoreSession());
                    ctx.put("dest", docCtx.getDestination());
                }
                Map<String, Serializable> mapped = mapper.getMappedData(ctx);
                mapped.put("url", (Serializable)((Object)Framework.getProperty((String)"nuxeo.url", (String)"unknown server url")));
                if (mapper.isIdentify()) {
                    service.identify(principal, mapped);
                    continue;
                }
                if (mapper.isPage()) {
                    service.page(principal, this.getNameWithDefault(event, "page"), mapped);
                    continue;
                }
                if (mapper.isScreen()) {
                    service.screen(principal, this.getNameWithDefault(event, "screen"), mapped);
                    continue;
                }
                service.track(principal, event.getName(), mapped);
            }
        }
    }

    protected String getNameWithDefault(Event e, String defaultName) {
        return e.getContext().getProperties().getOrDefault("name", defaultName);
    }
}

