/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.IOUtils;

public class TestCopy
extends AbstractCommandTest {
    private File goldStandardFile;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.goldStandardFile = new File(Environment.getDefault().getConfig(), "goldstandard.properties");
        FileUtils.writeStringToFile((File)this.goldStandardFile, (String)"param1=value1", (Charset)StandardCharsets.UTF_8);
    }

    @Override
    protected File createPackage() throws IOException, URISyntaxException {
        return this.getTestPackageZip("test-copy");
    }

    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        super.installDone(task, error);
        LocalPackage pkg = task.getPackage();
        File src = pkg.getData().getEntry("test.properties");
        File dst = this.getTargetFile();
        Assert.assertTrue((boolean)dst.isFile());
        Assert.assertEquals((Object)IOUtils.createMd5((File)src), (Object)IOUtils.createMd5((File)dst));
        Properties goldstandard = new Properties();
        goldstandard.load(new FileInputStream(this.goldStandardFile));
        Assert.assertEquals((String)"Original property is missing", (Object)"value1", (Object)goldstandard.getProperty("param1"));
        Assert.assertEquals((String)"Appended property is missing", (Object)"value2", (Object)goldstandard.getProperty("param2"));
        Assert.assertEquals((String)"Appended property is missing", (Object)"value3", (Object)goldstandard.getProperty("param3"));
    }

    @Override
    protected void uninstallDone(Task task, Throwable error) throws Exception {
        super.uninstallDone(task, error);
        Assert.assertFalse((boolean)this.getTargetFile().exists());
        Properties goldstandard = new Properties();
        goldstandard.load(new FileInputStream(this.goldStandardFile));
        Assert.assertEquals((String)"Original property is missing", (Object)"value1", (Object)goldstandard.getProperty("param1"));
        Assert.assertNull((String)"Appended property must be removed", (Object)goldstandard.getProperty("param2"));
        Assert.assertNull((String)"Appended property must be removed", (Object)goldstandard.getProperty("param3"));
    }

    protected File getTargetFile() {
        return new File(Environment.getDefault().getConfig(), "test.properties");
    }
}

