/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kv;

import java.time.Duration;
import java.time.Instant;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ClusterLockHelper {
    private static final Logger log = LogManager.getLogger(ClusterLockHelper.class);
    public static final String CLUSTERING_ENABLED_PROP = "repository.clustering.enabled";
    public static final String NODE_ID_PROP = "repository.clustering.id";
    public static final String KV_STORE_NAME = "cluster";
    protected static final Random RANDOM = new Random();
    private static final int TTL_MULTIPLIER = 10;
    protected final String nodeId;
    protected final Duration duration;
    protected final Duration pollDelay;
    protected final KeyValueStore kvStore;

    public static void runAtomically(String key, Duration duration, Duration pollDelay, Runnable runnable) {
        if (!Framework.isBooleanPropertyTrue((String)CLUSTERING_ENABLED_PROP)) {
            runnable.run();
            return;
        }
        new ClusterLockHelper(ClusterLockHelper.getNodeId(), duration, pollDelay).runAtomically(key, runnable);
    }

    protected static String getNodeId() {
        String nodeId = Framework.getProperty((String)NODE_ID_PROP);
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return String.valueOf(RANDOM.nextLong());
        }
        return nodeId.trim();
    }

    public ClusterLockHelper(String nodeId, Duration duration, Duration pollDelay) {
        this.nodeId = nodeId;
        this.duration = duration;
        this.pollDelay = pollDelay;
        this.kvStore = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(KV_STORE_NAME);
    }

    public void runAtomically(String key, Runnable runnable) {
        this.runInSeparateTransaction(() -> this.runAtomicallyInternal(key, runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInSeparateTransaction(Runnable runnable) {
        boolean transaction = TransactionHelper.isTransactionActiveOrMarkedRollback();
        if (transaction) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        boolean completedAbruptly = true;
        try {
            if (transaction) {
                TransactionHelper.runInTransaction((Runnable)runnable);
            } else {
                runnable.run();
            }
            completedAbruptly = false;
        }
        finally {
            if (transaction) {
                try {
                    TransactionHelper.startTransaction();
                }
                finally {
                    if (completedAbruptly) {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAtomicallyInternal(String key, Runnable runnable) {
        String lockInfo = this.tryLock(key);
        if (lockInfo != null) {
            try {
                runnable.run();
            }
            finally {
                this.unLock(key, lockInfo);
            }
        } else {
            throw new RuntimeServiceException("Failed to acquire lock '" + key + "' after " + this.duration.getSeconds() + "s, owner: " + this.getLock(key));
        }
    }

    protected String tryLock(String key) {
        log.debug("Trying to lock '{}'", (Object)key);
        long deadline = System.nanoTime() + this.duration.toNanos();
        long ttl = this.duration.multipliedBy(10L).getSeconds();
        do {
            String lockInfo;
            if (this.kvStore.compareAndSet(key, null, lockInfo = "node=" + this.nodeId + " time=" + Instant.now(), ttl)) {
                log.debug("Lock '{}' acquired after {}ms", new Supplier[]{() -> key, () -> (System.nanoTime() - (deadline - this.duration.toNanos())) / 1000000L});
                return lockInfo;
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> key;
            supplierArray[1] = this.pollDelay::toMillis;
            log.debug("  Sleeping on busy lock '{}' for {}ms", supplierArray);
            try {
                Thread.sleep(this.pollDelay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeServiceException((Throwable)e);
            }
        } while (System.nanoTime() < deadline);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> key;
        supplierArray[1] = this.duration::getSeconds;
        log.debug("Failed to acquire lock '{}' after {}s", supplierArray);
        return null;
    }

    protected void unLock(String key, String lockInfo) {
        log.debug("Unlocking '{}'", (Object)key);
        if (this.kvStore.compareAndSet(key, lockInfo, null)) {
            return;
        }
        String current = this.kvStore.getString(key);
        if (current == null) {
            log.warn("Unlocking '{}' but the lock had already expired; consider increasing the try duration for this lock", (Object)key);
        } else {
            log.error("Failed to unlock '{}', the lock expired and has a new owner: {}; consider increasing the try duration for this lock", (Object)key, (Object)this.getLock(key));
        }
    }

    protected String getLock(String key) {
        return this.kvStore.getString(key);
    }
}

