/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;

public class TargetResourceLocator {
    protected final ClassLoader loader;
    protected final Path basepath;

    public TargetResourceLocator(Class<?> clazz) {
        this.basepath = this.basepath(clazz);
        this.loader = clazz.getClassLoader();
    }

    public Path getBasepath() {
        return this.basepath;
    }

    protected int depthOfClass(String name) {
        int depth = 0;
        int index = name.indexOf(46);
        while (index > 0) {
            ++depth;
            index = name.indexOf(46, index + 1);
        }
        return depth;
    }

    protected Path basepath(Class<?> clazz) {
        String name = clazz.getName();
        int depth = this.depthOfClass(name) + 1;
        try {
            Path path = this.toPath(clazz.getResource("/".concat(name).replace('.', '/').concat(".class")).toURI());
            Path root = path.getRoot();
            if (path.getNameCount() > depth) {
                path = path.subpath(0, path.getNameCount() - depth);
                path = root.resolve(path);
            }
            return path;
        }
        catch (IOException | URISyntaxException cause) {
            throw new AssertionError("Cannot convert " + name + " to base dir", cause);
        }
    }

    public URL getTargetTestResource(String name) throws IOException {
        try {
            Enumeration<URL> resources = this.loader.getResources(name);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (!resources.hasMoreElements()) {
                    return resource;
                }
                URI uri = resource.toURI();
                Path path = this.toPath(uri);
                if (!path.getFileSystem().equals(this.basepath.getFileSystem()) || !path.startsWith(this.basepath)) continue;
                return path.toUri().toURL();
            }
        }
        catch (URISyntaxException cause) {
            throw new AssertionError("Cannot find location of " + name, cause);
        }
        return null;
    }

    protected Path toPath(URI uri) throws IOException {
        HashMap env = new HashMap();
        String[] array = uri.toString().split("!");
        if (array.length == 1) {
            return Paths.get(uri);
        }
        try (FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), env);){
            Path path = fs.getPath(array[1], new String[0]);
            return path;
        }
    }
}

