/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.targetplatforms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.targetplatforms.api.TargetPlatformFilter;
import org.nuxeo.targetplatforms.api.impl.TargetPlatformFilterImpl;
import org.nuxeo.targetplatforms.api.service.TargetPlatformService;
import org.nuxeo.targetplatforms.io.JSONExporter;

@WebObject(type="target-platforms")
@Produces(value={"application/json"})
public class TargetPlatformObject
extends DefaultObject {
    private static final String PUBLIC_TP_CACHE_KEY = "PUBLIC_TP";
    private static final LoadingCache<String, String> PUBLIC_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).refreshAfterWrite(10L, TimeUnit.MINUTES).recordStats().maximumSize(5L).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return key;
        }
    });

    @GET
    public Object doGet() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="public")
    public Object doGetPublic() throws Exception {
        String platforms = (String)PUBLIC_CACHE.get((Object)PUBLIC_TP_CACHE_KEY, () -> {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
                ArrayList res = tps.getAvailableTargetPlatforms((TargetPlatformFilter)new TargetPlatformFilterImpl(false, true, true, false, null));
                if (res == null) {
                    res = new ArrayList();
                }
                JSONExporter.exportToJson(res, (OutputStream)baos, (boolean)false);
                String string = new String(baos.toByteArray());
                return string;
            }
        });
        return Response.status((Response.Status)Response.Status.OK).entity((Object)platforms).build();
    }
}

