/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.documentation;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.documentation.DefaultDocumentationType;
import org.nuxeo.apidoc.documentation.DocumentModelListReader;
import org.nuxeo.apidoc.documentation.DocumentationService;
import org.nuxeo.apidoc.search.ArtifactSearcher;
import org.nuxeo.apidoc.search.ArtifactSearcherImpl;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentationComponent
extends DefaultComponent
implements DocumentationService {
    public static final String DIRECTORY_NAME = "documentationTypes";
    public static final String Root_PATH = "/";
    public static final String Root_NAME = "nuxeo-api-doc";
    public static final String Read_Grp = "Everyone";
    public static final String Write_Grp = "DocContributors";
    protected static final Log log = LogFactory.getLog(DocumentationComponent.class);
    protected final ArtifactSearcher searcher = new ArtifactSearcherImpl();

    protected DocumentModel getDocumentationRoot(CoreSession session) throws ClientException {
        PathRef rootRef = new PathRef("/nuxeo-api-doc");
        if (session.exists((DocumentRef)rootRef)) {
            return session.getDocument((DocumentRef)rootRef);
        }
        UnrestrictedRootCreator creator = new UnrestrictedRootCreator(session);
        creator.runUnrestricted();
        session.save();
        return session.getDocument(creator.getRootRef());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(DocumentationService.class)) {
            return (T)this;
        }
        if (adapter.isAssignableFrom(ArtifactSearcher.class)) {
            return (T)this.searcher;
        }
        return null;
    }

    @Override
    public Map<String, List<DocumentationItem>> listDocumentationItems(CoreSession session, String category, String targetType) throws Exception {
        String query = "SELECT * FROM NXDocumentation WHERE ecm:currentLifeCycleState <> 'deleted'";
        if (category != null) {
            query = query + " AND nxdoc:type = " + NXQL.escapeString((String)category);
        }
        if (targetType != null) {
            query = query + " AND nxdoc:targetType = " + NXQL.escapeString((String)targetType);
        }
        query = query + " ORDER BY nxdoc:documentationId, dc:modified";
        DocumentModelList docs = session.query(query);
        HashMap<String, ArrayList<DocumentationItem>> sortMap = new HashMap<String, ArrayList<DocumentationItem>>();
        for (Object doc : docs) {
            DocumentationItem item = (DocumentationItem)doc.getAdapter(DocumentationItem.class);
            ArrayList<DocumentationItem> alternatives = (ArrayList<DocumentationItem>)sortMap.get(item.getId());
            if (alternatives == null) {
                alternatives = new ArrayList<DocumentationItem>();
                alternatives.add(item);
                sortMap.put(item.getId(), alternatives);
                continue;
            }
            alternatives.add(item);
        }
        ArrayList<DocumentationItem> result = new ArrayList<DocumentationItem>();
        for (String documentationId : sortMap.keySet()) {
            DocumentationItem bestDoc = (DocumentationItem)((List)sortMap.get(documentationId)).get(0);
            result.add(bestDoc);
        }
        HashMap<String, List<DocumentationItem>> sortedResult = new HashMap<String, List<DocumentationItem>>();
        Map<String, String> categories = this.getCategories();
        for (DocumentationItem item : result) {
            String key = item.getType();
            String label = categories.get(key);
            if (sortedResult.containsKey(label)) {
                ((List)sortedResult.get(label)).add(item);
                continue;
            }
            ArrayList<DocumentationItem> items = new ArrayList<DocumentationItem>();
            items.add(item);
            sortedResult.put(label, items);
        }
        return sortedResult;
    }

    @Override
    public List<DocumentationItem> findDocumentItems(CoreSession session, NuxeoArtifact nxItem) throws ClientException {
        String id = nxItem.getId();
        String type = nxItem.getArtifactType();
        String query = "SELECT * FROM NXDocumentation WHERE nxdoc:target = " + NXQL.escapeString((String)id) + " AND " + "nxdoc:targetType" + " = " + NXQL.escapeString((String)type) + " AND " + "ecm:currentLifeCycleState <> 'deleted'" + " ORDER BY " + "nxdoc:documentationId" + ", dc:modified";
        DocumentModelList docs = session.query(query);
        HashMap<String, ArrayList<DocumentationItem>> sortMap = new HashMap<String, ArrayList<DocumentationItem>>();
        for (DocumentModel doc : docs) {
            DocumentationItem item = (DocumentationItem)doc.getAdapter(DocumentationItem.class);
            ArrayList<DocumentationItem> alternatives = (ArrayList<DocumentationItem>)sortMap.get(item.getId());
            if (alternatives == null) {
                alternatives = new ArrayList<DocumentationItem>();
                alternatives.add(item);
                sortMap.put(item.getId(), alternatives);
                continue;
            }
            alternatives.add(item);
        }
        ArrayList<DocumentationItem> result = new ArrayList<DocumentationItem>();
        for (String documentationId : sortMap.keySet()) {
            DocumentationItem bestDoc = this.findBestMatch(nxItem, (List)sortMap.get(documentationId));
            result.add(bestDoc);
        }
        return result;
    }

    protected DocumentationItem findBestMatch(NuxeoArtifact nxItem, List<DocumentationItem> docItems) {
        for (DocumentationItem docItem : docItems) {
            if (!docItem.getApplicableVersion().contains(nxItem.getVersion())) continue;
            return docItem;
        }
        return docItems.get(0);
    }

    @Override
    public List<DocumentationItem> findDocumentationItemVariants(CoreSession session, DocumentationItem item) throws ClientException {
        ArrayList<DocumentationItem> result = new ArrayList<DocumentationItem>();
        List<DocumentModel> docs = this.findDocumentModelVariants(session, item);
        for (DocumentModel doc : docs) {
            DocumentationItem docItem = (DocumentationItem)doc.getAdapter(DocumentationItem.class);
            if (docItem == null) continue;
            result.add(docItem);
        }
        Collections.sort(result);
        Collections.reverse(result);
        return result;
    }

    public List<DocumentModel> findDocumentModelVariants(CoreSession session, DocumentationItem item) throws ClientException {
        String id = item.getId();
        String type = item.getTargetType();
        String query = "SELECT * FROM NXDocumentation WHERE nxdoc:documentationId = " + NXQL.escapeString((String)id) + " AND " + "nxdoc:targetType" + " = " + NXQL.escapeString((String)type) + " AND " + "ecm:currentLifeCycleState <> 'deleted'";
        query = query + " ORDER BY dc:created";
        return session.query(query);
    }

    @Override
    public DocumentationItem createDocumentationItem(CoreSession session, NuxeoArtifact item, String title, String content, String type, List<String> applicableVersions, boolean approved, String renderingType) throws ClientException {
        DocumentModel doc = session.createDocumentModel("NXDocumentation");
        String name = title + '-' + item.getId();
        name = IdUtils.generateId((String)name, (String)"-", (boolean)true, (int)64);
        UUID docUUID = UUID.nameUUIDFromBytes(name.getBytes());
        doc.setPathInfo(this.getDocumentationRoot(session).getPathAsString(), name);
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        StringBlob blob = new StringBlob(content);
        blob.setFilename(type);
        blob.setMimeType("text/plain");
        blob.setEncoding("utf-8");
        doc.setPropertyValue("file:content", (Serializable)blob);
        doc.setPropertyValue("nxdoc:target", (Serializable)((Object)item.getId()));
        doc.setPropertyValue("nxdoc:targetType", (Serializable)((Object)item.getArtifactType()));
        doc.setPropertyValue("nxdoc:documentationId", (Serializable)((Object)docUUID.toString()));
        doc.setPropertyValue("nxdoc:nuxeoApproved", (Serializable)Boolean.valueOf(approved));
        doc.setPropertyValue("nxdoc:type", (Serializable)((Object)type));
        doc.setPropertyValue("nxdoc:renderingType", (Serializable)((Object)renderingType));
        doc.setPropertyValue("nxdoc:applicableVersions", (Serializable)((Object)applicableVersions));
        doc = session.createDocument(doc);
        session.save();
        return (DocumentationItem)doc.getAdapter(DocumentationItem.class);
    }

    @Override
    public void deleteDocumentationItem(CoreSession session, String uuid) throws ClientException {
        DocumentModel doc = session.getDocument((DocumentRef)new IdRef(uuid));
        if (!doc.getType().equals("NXDocumentation")) {
            throw new RuntimeException("Invalid documentation item");
        }
        DocumentModel root = this.getDocumentationRoot(session);
        DocumentModel parent = session.getDocument(doc.getParentRef());
        if (!root.getId().equals(parent.getId())) {
            throw new RuntimeException("Invalid documentation item");
        }
        session.removeDocument(doc.getRef());
    }

    protected DocumentModel updateDocumentModel(DocumentModel doc, DocumentationItem item) throws ClientException {
        doc.setPropertyValue("dc:title", (Serializable)((Object)item.getTitle()));
        StringBlob content = new StringBlob(item.getContent());
        content.setMimeType("text/plain");
        content.setFilename(item.getTypeLabel());
        content.setEncoding("utf-8");
        doc.setPropertyValue("file:content", (Serializable)content);
        doc.setPropertyValue("nxdoc:documentationId", (Serializable)((Object)item.getId()));
        doc.setPropertyValue("nxdoc:nuxeoApproved", (Serializable)Boolean.valueOf(item.isApproved()));
        doc.setPropertyValue("nxdoc:renderingType", (Serializable)((Object)item.getRenderingType()));
        doc.setPropertyValue("nxdoc:applicableVersions", (Serializable)((Object)item.getApplicableVersion()));
        ArrayList atts = new ArrayList();
        Map<String, String> attData = item.getAttachments();
        if (attData != null && attData.size() > 0) {
            for (String fileName : attData.keySet()) {
                HashMap<String, Object> fileItem = new HashMap<String, Object>();
                StringBlob blob = new StringBlob(attData.get(fileName));
                blob.setFilename(fileName);
                blob.setMimeType("text/plain");
                blob.setEncoding("utf-8");
                fileItem.put("file", (Serializable)blob);
                fileItem.put("filename", fileName);
                atts.add(fileItem);
            }
            doc.setPropertyValue("files:files", (Serializable)atts);
        }
        return doc;
    }

    @Override
    public DocumentationItem updateDocumentationItem(CoreSession session, DocumentationItem docItem) throws ClientException {
        DocumentModel existingDoc = session.getDocument((DocumentRef)new IdRef(docItem.getUUID()));
        DocumentationItem existingDocItem = (DocumentationItem)existingDoc.getAdapter(DocumentationItem.class);
        List<String> applicableVersions = docItem.getApplicableVersion();
        List<String> existingApplicableVersions = existingDocItem.getApplicableVersion();
        ArrayList<String> discardedVersion = new ArrayList<String>();
        for (String string : existingApplicableVersions) {
            if (applicableVersions.contains(string)) continue;
            discardedVersion.add(string);
        }
        if (discardedVersion.size() > 0) {
            String newName = existingDoc.getName();
            Collections.sort(discardedVersion);
            for (String version : discardedVersion) {
                newName = newName + "_" + version;
            }
            newName = IdUtils.generateId((String)newName, (String)"-", (boolean)true, (int)100);
            DocumentModel documentModel = session.copy(existingDoc.getRef(), existingDoc.getParentRef(), newName);
            documentModel.setPropertyValue("nxdoc:applicableVersions", (Serializable)discardedVersion);
            DocumentModel documentModel2 = session.saveDocument(documentModel);
        }
        existingDoc = this.updateDocumentModel(existingDoc, docItem);
        existingDoc = session.saveDocument(existingDoc);
        session.save();
        return (DocumentationItem)existingDoc.getAdapter(DocumentationItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DocumentModel> listCategories() throws Exception {
        DirectoryService dm = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = dm.open(DIRECTORY_NAME);){
            DocumentModelList documentModelList = session.query(Collections.emptyMap(), null, Collections.singletonMap("ordering", "ASC"));
            return documentModelList;
        }
    }

    @Override
    public List<String> getCategoryKeys() throws Exception {
        ArrayList<String> categories = new ArrayList<String>();
        for (DocumentModel entry : this.listCategories()) {
            categories.add(entry.getId());
        }
        return categories;
    }

    @Override
    public Map<String, String> getCategories() throws Exception {
        LinkedHashMap<String, String> categories = new LinkedHashMap<String, String>();
        if (!Framework.isTestModeSet()) {
            for (DocumentModel entry : this.listCategories()) {
                String value = (String)entry.getProperty("vocabulary", "label");
                categories.put(entry.getId(), value);
            }
        } else {
            categories.put("description", "Description");
            categories.put("codeSample", "Code Sample");
            categories.put("howTo", "How To");
        }
        return categories;
    }

    @Override
    public void exportDocumentation(CoreSession session, OutputStream out) {
        try {
            String query = "SELECT * FROM NXDocumentation WHERE ecm:currentLifeCycleState <> 'deleted'";
            DocumentModelList docList = session.query(query);
            DocumentModelListReader reader = new DocumentModelListReader((List<DocumentModel>)docList);
            NuxeoArchiveWriter writer = new NuxeoArchiveWriter(out);
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while exporting documentation", (Throwable)e);
        }
    }

    @Override
    public void importDocumentation(CoreSession session, InputStream is) {
        try {
            String importPath = this.getDocumentationRoot(session).getPathAsString();
            NuxeoArchiveReader reader = new NuxeoArchiveReader(is);
            DocumentModelWriter writer = new DocumentModelWriter(session, importPath);
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            DocumentTransformer rootCutter = new DocumentTransformer(){

                public boolean transform(ExportedDocument doc) {
                    doc.setPath(doc.getPath().removeFirstSegments(1));
                    return true;
                }
            };
            pipe.addTransformer(rootCutter);
            pipe.run();
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while importing documentation", (Throwable)e);
        }
    }

    @Override
    public String getDocumentationStats(CoreSession session) {
        String result = "";
        try {
            String query = "SELECT * FROM NXDocumentation WHERE ecm:currentLifeCycleState <> 'deleted'";
            DocumentModelList docList = session.query(query);
            result = docList.size() + " documents";
        }
        catch (Exception e) {
            log.error((Object)"Error while exporting documentation", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, DocumentationItem> getAvailableDescriptions(CoreSession session, String targetType) throws Exception {
        Map<String, List<DocumentationItem>> itemsByCat = this.listDocumentationItems(session, DefaultDocumentationType.DESCRIPTION.getValue(), targetType);
        HashMap<String, DocumentationItem> result = new HashMap<String, DocumentationItem>();
        if (itemsByCat.size() > 0) {
            String labelKey = itemsByCat.keySet().iterator().next();
            List<DocumentationItem> docs = itemsByCat.get(labelKey);
            for (DocumentationItem doc : docs) {
                result.put(doc.getTarget(), doc);
            }
        }
        return result;
    }

    class UnrestrictedRootCreator
    extends UnrestrictedSessionRunner {
        protected DocumentRef rootRef;

        public DocumentRef getRootRef() {
            return this.rootRef;
        }

        UnrestrictedRootCreator(CoreSession session) {
            super(session);
        }

        public void run() throws ClientException {
            DocumentModel root = this.session.createDocumentModel(DocumentationComponent.Root_PATH, DocumentationComponent.Root_NAME, "Folder");
            root.setProperty("dublincore", "title", (Object)DocumentationComponent.Root_NAME);
            root = this.session.createDocument(root);
            ACLImpl acl = new ACLImpl();
            acl.add((Object)new ACE(DocumentationComponent.Write_Grp, "Write", true));
            acl.add((Object)new ACE(DocumentationComponent.Read_Grp, "Read", true));
            ACP acp = root.getACP();
            acp.addACL((ACL)acl);
            this.session.setACP(root.getRef(), acp, true);
            this.rootRef = root.getRef();
            this.session.save();
        }
    }
}

