/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ValueEnforcer {
    private ValueEnforcer() {
    }

    @Nonnull
    public static <T> T notNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException("The value of '" + string + "' may not be null!");
        }
        return t;
    }

    @Nonnull
    public static <T extends CharSequence> T notEmpty(T t, String string) {
        ValueEnforcer.notNull(t, string);
        if (t.length() == 0) {
            throw new IllegalArgumentException("The value of the string '" + string + "' may not be empty!");
        }
        return t;
    }

    @Nonnull
    public static <T> T[] notEmpty(T[] TArray, String string) {
        ValueEnforcer.notNull(TArray, string);
        if (TArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return TArray;
    }

    @Nonnull
    public static boolean[] notEmpty(boolean[] blArray, String string) {
        ValueEnforcer.notNull(blArray, string);
        if (blArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return blArray;
    }

    @Nonnull
    public static byte[] notEmpty(byte[] byArray, String string) {
        ValueEnforcer.notNull(byArray, string);
        if (byArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return byArray;
    }

    @Nonnull
    public static char[] notEmpty(char[] cArray, String string) {
        ValueEnforcer.notNull(cArray, string);
        if (cArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return cArray;
    }

    @Nonnull
    public static double[] notEmpty(double[] dArray, String string) {
        ValueEnforcer.notNull(dArray, string);
        if (dArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return dArray;
    }

    @Nonnull
    public static float[] notEmpty(float[] fArray, String string) {
        ValueEnforcer.notNull(fArray, string);
        if (fArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return fArray;
    }

    @Nonnull
    public static int[] notEmpty(int[] nArray, String string) {
        ValueEnforcer.notNull(nArray, string);
        if (nArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return nArray;
    }

    @Nonnull
    public static long[] notEmpty(long[] lArray, String string) {
        ValueEnforcer.notNull(lArray, string);
        if (lArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return lArray;
    }

    @Nonnull
    public static short[] notEmpty(short[] sArray, String string) {
        ValueEnforcer.notNull(sArray, string);
        if (sArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + string + "' may not be empty!");
        }
        return sArray;
    }

    @Nonnull
    public static <T extends Collection<?>> T notEmpty(T t, String string) {
        ValueEnforcer.notNull(t, string);
        if (t.isEmpty()) {
            throw new IllegalArgumentException("The value of the collection '" + string + "' may not be empty!");
        }
        return t;
    }

    @Nonnull
    public static <T extends Iterable<?>> T notEmpty(T t, String string) {
        ValueEnforcer.notNull(t, string);
        if (!t.iterator().hasNext()) {
            throw new IllegalArgumentException("The value of the iterable '" + string + "' may not be empty!");
        }
        return t;
    }

    @Nonnull
    public static <T extends Map<?, ?>> T notEmpty(T t, String string) {
        ValueEnforcer.notNull(t, string);
        if (t.isEmpty()) {
            throw new IllegalArgumentException("The value of the map '" + string + "' may not be empty!");
        }
        return t;
    }

    @Nonnull
    public static <T> T[] notEmptyNoNullValue(T[] TArray, String string) {
        ValueEnforcer.notEmpty(TArray, string);
        int n = 0;
        for (T t : TArray) {
            if (t == null) {
                throw new IllegalArgumentException("Item " + n + " of array '" + string + "' may not be null!");
            }
            ++n;
        }
        return TArray;
    }

    @Nonnull
    public static <T extends Iterable<?>> T notEmptyNoNullValue(T t, String string) {
        ValueEnforcer.notEmpty(t, string);
        int n = 0;
        for (Object obj : t) {
            if (obj == null) {
                throw new IllegalArgumentException("Item " + n + " of iterable '" + string + "' may not be null!");
            }
            ++n;
        }
        return t;
    }

    @Nonnull
    public static <T extends Collection<?>> T notEmptyNoNullValue(T t, String string) {
        ValueEnforcer.notEmpty(t, string);
        int n = 0;
        for (Object obj : t) {
            if (obj == null) {
                throw new IllegalArgumentException("Item " + n + " of collection '" + string + "' may not be null!");
            }
            ++n;
        }
        return t;
    }

    @Nonnull
    public static <T> T notNullNotEquals(@Nonnull T t, String string, @Nonnull T t2) {
        ValueEnforcer.notNull(t, string);
        ValueEnforcer.notNull(t2, "UnexpectedValue");
        if (t.equals(t2)) {
            throw new NullPointerException("The value of '" + string + "' may not be equal to " + t2 + "!");
        }
        return t;
    }

    public static short isGE0(short s, String string) {
        if (s < 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= 0! The current value is: " + s);
        }
        return s;
    }

    public static int isGE0(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= 0! The current value is: " + n);
        }
        return n;
    }

    public static long isGE0(long l, String string) {
        if (l < 0L) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= 0! The current value is: " + l);
        }
        return l;
    }

    public static double isGE0(double d, String string) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= 0! The current value is: " + d);
        }
        return d;
    }

    public static float isGE0(float f, String string) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= 0! The current value is: " + f);
        }
        return f;
    }

    @Nonnull
    public static BigDecimal isGE0(@Nonnull BigDecimal bigDecimal, String string) {
        ValueEnforcer.notNull(bigDecimal, string);
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= 0! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    @Nonnull
    public static BigInteger isGE0(@Nonnull BigInteger bigInteger, String string) {
        ValueEnforcer.notNull(bigInteger, string);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= 0! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    public static short isGT0(short s, String string) {
        if (s <= 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > 0! The current value is: " + s);
        }
        return s;
    }

    public static int isGT0(int n, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > 0! The current value is: " + n);
        }
        return n;
    }

    public static long isGT0(long l, String string) {
        if (l <= 0L) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > 0! The current value is: " + l);
        }
        return l;
    }

    public static double isGT0(double d, String string) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > 0! The current value is: " + d);
        }
        return d;
    }

    public static float isGT0(float f, String string) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > 0! The current value is: " + f);
        }
        return f;
    }

    @Nonnull
    public static BigDecimal isGT0(@Nonnull BigDecimal bigDecimal, String string) {
        ValueEnforcer.notNull(bigDecimal, string);
        if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > 0! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    @Nonnull
    public static BigInteger isGT0(@Nonnull BigInteger bigInteger, String string) {
        ValueEnforcer.notNull(bigInteger, string);
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > 0! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    public static short isBetweenInclusive(short s, String string, short s2, short s3) {
        if (s < s2 || s > s3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= " + s2 + " and <= " + s3 + "! The current value is: " + s);
        }
        return s;
    }

    public static int isBetweenInclusive(int n, String string, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= " + n2 + " and <= " + n3 + "! The current value is: " + n);
        }
        return n;
    }

    public static long isBetweenInclusive(long l, String string, long l2, long l3) {
        if (l < l2 || l > l3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= " + l2 + " and <= " + l3 + "! The current value is: " + l);
        }
        return l;
    }

    public static float isBetweenInclusive(float f, String string, float f2, float f3) {
        if (f < f2 || f > f3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= " + f2 + " and <= " + f3 + "! The current value is: " + f);
        }
        return f;
    }

    public static double isBetweenInclusive(double d, String string, double d2, double d3) {
        if (d < d2 || d > d3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= " + d2 + " and <= " + d3 + "! The current value is: " + d);
        }
        return d;
    }

    public static BigDecimal isBetweenInclusive(@Nonnull BigDecimal bigDecimal, String string, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        ValueEnforcer.notNull(bigDecimal, string);
        ValueEnforcer.notNull(bigDecimal2, "LowerBoundInclusive");
        ValueEnforcer.notNull(bigDecimal3, "UpperBoundInclusive");
        if (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= " + bigDecimal2 + " and <= " + bigDecimal3 + "! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    public static BigInteger isBetweenInclusive(@Nonnull BigInteger bigInteger, String string, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        ValueEnforcer.notNull(bigInteger, string);
        ValueEnforcer.notNull(bigInteger2, "LowerBoundInclusive");
        ValueEnforcer.notNull(bigInteger3, "UpperBoundInclusive");
        if (bigInteger.compareTo(bigInteger2) < 0 || bigInteger.compareTo(bigInteger3) > 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be >= " + bigInteger2 + " and <= " + bigInteger3 + "! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    public static short isBetweenExclusive(short s, String string, short s2, short s3) {
        if (s <= s2 || s >= s3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > " + s2 + " and < " + s3 + "! The current value is: " + s);
        }
        return s;
    }

    public static int isBetweenExclusive(int n, String string, int n2, int n3) {
        if (n <= n2 || n >= n3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > " + n2 + " and < " + n3 + "! The current value is: " + n);
        }
        return n;
    }

    public static long isBetweenExclusive(long l, String string, long l2, long l3) {
        if (l <= l2 || l >= l3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > " + l2 + " and < " + l3 + "! The current value is: " + l);
        }
        return l;
    }

    public static float isBetweenExclusive(float f, String string, float f2, float f3) {
        if (f <= f2 || f >= f3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > " + f2 + " and < " + f3 + "! The current value is: " + f);
        }
        return f;
    }

    public static double isBetweenExclusive(double d, String string, double d2, double d3) {
        if (d <= d2 || d >= d3) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > " + d2 + " and < " + d3 + "! The current value is: " + d);
        }
        return d;
    }

    public static BigDecimal isBetweenExclusive(@Nonnull BigDecimal bigDecimal, String string, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        ValueEnforcer.notNull(bigDecimal, string);
        ValueEnforcer.notNull(bigDecimal2, "LowerBoundInclusive");
        ValueEnforcer.notNull(bigDecimal3, "UpperBoundInclusive");
        if (bigDecimal.compareTo(bigDecimal2) <= 0 || bigDecimal.compareTo(bigDecimal3) >= 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > " + bigDecimal2 + " and < " + bigDecimal3 + "! The current value is: " + bigDecimal);
        }
        return bigDecimal;
    }

    public static BigInteger isBetweenExclusive(@Nonnull BigInteger bigInteger, String string, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        ValueEnforcer.notNull(bigInteger, string);
        ValueEnforcer.notNull(bigInteger2, "LowerBoundInclusive");
        ValueEnforcer.notNull(bigInteger3, "UpperBoundInclusive");
        if (bigInteger.compareTo(bigInteger2) <= 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            throw new IllegalArgumentException("The value of '" + string + "' must be > " + bigInteger2 + " and < " + bigInteger3 + "! The current value is: " + bigInteger);
        }
        return bigInteger;
    }

    private static void _isArrayOfsLen(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        ValueEnforcer.isGE0(n2, "Offset");
        ValueEnforcer.isGE0(n3, "Length");
        if (n2 + n3 > n) {
            throw new IllegalArgumentException("Offset (" + n2 + ") + length (" + n3 + ") exceeds array length (" + n + ")");
        }
    }

    public static void isArrayOfsLen(@Nonnull Object[] objectArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(objectArray, "Array");
        ValueEnforcer._isArrayOfsLen(objectArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull boolean[] blArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(blArray, "Array");
        ValueEnforcer._isArrayOfsLen(blArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(byArray, "Array");
        ValueEnforcer._isArrayOfsLen(byArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(cArray, "Array");
        ValueEnforcer._isArrayOfsLen(cArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull double[] dArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(dArray, "Array");
        ValueEnforcer._isArrayOfsLen(dArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(fArray, "Array");
        ValueEnforcer._isArrayOfsLen(fArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(nArray, "Array");
        ValueEnforcer._isArrayOfsLen(nArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(lArray, "Array");
        ValueEnforcer._isArrayOfsLen(lArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(sArray, "Array");
        ValueEnforcer._isArrayOfsLen(sArray.length, n, n2);
    }
}

