/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.callback;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.callback.INonThrowingCallable;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AdapterRunnableToCallable<DATATYPE>
implements INonThrowingCallable<DATATYPE> {
    private final Runnable m_aRunnable;
    private final DATATYPE m_aResult;

    public AdapterRunnableToCallable(@Nonnull Runnable runnable) {
        this(runnable, null);
    }

    public AdapterRunnableToCallable(@Nonnull Runnable runnable, @Nullable DATATYPE DATATYPE) {
        this.m_aRunnable = ValueEnforcer.notNull(runnable, "Runnable");
        this.m_aResult = DATATYPE;
    }

    @Override
    @Nullable
    public DATATYPE call() {
        this.m_aRunnable.run();
        return this.m_aResult;
    }

    public String toString() {
        return new ToStringGenerator(this).append("runnable", this.m_aRunnable).append("result", this.m_aResult).toString();
    }

    @Nonnull
    public static AdapterRunnableToCallable<Object> createAdapter(@Nonnull Runnable runnable) {
        return new AdapterRunnableToCallable<Object>(runnable);
    }

    @Nonnull
    public static <DATATYPE> AdapterRunnableToCallable<DATATYPE> createAdapter(@Nonnull Runnable runnable, @Nullable DATATYPE DATATYPE) {
        return new AdapterRunnableToCallable<DATATYPE>(runnable, DATATYPE);
    }
}

