/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterEndsWith
implements FilenameFilter {
    private final String m_sSuffix;

    public FilenameFilterEndsWith(@Nonnull @Nonempty String string) {
        this.m_sSuffix = ValueEnforcer.notEmpty(string, "Suffix");
    }

    @Nonnull
    @Nonempty
    public String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public boolean accept(@Nullable File file, @Nullable String string) {
        String string2 = FilenameHelper.getSecureFilename(string);
        return string2 != null && string2.endsWith(this.m_sSuffix);
    }

    public String toString() {
        return new ToStringGenerator(this).append("suffix", this.m_sSuffix).toString();
    }
}

