/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterMatchAnyRegEx
implements FilenameFilter {
    private final String[] m_aRegExs;

    public FilenameFilterMatchAnyRegEx(@Nonnull @Nonempty String string) {
        this(new String[]{string});
    }

    public FilenameFilterMatchAnyRegEx(String ... stringArray) {
        this.m_aRegExs = ArrayHelper.getCopy(ValueEnforcer.notEmpty(stringArray, "RegularExpressions"));
    }

    @Nonnull
    @ReturnsMutableCopy
    public String[] getRegularExpressions() {
        return ArrayHelper.getCopy(this.m_aRegExs);
    }

    @Override
    public boolean accept(@Nonnull File file, @Nonnull String string) {
        String string2 = FilenameHelper.getSecureFilename(string);
        if (string2 != null) {
            for (String string3 : this.m_aRegExs) {
                if (!RegExHelper.stringMatchesPattern(string3, string2)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return new ToStringGenerator(this).append("regExs", this.m_aRegExs).toString();
    }
}

