/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.resource;

import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.text.resource.Utf8ResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ResourceBundleUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ResourceBundleUtils.class);
    private static final ResourceBundleUtils s_aInstance = new ResourceBundleUtils();

    private ResourceBundleUtils() {
    }

    @Nullable
    public static ResourceBundle getResourceBundle(@Nonnull String string, @Nonnull Locale locale) {
        return ResourceBundleUtils.getResourceBundle(string, locale, ClassHelper.getDefaultClassLoader());
    }

    @Nullable
    public static ResourceBundle getResourceBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        try {
            return ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Nullable
    public static ResourceBundle getUtf8ResourceBundle(@Nonnull String string, @Nonnull Locale locale) {
        return ResourceBundleUtils.getUtf8ResourceBundle(string, locale, ClassHelper.getDefaultClassLoader());
    }

    @Nullable
    public static ResourceBundle getUtf8ResourceBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        try {
            return Utf8ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Nullable
    public static String getString(@Nullable ResourceBundle resourceBundle, @Nonnull @PropertyKey String string) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String getString(@Nonnull String string, @Nonnull Locale locale, @Nonnull @PropertyKey String string2) {
        return ResourceBundleUtils.getString(ResourceBundleUtils.getResourceBundle(string, locale), string2);
    }

    @Nullable
    public static String getString(@Nonnull String string, @Nonnull Locale locale, @Nonnull @PropertyKey String string2, @Nonnull ClassLoader classLoader) {
        return ResourceBundleUtils.getString(ResourceBundleUtils.getResourceBundle(string, locale, classLoader), string2);
    }

    @Nullable
    public static String getUtf8String(@Nonnull String string, @Nonnull Locale locale, @Nonnull @PropertyKey String string2) {
        return ResourceBundleUtils.getString(ResourceBundleUtils.getUtf8ResourceBundle(string, locale), string2);
    }

    @Nullable
    public static String getUtf8String(@Nonnull String string, @Nonnull Locale locale, @Nonnull @PropertyKey String string2, @Nonnull ClassLoader classLoader) {
        return ResourceBundleUtils.getString(ResourceBundleUtils.getUtf8ResourceBundle(string, locale, classLoader), string2);
    }

    public static void clearCache() {
        ResourceBundleUtils.clearCache(ClassHelper.getDefaultClassLoader());
    }

    public static void clearCache(@Nonnull ClassLoader classLoader) {
        ResourceBundle.clearCache(classLoader);
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Cache was cleared: " + ResourceBundle.class.getName() + "; classloader=" + classLoader);
        }
    }
}

