/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterProvider;
import com.phloc.commons.typeconvert.TypeConverterException;
import com.phloc.commons.typeconvert.TypeConverterProviderBestMatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class TypeConverter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(TypeConverter.class);
    private static final TypeConverter s_aInstance = new TypeConverter();

    private TypeConverter() {
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(boolean bl, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(bl, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(byte by, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(by, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(char c, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(Character.valueOf(c), clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(double d, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(d, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(float f, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(Float.valueOf(f), clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(int n, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(n, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(long l, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(l, clazz);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(short s, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(s, clazz);
    }

    public static boolean convertToBoolean(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Boolean.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Boolean bl = TypeConverter.convertIfNecessary(object, Boolean.class);
        return bl;
    }

    public static byte convertToByte(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Byte.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Byte by = TypeConverter.convertIfNecessary(object, Byte.class);
        return by;
    }

    public static char convertToChar(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Character.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Character c = TypeConverter.convertIfNecessary(object, Character.class);
        return c.charValue();
    }

    public static double convertToDouble(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Double.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Double d = TypeConverter.convertIfNecessary(object, Double.class);
        return d;
    }

    public static float convertToFloat(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Float.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Float f = TypeConverter.convertIfNecessary(object, Float.class);
        return f.floatValue();
    }

    public static int convertToInt(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Integer.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Integer n = TypeConverter.convertIfNecessary(object, Integer.class);
        return n;
    }

    public static long convertToLong(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Long.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Long l = TypeConverter.convertIfNecessary(object, Long.class);
        return l;
    }

    public static short convertToShort(@Nonnull Object object) {
        if (object == null) {
            throw new TypeConverterException(Short.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Short s = TypeConverter.convertIfNecessary(object, Short.class);
        return s;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertIfNecessary(@Nullable Object object, @Nonnull Class<DSTTYPE> clazz) {
        return TypeConverter.convertIfNecessary(TypeConverterProviderBestMatch.getInstance(), object, clazz);
    }

    @Nullable
    private static Class<?> _getUsableClass(@Nullable Class<?> clazz) {
        Class<?> clazz2 = ClassHelper.getPrimitiveWrapperClass(clazz);
        return clazz2 != null ? clazz2 : clazz;
    }

    @Nonnull
    private static Object _performConversion(@Nonnull ITypeConverterProvider iTypeConverterProvider, @Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull Object object) throws TypeConverterException {
        ITypeConverter iTypeConverter = iTypeConverterProvider.getTypeConverter(clazz, clazz2);
        if (iTypeConverter == null) {
            s_aLogger.warn("No type converter from '" + clazz.getName() + "' to '" + clazz2.getName() + "' was found");
            throw new TypeConverterException(clazz, clazz2, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        Object object2 = iTypeConverter.convert(object);
        if (object2 == null) {
            s_aLogger.warn("Type conversion from '" + object + "' of class '" + clazz.getName() + "' to '" + clazz2.getName() + "' with converter " + iTypeConverter + " failed");
            throw new TypeConverterException(clazz, clazz2, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return object2;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertIfNecessary(@Nonnull ITypeConverterProvider iTypeConverterProvider, @Nullable Object object, @Nonnull Class<DSTTYPE> clazz) throws TypeConverterException {
        Class<?> clazz2;
        ValueEnforcer.notNull(iTypeConverterProvider, "TypeConverterProvider");
        ValueEnforcer.notNull(clazz, "DstClass");
        if (object == null) {
            return null;
        }
        Class<?> clazz3 = object.getClass();
        Object object2 = ClassHelper.areConvertibleClasses(clazz3, clazz2 = TypeConverter._getUsableClass(clazz)) ? object : TypeConverter._performConversion(iTypeConverterProvider, clazz3, clazz2, object);
        Object object3 = object2;
        return (DSTTYPE)object3;
    }
}

